/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.InputStream;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import me.melchor9000.net.IOService;
import me.melchor9000.net.SSLAcceptor;
import me.melchor9000.net.SSLSocketConfigurator;
import me.melchor9000.net.TCPSocket;

public class SSLSocket
extends TCPSocket {
    public SSLSocket(IOService service) {
        super(service);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                SslContextBuilder ctx = SslContextBuilder.forClient();
                SslContext ctx2 = ctx.build();
                ch.pipeline().addLast("readManager", (ChannelHandler)SSLSocket.this.readManager);
                ch.pipeline().addBefore("readManager", "ssl", (ChannelHandler)ctx2.newHandler(ch.alloc()));
            }
        });
    }

    public SSLSocket(IOService service, final File certificate) {
        super(service);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                SslContextBuilder ctx = SslContextBuilder.forClient();
                ctx.trustManager(certificate.getAbsoluteFile());
                ch.pipeline().addLast("readManager", (ChannelHandler)SSLSocket.this.readManager);
                ch.pipeline().addBefore("readManager", "ssl", (ChannelHandler)ctx.build().newHandler(ch.alloc()));
            }
        });
    }

    public SSLSocket(IOService service, final InputStream certificate) {
        super(service);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                SslContextBuilder ctx = SslContextBuilder.forClient();
                ctx.trustManager(certificate);
                ch.pipeline().addLast("readManager", (ChannelHandler)SSLSocket.this.readManager);
                ch.pipeline().addBefore("readManager", "ssl", (ChannelHandler)ctx.build().newHandler(ch.alloc()));
            }
        });
    }

    public SSLSocket(IOService service, final SSLSocketConfigurator conf) {
        super(service);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                SslContextBuilder ctx = SslContextBuilder.forClient();
                conf.configure(ctx);
                SslHandler handler = ctx.build().newHandler(SSLSocket.this.channel.alloc());
                SSLParameters p = handler.engine().getSSLParameters();
                SSLParameters np = conf.changeParameters(p);
                if (np != null) {
                    handler.engine().setSSLParameters(np);
                }
                ch.pipeline().addLast("readManager", (ChannelHandler)SSLSocket.this.readManager);
                ch.pipeline().addBefore("readManager", "ssl", (ChannelHandler)handler);
            }
        });
    }

    SSLSocket(SSLAcceptor acceptor, SocketChannel socket, File publicKey, File privateKey, String passwd) throws SSLException {
        super(acceptor, socket);
        SslContext ctx = (passwd != null ? SslContextBuilder.forServer((File)publicKey, (File)privateKey, (String)passwd) : SslContextBuilder.forServer((File)publicKey, (File)privateKey)).build();
        socket.pipeline().addBefore("readManager", "ssl", (ChannelHandler)ctx.newHandler(socket.alloc()));
    }

    SSLSocket(SSLAcceptor acceptor, SocketChannel socket, InputStream publicKey, InputStream privateKey, String passwd) throws SSLException {
        super(acceptor, socket);
        SslContext ctx = (passwd != null ? SslContextBuilder.forServer((InputStream)publicKey, (InputStream)privateKey, (String)passwd) : SslContextBuilder.forServer((InputStream)publicKey, (InputStream)privateKey)).build();
        socket.pipeline().addBefore("readManager", "ssl", (ChannelHandler)ctx.newHandler(socket.alloc()));
    }
}

