/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import me.melchor9000.net.Callback;
import me.melchor9000.net.Future;
import me.melchor9000.net.FutureImpl;
import me.melchor9000.net.IOService;
import me.melchor9000.net.NettyFuture;
import me.melchor9000.net.Procedure;
import me.melchor9000.net.SocketNotCreated;
import me.melchor9000.net.resolver.DNSResolver;

public abstract class Socket
implements AutoCloseable {
    protected final IOService service;
    protected Channel channel;
    protected Bootstrap bootstrap;
    protected long bytesRead;
    protected long bytesWrote;
    private List<Callback<Socket>> readNotifications;

    Socket(IOService service) {
        this.service = service;
        this.bootstrap = (Bootstrap)new Bootstrap().group(service.group);
        this.readNotifications = new ArrayList<Callback<Socket>>();
    }

    Socket(IOService service, Channel channel) {
        this.service = service;
        this.channel = channel;
        this.readNotifications = new ArrayList<Callback<Socket>>();
    }

    @Override
    public void close() {
        this.checkSocketCreated("close");
        this.channel.close().syncUninterruptibly();
    }

    public Future<Void> closeAsync() {
        this.checkSocketCreated("closeAsync");
        return this.createFuture((io.netty.util.concurrent.Future)this.channel.close());
    }

    public void bind(SocketAddress local) {
        this.channel = this.bootstrap.bind(local).syncUninterruptibly().channel();
        this.bootstrap = null;
    }

    public void bind() {
        this.channel = this.bootstrap.bind(0).syncUninterruptibly().channel();
        this.bootstrap = null;
    }

    public void connect(SocketAddress endpoint) throws InterruptedException {
        this.channel = this.bootstrap.connect(endpoint).sync().channel();
        this.bootstrap = null;
    }

    public Future<Void> connectAsync(SocketAddress endpoint) {
        return this.createFuture((io.netty.util.concurrent.Future)this.bootstrap.connect(endpoint).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Socket.this.channel = future.channel();
                if (future.isSuccess()) {
                    Socket.this.bootstrap = null;
                }
            }
        }));
    }

    public void connect(InetAddress address, int port) throws InterruptedException {
        this.connect(new InetSocketAddress(address, port));
    }

    public void connect(String hostName, int port) throws UnknownHostException, InterruptedException {
        this.connectAsync(hostName, port).sync();
    }

    public Future<Void> connectAsync(InetAddress address, int port) {
        return this.connectAsync(new InetSocketAddress(address, port));
    }

    public Future<Void> connectAsync(String hostName, final int port) throws UnknownHostException {
        final DNSResolver resolver = new DNSResolver(this.service);
        final Future[] f = (Future[])Array.newInstance(Future.class, 1);
        final FutureImpl<Void> future = this.createFuture(new Procedure(){

            @Override
            public void call() {
                f[0].cancel(true);
            }
        });
        future.whenDone(new Callback<Future<Void>>(){

            @Override
            public void call(Future<Void> arg) {
                resolver.closeAsync();
            }
        });
        f[0] = resolver.resolveAsyncV4(hostName).whenDone(new Callback<Future<Iterable<InetAddress>>>(){

            @Override
            public void call(Future<Iterable<InetAddress>> arg) {
                if (arg.isSuccessful()) {
                    f[0] = Socket.this.connectAsync(arg.getValueNow().iterator().next(), port).whenDone(new Callback<Future<Void>>(){

                        @Override
                        public void call(Future<Void> arg) {
                            if (arg.isSuccessful()) {
                                future.postSuccess(null);
                            } else if (!arg.isCancelled()) {
                                future.postError(arg.cause());
                            }
                        }
                    });
                } else if (!arg.isCancelled()) {
                    future.postError(arg.cause());
                }
            }
        });
        return future;
    }

    public abstract long receive(ByteBuf var1, int var2) throws Throwable;

    public abstract Future<Long> receiveAsync(ByteBuf var1, int var2);

    public long send(ByteBuf data, int bytes) throws InterruptedException {
        this.checkSocketCreated("send");
        ByteBuf buff = ByteBufAllocator.DEFAULT.buffer(bytes).retain();
        buff.writeBytes(data, 0, bytes);
        this.channel.writeAndFlush((Object)buff).sync();
        buff.release();
        this.bytesWrote += (long)bytes;
        return bytes;
    }

    public Future<Void> sendAsync(ByteBuf data, final int bytes) {
        this.checkSocketCreated("sendAsync");
        final ByteBuf buff = ByteBufAllocator.DEFAULT.directBuffer(bytes).retain();
        buff.writeBytes(data, 0, bytes);
        return this.createFuture((io.netty.util.concurrent.Future)this.channel.writeAndFlush((Object)buff).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Socket.this.bytesWrote += (long)bytes;
                buff.release();
            }
        }));
    }

    public Future<Void> sendAsync(ByteBuf data) {
        return this.sendAsync(data, data.readableBytes());
    }

    public long receive(ByteBuf data) throws Throwable {
        return this.receive(data, data.writableBytes());
    }

    public Future<Long> receiveAsync(ByteBuf data) {
        return this.receiveAsync(data, data.writableBytes());
    }

    public long send(ByteBuf data) throws InterruptedException {
        return this.send(data, data.readableBytes());
    }

    public Future<Void> sendAsync(String data) {
        return this.sendAsync(Unpooled.wrappedBuffer((byte[])data.getBytes()));
    }

    public long send(String data) throws InterruptedException {
        return this.send(Unpooled.wrappedBuffer((byte[])data.getBytes()));
    }

    public <T> boolean setOption(ChannelOption<T> type, T value) {
        if (this.bootstrap == null) {
            return this.channel.config().setOption(type, value);
        }
        this.bootstrap.option(type, value);
        return true;
    }

    public SocketAddress remoteEndpoint() {
        return this.channel != null ? this.channel.remoteAddress() : null;
    }

    public SocketAddress localEndpoint() {
        return this.channel != null ? this.channel.localAddress() : null;
    }

    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    public long sendBytes() {
        return this.bytesWrote;
    }

    public long receivedBytes() {
        return this.bytesRead;
    }

    public void addOnDataReceivedListener(Callback<Socket> cbk) {
        this.readNotifications.add(cbk);
    }

    protected void fireReceivedData() throws Exception {
        for (Callback<Socket> cbk : this.readNotifications) {
            cbk.call(this);
        }
    }

    protected void checkSocketCreated(String method) {
        if (this.channel == null) {
            throw new SocketNotCreated("Cannot call " + method + " before creating the Socket", this);
        }
    }

    protected <ReturnType> FutureImpl<ReturnType> createFuture(Procedure whenCancelled) {
        return new FutureImpl(this.service, whenCancelled);
    }

    protected <ReturnType> Future<ReturnType> createFuture(io.netty.util.concurrent.Future<ReturnType> n) {
        return new NettyFuture<ReturnType>(n, this.service, null);
    }
}

