/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import me.melchor9000.net.Callback;
import me.melchor9000.net.Future;
import me.melchor9000.net.FutureImpl;
import me.melchor9000.net.IOService;
import me.melchor9000.net.Procedure;
import me.melchor9000.net.Socket;
import me.melchor9000.net.UDPSocket;
import me.melchor9000.net.resolver.DNSMessage;
import me.melchor9000.net.resolver.DNSQuery;
import me.melchor9000.net.resolver.DNSResolverCache;
import me.melchor9000.net.resolver.DNSResourceRecord;
import me.melchor9000.net.resolver.DNSUtils;

public class DNSResolver
implements AutoCloseable,
Callback<Socket> {
    private UDPSocket socket;
    private IOService service;
    private List<Request> requests;
    private int tries = 2;

    public DNSResolver(IOService service) {
        this.socket = new UDPSocket(service);
        this.service = service;
        this.requests = new ArrayList<Request>();
        this.socket.addOnDataReceivedListener(this);
    }

    public Future<Iterable<InetAddress>> resolveAsyncV4(String name) {
        final FutureImpl[] f = (FutureImpl[])Array.newInstance(FutureImpl.class, 1);
        FutureImpl<Iterable<InetAddress>> future = f[0] = new FutureImpl<Iterable<InetAddress>>(this.service, new Procedure(){

            @Override
            public void call() {
                DNSResolver.this.requests.remove(DNSResolver.this.requestByFuture(f[0]));
            }
        });
        Iterable<InetAddress> resolved = DNSResolverCache.getAddressesIPv4(name);
        if (resolved != null) {
            future.postSuccess(resolved);
        } else {
            DNSMessage message = new DNSMessage();
            DNSQuery queryIPv4 = new DNSQuery();
            message.setRecursionDesired(true);
            queryIPv4.setName(name);
            queryIPv4.setType(DNSUtils.typeToInt("A"));
            queryIPv4.setClass(DNSUtils.classToInt("IN"));
            message.addQuery(queryIPv4);
            this.doRequest(future, message, 4);
        }
        return future;
    }

    public Future<Iterable<InetAddress>> resolveAsyncV6(String name) {
        final FutureImpl[] f = (FutureImpl[])Array.newInstance(FutureImpl.class, 1);
        FutureImpl<Iterable<InetAddress>> future = f[0] = new FutureImpl<Iterable<InetAddress>>(this.service, new Procedure(){

            @Override
            public void call() {
                DNSResolver.this.requests.remove(DNSResolver.this.requestByFuture(f[0]));
            }
        });
        Iterable<InetAddress> resolved = DNSResolverCache.getAddressesIPv6(name);
        if (resolved != null) {
            future.postSuccess(resolved);
        } else {
            DNSMessage message = new DNSMessage();
            DNSQuery queryIPv6 = new DNSQuery();
            message.setRecursionDesired(true);
            queryIPv6.setName(name);
            queryIPv6.setType(DNSUtils.typeToInt("AAAA"));
            queryIPv6.setClass(DNSUtils.classToInt("IN"));
            message.addQuery(queryIPv6);
            this.doRequest(future, message, 6);
        }
        return future;
    }

    public Future<Iterable<InetAddress>> resolveAsync(final String name) {
        final FutureImpl[] f = (FutureImpl[])Array.newInstance(FutureImpl.class, 1);
        final FutureImpl<Iterable<InetAddress>> future = f[0] = new FutureImpl<Iterable<InetAddress>>(this.service, new Procedure(){

            @Override
            public void call() {
                DNSResolver.this.requests.remove(DNSResolver.this.requestByFuture(f[0]));
            }
        });
        if (DNSResolverCache.hasIPv4(name) && DNSResolverCache.hasIPv6(name)) {
            future.postSuccess(DNSResolverCache.getAddresses(name));
        } else if (!DNSResolverCache.hasIPv4(name) && DNSResolverCache.hasIPv6(name)) {
            this.resolveAsyncV4(name).whenDone(new Callback<Future<Iterable<InetAddress>>>(){

                @Override
                public void call(Future<Iterable<InetAddress>> arg) {
                    if (arg.isSuccessful()) {
                        future.postSuccess(DNSResolverCache.getAddresses(name));
                    } else {
                        future.postError(arg.cause());
                    }
                }
            });
        } else if (!DNSResolverCache.hasIPv6(name) && DNSResolverCache.hasIPv4(name)) {
            this.resolveAsyncV6(name).whenDone(new Callback<Future<Iterable<InetAddress>>>(){

                @Override
                public void call(Future<Iterable<InetAddress>> arg) {
                    if (arg.isSuccessful()) {
                        future.postSuccess(DNSResolverCache.getAddresses(name));
                    } else {
                        future.postError(arg.cause());
                    }
                }
            });
        } else {
            final boolean[] hasFinished = new boolean[]{false, false};
            this.resolveAsyncV4(name).whenDone(new Callback<Future<Iterable<InetAddress>>>(){

                @Override
                public void call(Future<Iterable<InetAddress>> arg) {
                    hasFinished[0] = true;
                    if (arg.isSuccessful() && hasFinished[1]) {
                        if (!future.isDone()) {
                            future.postSuccess(DNSResolverCache.getAddresses(name));
                        } else {
                            future.postError(arg.cause());
                        }
                    }
                }
            });
            this.resolveAsyncV6(name).whenDone(new Callback<Future<Iterable<InetAddress>>>(){

                @Override
                public void call(Future<Iterable<InetAddress>> arg) {
                    hasFinished[1] = true;
                    if (arg.isSuccessful() && hasFinished[0]) {
                        if (!future.isDone()) {
                            future.postSuccess(DNSResolverCache.getAddresses(name));
                        } else {
                            future.postError(arg.cause());
                        }
                    }
                }
            });
        }
        return future;
    }

    public Iterable<InetAddress> resolveV4(String name) {
        return this.resolveAsyncV4(name).sync().getValueNow();
    }

    public Iterable<InetAddress> resolveV6(String name) {
        return this.resolveAsyncV6(name).sync().getValueNow();
    }

    public Iterable<InetAddress> resolve(String name) {
        return this.resolveAsync(name).sync().getValueNow();
    }

    @Override
    public void close() {
        if (this.socket.isOpen()) {
            this.closeAsync().sync();
        }
    }

    public Future<Void> closeAsync() {
        return this.socket.closeAsync();
    }

    private Request requestById(int id) {
        for (Request r : this.requests) {
            if (r.sentMessage.getId() != id) continue;
            return r;
        }
        return null;
    }

    private Request requestByFuture(Future<Iterable<InetAddress>> id) {
        for (Request r : this.requests) {
            if (r.future != id) continue;
            return r;
        }
        return null;
    }

    private void doRequest(final FutureImpl<Iterable<InetAddress>> future, final DNSMessage sentMessage, int type) {
        final Request r = new Request(future, sentMessage, DNSResolverCache.dnsServers().iterator(), type);
        this.requests.add(r);
        future.whenDone(new Callback<Future<Iterable<InetAddress>>>(){

            @Override
            public void call(Future<Iterable<InetAddress>> arg) {
                DNSResolver.this.requests.remove(r);
            }
        });
        final Callback<Future<Void>> sendCbk = new Callback<Future<Void>>(){

            @Override
            public void call(Future<Void> arg) {
                r.tries--;
                if (!arg.isSuccessful() && !arg.isCancelled()) {
                    future.postError(arg.cause());
                }
            }
        };
        Procedure timeoutProc = new Procedure(){

            @Override
            public void call() {
                if (!future.isDone()) {
                    if (r.tries > 0) {
                        DNSResolver.this.socket.sendAsyncTo(sentMessage, r.currentServer).whenDone(sendCbk);
                        r.timeoutFuture = DNSResolver.this.service.schedule(this, 1000L);
                    } else if (r.it.hasNext()) {
                        DNSResolver.this.socket.sendAsyncTo(sentMessage, r.currentServer = (InetSocketAddress)r.it.next()).whenDone(sendCbk);
                        r.timeoutFuture = DNSResolver.this.service.schedule(this, 1000L);
                    } else {
                        future.postError(new TimeoutException());
                    }
                }
            }
        };
        if (!this.socket.isOpen()) {
            this.socket.bind();
        }
        this.socket.sendAsyncTo(sentMessage, r.currentServer).whenDone(sendCbk);
        r.timeoutFuture = this.service.schedule(timeoutProc, 1000L);
    }

    private void addAllRecords(String name, Iterable<DNSResourceRecord> a) {
        for (DNSResourceRecord record : a) {
            if (record.getTypeAsString().equals("A")) {
                DNSResolverCache.addAEntry(name, record);
                continue;
            }
            if (record.getTypeAsString().equals("CNAME")) {
                DNSResolverCache.addCNAMEEntry(name, record);
                continue;
            }
            if (!record.getTypeAsString().equals("AAAA")) continue;
            DNSResolverCache.addAAAAEntry(name, record);
        }
    }

    @Override
    public void call(Socket arg) {
        DNSMessage message = new DNSMessage();
        try {
            this.socket.receive(message);
        }
        catch (Throwable e) {
            return;
        }
        Request r = this.requestById(message.getId());
        if (r != null) {
            String name = r.sentMessage.getQueries().iterator().next().getName();
            if (r.timeoutFuture != null) {
                r.timeoutFuture.cancel(true);
            }
            if (message.getResponseCode() != 0) {
                if (message.getResponseCode() == 3) {
                    r.future.postError(new UnknownHostException(name));
                } else {
                    r.future.postError(new Error(DNSUtils.errorToString(message.getResponseCode())));
                }
            } else {
                this.addAllRecords(name, message.getAnswers());
                this.addAllRecords(name, message.getAuthorities());
                this.addAllRecords(name, message.getAdditionals());
                if (r.type == 6) {
                    r.future.postSuccess(DNSResolverCache.getAddressesIPv6(name));
                } else if (r.type == 4) {
                    r.future.postSuccess(DNSResolverCache.getAddressesIPv4(name));
                }
            }
        } else {
            throw new IllegalStateException("Received ID is not in requests ones: " + message.getId());
        }
    }

    private class Request {
        private FutureImpl<Iterable<InetAddress>> future;
        private Future<?> timeoutFuture;
        private DNSMessage sentMessage;
        private Iterator<InetSocketAddress> it;
        private InetSocketAddress currentServer;
        private int tries;
        private int type;

        private Request(FutureImpl<Iterable<InetAddress>> future, DNSMessage sentMessage, Iterator<InetSocketAddress> it, int type) {
            this.tries = DNSResolver.this.tries;
            this.future = future;
            this.sentMessage = sentMessage;
            this.it = it;
            this.type = type;
            this.currentServer = it.next();
        }
    }
}

