/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.melchor9000.net.Acceptor;
import me.melchor9000.net.Callback;
import me.melchor9000.net.Future;
import me.melchor9000.net.FutureImpl;
import me.melchor9000.net.IOService;
import me.melchor9000.net.Procedure;
import me.melchor9000.net.TCPSocket;
import org.jetbrains.annotations.NotNull;

public class TCPAcceptor
extends Acceptor<TCPSocket> {
    ConcurrentLinkedQueue<FutureImpl<TCPSocket>> accepts;
    ConcurrentLinkedQueue<TCPSocket> sockets;

    public TCPAcceptor(IOService service) {
        super(service);
        this.cnstr();
    }

    public TCPAcceptor(IOService server, IOService worker) {
        super(server, worker);
        this.cnstr();
    }

    private void cnstr() {
        ((ServerBootstrap)this.bootstrap.channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                TCPSocket socket = TCPAcceptor.this.createSocketForImplementation(ch);
                if (!TCPAcceptor.this.accepts.isEmpty()) {
                    TCPAcceptor.this.accepts.poll().postSuccess(socket);
                } else if (TCPAcceptor.this.onConnection != null) {
                    TCPAcceptor.this.onConnection.call(socket);
                } else {
                    TCPAcceptor.this.sockets.add(socket);
                }
            }
        });
        this.accepts = new ConcurrentLinkedQueue();
        this.sockets = new ConcurrentLinkedQueue();
    }

    @NotNull
    protected TCPSocket createSocketForImplementation(@NotNull SocketChannel ch) throws IOException {
        return new TCPSocket(this, ch);
    }

    @Override
    public Future<TCPSocket> acceptAsync() {
        this.checkSocketCreated("acceptAsync");
        final FutureImpl[] a = (FutureImpl[])Array.newInstance(FutureImpl.class, 1);
        a[0] = this.createFuture(new Procedure(){

            @Override
            public void call() {
                TCPAcceptor.this.accepts.remove(a[0]);
            }
        });
        if (this.channel != null) {
            if (this.sockets.isEmpty()) {
                this.accepts.add(a[0]);
            } else {
                a[0].postSuccess(this.sockets.poll());
            }
        } else {
            a[0].postError(new IllegalStateException("Socket is not listening"));
        }
        return a[0];
    }

    @Override
    public void setOnConnectionListener(Callback<TCPSocket> cbk) {
        super.setOnConnectionListener(cbk);
        if (cbk != null) {
            while (!this.sockets.isEmpty()) {
                try {
                    cbk.call(this.sockets.poll());
                }
                catch (Exception exception) {}
            }
        }
    }

    public int pendingConnections() {
        return this.sockets.size() - this.accepts.size();
    }
}

