/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.melchor9000.net.Callback;
import me.melchor9000.net.Future;
import me.melchor9000.net.FutureImpl;
import me.melchor9000.net.IOService;
import me.melchor9000.net.Procedure;
import me.melchor9000.net.Socket;
import me.melchor9000.net.TCPAcceptor;
import org.jetbrains.annotations.NotNull;

public class TCPSocket
extends Socket {
    protected SocketChannel socket;
    private ByteBuf readBuffer;
    private ConcurrentLinkedQueue<ReadOperation> readOperations;
    final ReadManager readManager;
    private volatile boolean isClosed = false;

    public TCPSocket(IOService service) {
        super(service);
        ((Bootstrap)this.bootstrap.channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("readManager", (ChannelHandler)TCPSocket.this.readManager);
            }
        });
        this.readBuffer = ByteBufAllocator.DEFAULT.directBuffer(1460, 146000).retain();
        this.readOperations = new ConcurrentLinkedQueue();
        this.readManager = new ReadManager();
    }

    TCPSocket(TCPAcceptor acceptor, SocketChannel socket) {
        super(acceptor.service);
        this.socket = socket;
        this.channel = this.socket;
        this.readBuffer = ByteBufAllocator.DEFAULT.directBuffer(1460, 146000).retain();
        this.readOperations = new ConcurrentLinkedQueue();
        this.readManager = new ReadManager();
        socket.pipeline().addLast("readManager", (ChannelHandler)this.readManager);
    }

    @Override
    public void bind(@NotNull SocketAddress address) {
        super.bind(address);
        this.channelCreated();
    }

    @Override
    public void connect(@NotNull SocketAddress address) throws InterruptedException {
        super.connect(address);
        this.channelCreated();
    }

    @Override
    @NotNull
    public Future<Void> connectAsync(@NotNull SocketAddress endpoint) {
        return super.connectAsync(endpoint).whenDone(new Callback<Future<Void>>(){

            @Override
            public void call(Future<Void> arg) {
                TCPSocket.this.channelCreated();
            }
        });
    }

    @Override
    public long receive(ByteBuf data, int bytes) throws Throwable {
        this.checkSocketCreated("receive");
        return this.isClosed ? -1L : this.receiveAsync(data, bytes).getValue();
    }

    @Override
    @NotNull
    public Future<Long> receiveAsync(ByteBuf data, int bytes) {
        this.checkSocketCreated("receiveAsync");
        final ReadOperation[] op = new ReadOperation[1];
        final FutureImpl<Long> future = this.createFuture(new Procedure(){

            @Override
            public void call() {
                TCPSocket.this.readOperations.remove(op[0]);
            }
        });
        if (!this.isClosed) {
            op[0] = new ReadOperation(future, bytes, data);
            this.readOperations.add(op[0]);
            if (this.readManager.hasEnoughData()) {
                try {
                    this.readManager.checkAndSendData();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            this.service.post(new Procedure(){

                @Override
                public void call() {
                    try {
                        future.postError(new IOException("End of stream"));
                    }
                    catch (Exception e) {
                        System.out.println("Captured exception on Future.postError()");
                        e.printStackTrace();
                    }
                }
            });
        }
        return future;
    }

    public void shutdownOutput() {
        this.checkSocketCreated("shutdownOutput");
        this.socket.shutdownOutput().syncUninterruptibly();
    }

    public Future<Void> shutdownOutputAsync() {
        this.checkSocketCreated("shutdownOutputAsync");
        return this.createFuture(this.socket.shutdownOutput());
    }

    public void shutdownInput() {
        this.checkSocketCreated("shutdownInput");
        this.socket.shutdownInput().syncUninterruptibly();
    }

    public Future<Void> shutdownInputAsync() {
        this.checkSocketCreated("shutdownInputAsync");
        return this.createFuture(this.socket.shutdownInput());
    }

    public void shutdown() {
        this.checkSocketCreated("shutdown");
        this.socket.shutdown().syncUninterruptibly();
    }

    public Future<Void> shutdownAsync() {
        this.checkSocketCreated("shutdownAsync");
        return this.createFuture(this.socket.shutdown());
    }

    public int readableBytes() {
        return this.isClosed ? -1 : this.readBuffer.readableBytes();
    }

    public void waitUntilClose() {
        this.socket.closeFuture().syncUninterruptibly();
    }

    public Future<Void> onClose() {
        this.checkSocketCreated("onClose");
        return this.createFuture(this.socket.closeFuture());
    }

    @Override
    public void close() {
        super.close();
        this.readBuffer.release();
    }

    @Override
    @NotNull
    public Future<Void> closeAsync() {
        return super.closeAsync().whenDone(new Callback<Future<Void>>(){

            @Override
            public void call(Future<Void> arg) {
                TCPSocket.this.readBuffer.release();
            }
        });
    }

    private void channelCreated() {
        this.socket = (SocketChannel)this.channel;
        if (this.socket != null) {
            this.socket.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<io.netty.util.concurrent.Future<? super Void>>(){

                public void operationComplete(io.netty.util.concurrent.Future<? super Void> future) throws Exception {
                    TCPSocket.this.isClosed = true;
                }
            });
        }
    }

    private class ReadOperation {
        private FutureImpl<Long> cbk;
        private int bytesToRead;
        private ByteBuf buffer;

        private ReadOperation(FutureImpl<Long> cbk, int bytesToRead, ByteBuf buffer) {
            this.cbk = cbk;
            this.bytesToRead = bytesToRead;
            this.buffer = buffer;
        }
    }

    private class ReadManager
    extends ChannelInboundHandlerAdapter {
        private ReadManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ByteBuf buff = (ByteBuf)msg;
            try {
                TCPSocket.this.bytesRead += (long)buff.readableBytes();
                if (TCPSocket.this.readBuffer.writerIndex() < TCPSocket.this.readBuffer.maxCapacity() && TCPSocket.this.readBuffer.maxCapacity() - TCPSocket.this.readBuffer.writerIndex() <= buff.readableBytes()) {
                    System.out.println("Discarded " + (buff.readableBytes() - TCPSocket.this.readBuffer.writableBytes()) + " bytes");
                    TCPSocket.this.readBuffer.writeBytes(buff, 0, TCPSocket.this.readBuffer.writableBytes());
                    this.checkAndSendData();
                } else if (TCPSocket.this.readBuffer.maxCapacity() - TCPSocket.this.readBuffer.writerIndex() > buff.readableBytes()) {
                    TCPSocket.this.readBuffer.writeBytes(buff);
                    this.checkAndSendData();
                } else {
                    System.out.println("oberflou");
                }
            }
            finally {
                buff.release();
                TCPSocket.this.fireReceivedData();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            cause.printStackTrace();
        }

        private void checkAndSendData() throws Exception {
            while (this.hasEnoughData()) {
                ReadOperation op = (ReadOperation)TCPSocket.this.readOperations.poll();
                if (op.bytesToRead <= TCPSocket.this.readBuffer.readableBytes()) {
                    TCPSocket.this.readBuffer.readBytes(op.buffer, op.bytesToRead);
                    op.cbk.postSuccess(Long.valueOf(op.bytesToRead));
                    continue;
                }
                long a = TCPSocket.this.readBuffer.readableBytes();
                TCPSocket.this.readBuffer.readBytes(op.buffer, (int)a);
                op.cbk.postSuccess(a);
            }
            if (TCPSocket.this.readBuffer.readableBytes() == 0) {
                TCPSocket.this.readBuffer.readerIndex(0).writerIndex(0);
            }
        }

        private boolean hasEnoughData() {
            return !TCPSocket.this.readOperations.isEmpty() && TCPSocket.this.readBuffer.readableBytes() != 0;
        }
    }
}

