/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import me.melchor9000.net.DataNotRepresentsObject;
import me.melchor9000.net.Serializable;
import me.melchor9000.net.resolver.DNSQuery;
import me.melchor9000.net.resolver.DNSResourceRecord;
import me.melchor9000.net.resolver.DNSUtils;
import org.jetbrains.annotations.NotNull;

public class DNSMessage
extends Serializable {
    private int id = ThreadLocalRandom.current().nextInt() & 0xFFFF;
    private boolean queryOrResponse = false;
    private byte opcode;
    private boolean authoritativeResponse;
    private boolean truncated;
    private boolean recursionDesired;
    private boolean recursionAvailable;
    private byte responseCode;
    private List<DNSQuery> questionRecords = new ArrayList<DNSQuery>();
    private List<DNSResourceRecord> answerRecords = new ArrayList<DNSResourceRecord>();
    private List<DNSResourceRecord> authorityRecords = new ArrayList<DNSResourceRecord>();
    private List<DNSResourceRecord> additionalRecords = new ArrayList<DNSResourceRecord>();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id & 0xFFFF;
    }

    public boolean isQueryOrResponse() {
        return this.queryOrResponse;
    }

    public void setQueryOrResponse(boolean queryOrResponse) {
        this.queryOrResponse = queryOrResponse;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    public void setOpcode(byte opcode) {
        this.opcode = opcode;
    }

    public String getOpcodeAsString() {
        return DNSUtils.errorToString(this.opcode);
    }

    public boolean isAuthoritativeResponse() {
        return this.authoritativeResponse;
    }

    public void setAuthoritativeResponse(boolean authoritativeResponse) {
        this.authoritativeResponse = authoritativeResponse;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public void setTruncated(boolean truncated) {
        this.truncated = truncated;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public void setRecursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
    }

    public boolean isRecursionAvailable() {
        return this.recursionAvailable;
    }

    public void setRecursionAvailable(boolean recursionAvailable) {
        this.recursionAvailable = recursionAvailable;
    }

    public byte getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(byte responseCode) {
        this.responseCode = responseCode;
    }

    public void addQuery(DNSQuery query) {
        this.questionRecords.add(query);
    }

    public void addAnswer(DNSResourceRecord answer) {
        this.answerRecords.add(answer);
    }

    public void addAuthority(DNSResourceRecord authority) {
        this.authorityRecords.add(authority);
    }

    public void addAdditional(DNSResourceRecord additional) {
        this.additionalRecords.add(additional);
    }

    public Iterable<DNSQuery> getQueries() {
        return this.questionRecords;
    }

    public Iterable<DNSResourceRecord> getAnswers() {
        return this.answerRecords;
    }

    public Iterable<DNSResourceRecord> getAuthorities() {
        return this.authorityRecords;
    }

    public Iterable<DNSResourceRecord> getAdditionals() {
        return this.additionalRecords;
    }

    public int getCountQueries() {
        return this.questionRecords.size();
    }

    public int getCountAnswers() {
        return this.answerRecords.size();
    }

    public int getCountAuthorities() {
        return this.authorityRecords.size();
    }

    public int getCountAdditionals() {
        return this.additionalRecords.size();
    }

    @Override
    public int byteBufSize() {
        int size = 12;
        for (DNSQuery query : this.questionRecords) {
            size += query.byteBufSize();
        }
        for (DNSResourceRecord record : this.answerRecords) {
            size += record.byteBufSize();
        }
        for (DNSResourceRecord record : this.authorityRecords) {
            size += record.byteBufSize();
        }
        for (DNSResourceRecord record : this.additionalRecords) {
            size += record.byteBufSize();
        }
        return size;
    }

    @Override
    public void toByteBuf(@NotNull ByteBuf buffer) {
        int flags = 0;
        if (this.queryOrResponse) {
            flags |= 0x8000;
        }
        flags |= this.opcode << 11 & 0x7800;
        if (this.authoritativeResponse) {
            flags |= 0x400;
        }
        if (this.truncated) {
            flags |= 0x200;
        }
        if (this.recursionDesired) {
            flags |= 0x100;
        }
        if (this.recursionAvailable) {
            flags |= 0x80;
        }
        buffer.writeShort(this.id);
        buffer.writeShort(flags |= this.responseCode & 0xF);
        buffer.writeShort(this.questionRecords.size());
        buffer.writeShort(this.answerRecords.size());
        buffer.writeShort(this.authorityRecords.size());
        buffer.writeShort(this.additionalRecords.size());
        for (DNSQuery query : this.questionRecords) {
            query.toByteBuf(buffer);
        }
        for (DNSResourceRecord record : this.answerRecords) {
            record.toByteBuf(buffer);
        }
        for (DNSResourceRecord record : this.authorityRecords) {
            record.toByteBuf(buffer);
        }
        for (DNSResourceRecord record : this.additionalRecords) {
            record.toByteBuf(buffer);
        }
    }

    @Override
    public void fromByteBuf(@NotNull ByteBuf buffer) throws DataNotRepresentsObject {
        DNSResourceRecord record;
        int i;
        this.id = this.rs(buffer);
        int flags = this.rs(buffer);
        this.queryOrResponse = (flags & 0x8000) != 0;
        this.opcode = (byte)((flags & 0x7800) >> 11);
        this.authoritativeResponse = (flags & 0x400) != 0;
        this.truncated = (flags & 0x200) != 0;
        this.recursionDesired = (flags & 0x100) != 0;
        this.recursionAvailable = (flags & 0x80) != 0;
        this.responseCode = (byte)(flags & 0xF);
        int qdcount = this.rs(buffer);
        int ancount = this.rs(buffer);
        int nscount = this.rs(buffer);
        int arcount = this.rs(buffer);
        for (i = 0; i < qdcount; ++i) {
            DNSQuery query = new DNSQuery();
            query.fromByteBuf(buffer);
            this.questionRecords.add(query);
        }
        for (i = 0; i < ancount; ++i) {
            record = new DNSResourceRecord();
            record.fromByteBuf(buffer);
            this.answerRecords.add(record);
        }
        for (i = 0; i < nscount; ++i) {
            record = new DNSResourceRecord();
            record.fromByteBuf(buffer);
            this.authorityRecords.add(record);
        }
        for (i = 0; i < arcount; ++i) {
            record = new DNSResourceRecord();
            record.fromByteBuf(buffer);
            this.additionalRecords.add(record);
        }
    }

    private int rs(ByteBuf buf) {
        if (buf.readableBytes() < 2) {
            throw new DataNotRepresentsObject("Is an incomplete DNS message or isn't it", buf);
        }
        return buf.readUnsignedShort();
    }
}

