/*
 * Decompiled with CFR 0.152.
 */
package me.mervinz.jargser;

import java.util.ArrayList;
import java.util.List;
import me.mervinz.jargser.Command;
import me.mervinz.jargser.Option;

public class ArgumentParser {
    private String appName = "app";
    private String appVersion = "1.0.0";
    private String command = null;
    private List<Command> commands = new ArrayList<Command>();
    private List<Option> options = new ArrayList<Option>();

    public ArgumentParser setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public ArgumentParser setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    public ArgumentParser addCommand(String command, String desc) {
        if (command != null && command.trim().length() != 0) {
            this.commands.add(new Command(command, desc));
        }
        return this;
    }

    private ArgumentParser addOption(Option option) {
        if (option.validate()) {
            for (Option optionItem : this.options) {
                if (option.getS() != null && option.getS().trim().length() != 0 && option.getS().equals(optionItem.getS())) {
                    return this;
                }
                if (option.getFlag() == null || option.getFlag().trim().length() == 0 || !option.getFlag().equals(optionItem.getFlag())) continue;
                return this;
            }
            this.options.add(option);
        }
        return this;
    }

    public ArgumentParser addOption(String s, String flag, String desc) {
        return this.addOption(s, flag, desc, null);
    }

    public ArgumentParser addOption(String s, String flag, String desc, String defaultValue) {
        return this.addOption(new Option(s, flag, desc, defaultValue));
    }

    public void parse(String[] args) {
        if (args.length == 0) {
            return;
        }
        int index = 0;
        if (!args[0].startsWith("-")) {
            for (Command command : this.commands) {
                if (!command.getCommand().equals(args[0])) continue;
                this.command = args[0];
                ++index;
                break;
            }
        }
        while (index < args.length) {
            if (args[index].startsWith("-")) {
                if (index + 1 >= args.length || args[index + 1].startsWith("-")) {
                    ++index;
                    continue;
                }
                Object option = null;
                String value = args[index + 1];
                if (args[index].startsWith("--")) {
                    String flag = args[index].trim().replaceAll("-", "");
                    for (Option optionItem : this.options) {
                        if (optionItem.getFlag() == null || !optionItem.getFlag().equals(flag)) continue;
                        optionItem.setValue(value);
                    }
                } else {
                    String shortFlag = args[index].trim().replaceAll("-", "");
                    for (Option optionItem : this.options) {
                        if (optionItem.getS() == null || !optionItem.getS().equals(shortFlag)) continue;
                        optionItem.setValue(value);
                    }
                }
            }
            ++index;
        }
    }

    public String parsedOption(String flag) {
        for (Option option : this.options) {
            if (!option.getFlag().equals(flag)) continue;
            if (option.getValue() == null) {
                return option.getDefaultValue();
            }
            return option.getValue();
        }
        return null;
    }

    public String parsedCommand() {
        return this.command;
    }

    public void printUsage() {
        System.out.println(this.usage());
    }

    public String usage() {
        int i;
        int words;
        StringBuilder usageBuilder = new StringBuilder(String.format("%s %s\n\nUsage:\n", this.appName, this.appVersion));
        usageBuilder.append(String.format("  %s <command> [options]\n", this.appName));
        if (this.commands.size() != 0) {
            usageBuilder.append("\nCommands:\n");
            for (Command command : this.commands) {
                usageBuilder.append("  ");
                usageBuilder.append(command.getCommand());
                words = command.getCommand().length();
                for (i = 0; i < 28 - words; ++i) {
                    usageBuilder.append(" ");
                }
                if (command.getDesc() != null) {
                    usageBuilder.append(command.getDesc());
                }
                usageBuilder.append("\n");
            }
        }
        if (this.options.size() != 0) {
            usageBuilder.append("\nOptions:\n");
            for (Option option : this.options) {
                words = 0;
                usageBuilder.append("  ");
                if (option.getS() != null) {
                    usageBuilder.append(String.format("-%s  ", option.getS()));
                    words += option.getS().length() + 3;
                }
                if (option.getFlag() != null) {
                    usageBuilder.append(String.format("--%s", option.getFlag()));
                    words += option.getFlag().length() + 2;
                }
                for (i = 0; i < 28 - words; ++i) {
                    usageBuilder.append(" ");
                }
                usageBuilder.append(String.format("%s\n", option.getDesc()));
            }
        }
        return usageBuilder.toString();
    }
}

