/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf;

import ch.qos.logback.classic.spi.ILoggingEvent;
import me.moocar.logbackgelf.GelfConverter;
import me.moocar.logbackgelf.PayloadChunker;
import me.moocar.logbackgelf.Transport;
import me.moocar.logbackgelf.Zipper;

public class AppenderExecutor {
    private final Transport transport;
    private final PayloadChunker payloadChunker;
    private final GelfConverter gelfConverter;
    private final Zipper zipper;
    private final int chunkThreshold;

    public AppenderExecutor(Transport transport, PayloadChunker payloadChunker, GelfConverter gelfConverter, Zipper zipper, int chunkThreshold) {
        this.transport = transport;
        this.payloadChunker = payloadChunker;
        this.gelfConverter = gelfConverter;
        this.zipper = zipper;
        this.chunkThreshold = chunkThreshold;
    }

    public void append(ILoggingEvent logEvent) {
        byte[] payload = this.zipper.zip(this.gelfConverter.toGelf(logEvent));
        if (payload.length < this.chunkThreshold) {
            this.transport.send(payload);
        } else {
            this.transport.send(this.payloadChunker.chunkIt(payload));
        }
    }
}

