/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import me.moocar.logbackgelf.AppenderExecutor;
import me.moocar.logbackgelf.ChunkFactory;
import me.moocar.logbackgelf.GelfConverter;
import me.moocar.logbackgelf.MessageIdProvider;
import me.moocar.logbackgelf.PayloadChunker;
import me.moocar.logbackgelf.Transport;
import me.moocar.logbackgelf.Zipper;
import me.moocar.logbackgelf.util.InternetUtils;

public class GelfAppender
extends AppenderBase<ILoggingEvent> {
    private String facility = "GELF";
    private String graylog2ServerHost = "localhost";
    private int graylog2ServerPort = 12201;
    private boolean useLoggerName = false;
    private boolean useMarker = false;
    private boolean useThreadName = false;
    private String graylog2ServerVersion = "0.9.6";
    private int chunkThreshold = 1000;
    private String messagePattern = "%m%rEx";
    private String shortMessagePattern = null;
    private Map<String, String> additionalFields = new HashMap<String, String>();
    private Map<String, String> staticAdditionalFields = new HashMap<String, String>();
    private boolean includeFullMDC;
    private String hostName;
    private int shortMessageLength = 255;
    private static final int maxChunks = 127;
    private int messageIdLength = 8;
    private boolean padSeq = false;
    private final byte[] chunkedGelfId = new byte[]{30, 15};
    private AppenderExecutor appenderExecutor;

    protected void append(ILoggingEvent logEvent) {
        try {
            this.appenderExecutor.append(logEvent);
        }
        catch (RuntimeException e) {
            System.out.println(this.getStringStackTrace(e));
            this.addError("Error occurred: ", e);
            throw e;
        }
    }

    private String getStringStackTrace(Exception e) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        e.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public void start() {
        super.start();
        this.initExecutor();
    }

    private void initExecutor() {
        try {
            InetAddress address = InternetUtils.getInetAddress(this.graylog2ServerHost);
            Transport transport = new Transport(this.graylog2ServerPort, address);
            if (this.graylog2ServerVersion.equals("0.9.5")) {
                this.messageIdLength = 32;
                this.padSeq = true;
            }
            if (this.hostName == null) {
                this.hostName = InternetUtils.getLocalHostName();
            }
            PayloadChunker payloadChunker = new PayloadChunker(this.chunkThreshold, 127, new MessageIdProvider(this.messageIdLength, MessageDigest.getInstance("MD5"), this.hostName), new ChunkFactory(this.chunkedGelfId, this.padSeq));
            GelfConverter converter = new GelfConverter(this.facility, this.useLoggerName, this.useThreadName, this.useMarker, this.additionalFields, this.staticAdditionalFields, this.shortMessageLength, this.hostName, this.messagePattern, this.shortMessagePattern, this.includeFullMDC);
            this.appenderExecutor = new AppenderExecutor(transport, payloadChunker, converter, new Zipper(), this.chunkThreshold);
        }
        catch (Exception e) {
            throw new RuntimeException("Error initialising appender appenderExecutor", e);
        }
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public String getGraylog2ServerHost() {
        return this.graylog2ServerHost;
    }

    public void setGraylog2ServerHost(String graylog2ServerHost) {
        this.graylog2ServerHost = graylog2ServerHost;
    }

    public int getGraylog2ServerPort() {
        return this.graylog2ServerPort;
    }

    public void setGraylog2ServerPort(int graylog2ServerPort) {
        this.graylog2ServerPort = graylog2ServerPort;
    }

    public boolean isUseLoggerName() {
        return this.useLoggerName;
    }

    public void setUseLoggerName(boolean useLoggerName) {
        this.useLoggerName = useLoggerName;
    }

    public boolean isUseMarker() {
        return this.useMarker;
    }

    public void setUseMarker(boolean useMarker) {
        this.useMarker = useMarker;
    }

    public boolean isUseThreadName() {
        return this.useThreadName;
    }

    public void setUseThreadName(boolean useThreadName) {
        this.useThreadName = useThreadName;
    }

    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public Map<String, String> getStaticAdditionalFields() {
        return this.staticAdditionalFields;
    }

    public void setStaticAdditionalFields(Map<String, String> staticAdditionalFields) {
        this.staticAdditionalFields = staticAdditionalFields;
    }

    public boolean isIncludeFullMDC() {
        return this.includeFullMDC;
    }

    public void setIncludeFullMDC(boolean includeFullMDC) {
        this.includeFullMDC = includeFullMDC;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void addAdditionalField(String keyValue) {
        String[] splitted = keyValue.split(":");
        if (splitted.length != 2) {
            throw new IllegalArgumentException("additionalField must be of the format key:value, where key is the MDC key, and value is the GELF field name. But found '" + keyValue + "' instead.");
        }
        this.additionalFields.put(splitted[0], splitted[1]);
    }

    public void addStaticAdditionalField(String keyValue) {
        String[] splitted = keyValue.split(":");
        if (splitted.length != 2) {
            throw new IllegalArgumentException("staticAdditionalField must be of the format key:value, where key is the additional field key (therefore should have a leading underscore), and value is a static string. e.g. _node_name:www013");
        }
        this.staticAdditionalFields.put(splitted[0], splitted[1]);
    }

    public int getShortMessageLength() {
        return this.shortMessageLength;
    }

    public void setShortMessageLength(int shortMessageLength) {
        this.shortMessageLength = shortMessageLength;
    }

    public String getGraylog2ServerVersion() {
        return this.graylog2ServerVersion;
    }

    public void setGraylog2ServerVersion(String graylog2ServerVersion) {
        this.graylog2ServerVersion = graylog2ServerVersion;
    }

    public int getChunkThreshold() {
        return this.chunkThreshold;
    }

    public void setChunkThreshold(int chunkThreshold) {
        this.chunkThreshold = chunkThreshold;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
    }

    public String getShortMessagePattern() {
        return this.shortMessagePattern;
    }

    public void setShortMessagePattern(String shortMessagePattern) {
        this.shortMessagePattern = shortMessagePattern;
    }
}

