/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.moocar.logbackgelf.ChunkFactory;
import me.moocar.logbackgelf.MessageIdProvider;

public class PayloadChunker {
    private final int payloadThreshold;
    private final int maxChunks;
    private final MessageIdProvider messageIdProvider;
    private final ChunkFactory chunkFactory;

    public PayloadChunker(int payloadThreshold, int maxChunks, MessageIdProvider messageIdProvider, ChunkFactory chunkFactory) {
        this.payloadThreshold = payloadThreshold;
        this.maxChunks = maxChunks;
        this.messageIdProvider = messageIdProvider;
        this.chunkFactory = chunkFactory;
    }

    public List<byte[]> chunkIt(byte[] payload) {
        return this.createChunks(this.messageIdProvider.get(), this.splitPayload(payload));
    }

    private List<byte[]> createChunks(byte[] messageId, List<byte[]> subPayloads) {
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        byte seqNum = 0;
        for (byte[] subPayload : subPayloads) {
            if (seqNum == this.maxChunks) break;
            byte by = seqNum;
            seqNum = (byte)(seqNum + 1);
            chunks.add(this.chunkFactory.create(messageId, by, (byte)subPayloads.size(), subPayload));
        }
        return chunks;
    }

    private List<byte[]> splitPayload(byte[] payload) {
        ArrayList<byte[]> subPayloads = new ArrayList<byte[]>();
        int payloadLength = payload.length;
        int numFullSubs = payloadLength / this.payloadThreshold;
        int lastSubLength = payloadLength % this.payloadThreshold;
        for (int subPayload = 0; subPayload < numFullSubs; ++subPayload) {
            subPayloads.add(this.extractSubPayload(payload, subPayload));
        }
        if (lastSubLength > 0) {
            subPayloads.add(this.extractSubPayload(payload, numFullSubs));
        }
        return subPayloads;
    }

    private byte[] extractSubPayload(byte[] payload, int subPaylod) {
        return Arrays.copyOfRange(payload, subPaylod * this.payloadThreshold, (subPaylod + 1) * this.payloadThreshold);
    }
}

