/*
 * Decompiled with CFR 0.152.
 */
package me.moocar.logbackgelf.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;

public class InternetUtils {
    private InternetUtils() {
    }

    public static String getLocalHostName() throws SocketException, UnknownHostException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            NetworkInterface networkInterface = NetworkInterface.getNetworkInterfaces().nextElement();
            if (networkInterface == null) {
                throw e;
            }
            InetAddress ipAddress = networkInterface.getInetAddresses().nextElement();
            if (ipAddress == null) {
                throw e;
            }
            return ipAddress.getHostAddress();
        }
    }

    public static InetAddress getInetAddress(String hostName) {
        try {
            return InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Unknown host: " + e.getMessage() + ". Make sure you have specified the 'graylog2ServerHost' property correctly in your logback.xml'");
        }
    }
}

