/*
 * Decompiled with CFR 0.152.
 */
package me.naotiki.ese.core.vfs;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.naotiki.ese.core.EseError;
import me.naotiki.ese.core.user.User;
import me.naotiki.ese.core.vfs.File;
import me.naotiki.ese.core.vfs.Permission;
import me.naotiki.ese.core.vfs.PermissionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lme/naotiki/ese/core/vfs/SealedFileValue;", "T", "", "file", "Lme/naotiki/ese/core/vfs/File;", "internalValue", "(Lme/naotiki/ese/core/vfs/File;Ljava/lang/Object;)V", "Ljava/lang/Object;", "get", "user", "Lme/naotiki/ese/core/user/User;", "(Lme/naotiki/ese/core/user/User;)Ljava/lang/Object;", "getOrNull", "set", "", "value", "(Lme/naotiki/ese/core/user/User;Ljava/lang/Object;)Z", "ese-core"})
public final class SealedFileValue<T> {
    @NotNull
    private final File file;
    private T internalValue;

    public SealedFileValue(@NotNull File file, T internalValue) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.internalValue = internalValue;
    }

    public final boolean set(@NotNull User user, T value) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (PermissionKt.checkPermission(this.file, user, Permission.Companion.Operation.Write)) {
            this.internalValue = value;
            return true;
        }
        return false;
    }

    @Nullable
    public final T getOrNull(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (PermissionKt.checkPermission(this.file, user, Permission.Companion.Operation.Read)) {
            return this.internalValue;
        }
        return null;
    }

    public final T get(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (PermissionKt.checkPermission(this.file, user, Permission.Companion.Operation.Read)) {
            return this.internalValue;
        }
        throw new EseError.FilePermissionError(String.valueOf(user.getName()));
    }
}

