/*
 * Decompiled with CFR 0.152.
 */
package me.naotiki.ese.core.secure;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.naotiki.ese.core.secure.EsePermissionKt;
import me.naotiki.ese.core.secure.InspectValue;
import me.naotiki.ese.core.secure.Permissions;
import me.naotiki.ese.core.secure.SecureClassChecker;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\b\u0002\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005j\u0002`\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/naotiki/ese/core/secure/EseClassLoader;", "Ljava/lang/ClassLoader;", "pluginFile", "Ljava/io/File;", "permissionMap", "", "Lme/naotiki/ese/core/secure/Permissions;", "", "Lme/naotiki/ese/core/secure/InspectValue;", "Lme/naotiki/ese/core/secure/PermissionMap;", "parent", "(Ljava/io/File;Ljava/util/Map;Ljava/lang/ClassLoader;)V", "secureClassChecker", "Lme/naotiki/ese/core/secure/SecureClassChecker;", "findClass", "Ljava/lang/Class;", "name", "", "Companion", "ese-core"})
final class EseClassLoader
extends ClassLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File pluginFile;
    @NotNull
    private final SecureClassChecker secureClassChecker;

    public EseClassLoader(@NotNull File pluginFile, @NotNull Map<Permissions, ? extends List<? extends InspectValue>> permissionMap, @NotNull ClassLoader parent) {
        Intrinsics.checkNotNullParameter((Object)pluginFile, (String)"pluginFile");
        Intrinsics.checkNotNullParameter(permissionMap, (String)"permissionMap");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent);
        this.pluginFile = pluginFile;
        this.secureClassChecker = new SecureClassChecker(permissionMap);
    }

    public /* synthetic */ EseClassLoader(File file, Map map, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = EsePermissionKt.getDefaultPermissions();
        }
        if ((n & 4) != 0) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getSystemClassLoader()");
            classLoader = classLoader2;
        }
        this(file, map, classLoader);
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            String path = StringsKt.replace$default((String)name, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
            InputStream jarInputStream = new URL("jar:" + this.pluginFile.toURI().toURL() + "!/" + path).openStream();
            byte[] byArray = jarInputStream.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"jarInputStream.readAllBytes()");
            byte[] allClassBytes = byArray;
            ClassReader classReader = new ClassReader(allClassBytes);
            classReader.accept((ClassVisitor)this.secureClassChecker, 2);
            if (!((Collection)this.secureClassChecker.getRequirePermissions()).isEmpty()) {
                throw new ClassNotFoundException("\u8a31\u53ef\u3055\u308c\u3066\u3044\u306a\u3044\u6a29\u9650:" + this.secureClassChecker.getRequirePermissions());
            }
            Class<?> clazz = this.defineClass(null, allClassBytes, 0, allClassBytes.length);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"defineClass(\n           \u2026es.size\n                )");
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Error finding and opening class", e);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lme/naotiki/ese/core/secure/EseClassLoader$Companion;", "", "()V", "ese-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

