/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityCache;
import org.jetbrains.exposed.dao.EntityCacheKt;
import org.jetbrains.exposed.dao.EntityHookKt;
import org.jetbrains.exposed.dao.EntityLifecycleInterceptorKt;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Key;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchUpdateStatement;
import org.jetbrains.exposed.sql.statements.BatchUpsertStatement;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementGroup;
import org.jetbrains.exposed.sql.statements.UpdateStatement;
import org.jetbrains.exposed.sql.statements.UpsertStatement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J4\u0010\u0010\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00112\u0018\u0010\u0014\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0011H\u0016J\u0014\u0010\u0015\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/dao/EntityLifecycleInterceptor;", "Lorg/jetbrains/exposed/sql/statements/GlobalStatementInterceptor;", "()V", "afterExecution", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "contexts", "", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "executedStatement", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "beforeCommit", "beforeExecution", "context", "beforeRollback", "keepUserDataInTransactionStoreOnCommit", "", "Lorg/jetbrains/exposed/sql/Key;", "", "userData", "flushEntities", "query", "Lorg/jetbrains/exposed/sql/Query;", "exposed-dao"})
@SourceDebugExtension(value={"SMAP\nEntityLifecycleInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityLifecycleInterceptor.kt\norg/jetbrains/exposed/dao/EntityLifecycleInterceptor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n494#2,7:106\n800#3,11:113\n1855#3,2:124\n800#3,11:126\n1855#3,2:137\n800#3,11:139\n1855#3,2:150\n*S KotlinDebug\n*F\n+ 1 EntityLifecycleInterceptor.kt\norg/jetbrains/exposed/dao/EntityLifecycleInterceptor\n*L\n27#1:106,7\n39#1:113,11\n39#1:124,2\n49#1:126,11\n49#1:137,2\n67#1:139,11\n67#1:150,2\n*E\n"})
public final class EntityLifecycleInterceptor
implements GlobalStatementInterceptor {
    @Override
    @NotNull
    public Map<Key<?>, Object> keepUserDataInTransactionStoreOnCommit(@NotNull Map<Key<?>, ? extends Object> userData) {
        Intrinsics.checkNotNullParameter(userData, "userData");
        Map<Key<?>, Object> $this$filterValues$iv = userData;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry<Key<?>, Object> entry$iv : $this$filterValues$iv.entrySet()) {
            Object it = entry$iv.getValue();
            boolean bl = false;
            if (!(it instanceof EntityCache)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeExecution(@NotNull Transaction transaction2, @NotNull StatementContext context) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        Intrinsics.checkNotNullParameter(context, "context");
        Statement<?> statement = context.getStatement();
        if (statement instanceof Query) {
            this.flushEntities(transaction2, (Query)statement);
        } else if (statement instanceof DeleteStatement) {
            EntityCacheKt.flushCache(transaction2);
            EntityCacheKt.getEntityCache(transaction2).removeTablesReferrers$exposed_dao((Collection<? extends Table>)CollectionsKt.listOf(((DeleteStatement)statement).getTable()), false);
            if (!EntityLifecycleInterceptorKt.access$isExecutedWithinEntityLifecycle()) {
                void $this$forEach$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = statement.getTargets();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof IdTable)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IdTable it = (IdTable)element$iv;
                    boolean bl = false;
                    Map<Object, Entity<?>> map2 = EntityCacheKt.getEntityCache(transaction2).getData().get(it);
                    if (map2 != null) {
                        map2.clear();
                    }
                }
            }
        } else if (statement instanceof UpsertStatement ? true : statement instanceof BatchUpsertStatement) {
            EntityCacheKt.flushCache(transaction2);
            EntityCacheKt.getEntityCache(transaction2).removeTablesReferrers$exposed_dao((Collection<? extends Table>)statement.getTargets(), true);
            if (!EntityLifecycleInterceptorKt.access$isExecutedWithinEntityLifecycle()) {
                void $this$forEach$iv;
                Iterable $this$filterIsInstance$iv = statement.getTargets();
                boolean $i$f$filterIsInstance = false;
                Iterable $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    Object element$iv$iv = bl.next();
                    if (!(element$iv$iv instanceof IdTable)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IdTable it = (IdTable)element$iv;
                    boolean bl2 = false;
                    Map<Object, Entity<?>> map3 = EntityCacheKt.getEntityCache(transaction2).getData().get(it);
                    if (map3 != null) {
                        map3.clear();
                    }
                }
            }
        } else if (statement instanceof InsertStatement) {
            EntityCacheKt.flushCache(transaction2);
            EntityCacheKt.getEntityCache(transaction2).removeTablesReferrers$exposed_dao((Collection<? extends Table>)CollectionsKt.listOf(((InsertStatement)statement).getTable()), true);
        } else if (!(statement instanceof BatchUpdateStatement)) {
            if (statement instanceof UpdateStatement) {
                EntityCacheKt.flushCache(transaction2);
                EntityCacheKt.getEntityCache(transaction2).removeTablesReferrers$exposed_dao((Collection<? extends Table>)TableKt.targetTables(((UpdateStatement)statement).getTargetsSet()), false);
                if (!EntityLifecycleInterceptorKt.access$isExecutedWithinEntityLifecycle()) {
                    void $this$forEach$iv;
                    Iterable $this$filterIsInstance$iv = statement.getTargets();
                    boolean $i$f$filterIsInstance = false;
                    Iterable $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IdTable)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IdTable it = (IdTable)element$iv;
                        boolean bl = false;
                        Map<Object, Entity<?>> map4 = EntityCacheKt.getEntityCache(transaction2).getData().get(it);
                        if (map4 != null) {
                            map4.clear();
                        }
                    }
                }
            } else if (statement.getType().getGroup() == StatementGroup.DDL) {
                EntityCacheKt.flushCache(transaction2);
            }
        }
    }

    @Override
    public void afterExecution(@NotNull Transaction transaction2, @NotNull List<StatementContext> contexts, @NotNull PreparedStatementApi executedStatement) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        Intrinsics.checkNotNullParameter(contexts, "contexts");
        Intrinsics.checkNotNullParameter(executedStatement, "executedStatement");
        if (!EntityLifecycleInterceptorKt.access$isExecutedWithinEntityLifecycle() || !(CollectionsKt.first(contexts).getStatement() instanceof InsertStatement)) {
            EntityHookKt.alertSubscribers(transaction2);
        }
    }

    @Override
    public void beforeCommit(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        List<Entity<?>> created = EntityCacheKt.flushCache(transaction2);
        EntityHookKt.alertSubscribers(transaction2);
        List<Entity<?>> createdByHooks = EntityCacheKt.flushCache(transaction2);
        EntityCache.Companion.invalidateGlobalCaches(CollectionsKt.plus((Collection)created, (Iterable)createdByHooks));
    }

    @Override
    public void beforeRollback(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        EntityCache entityCache2 = EntityCacheKt.getEntityCache(transaction2);
        entityCache2.clearReferrersCache();
        entityCache2.getData().clear();
        entityCache2.getInserts$exposed_dao().clear();
    }

    private final void flushEntities(Transaction $this$flushEntities, Query query2) {
        Set tables = CollectionsKt.toSet((Iterable)CollectionsKt.filterIsInstance((Iterable)query2.getTargets(), IdTable.class));
        EntityCacheKt.getEntityCache($this$flushEntities).flush(tables);
    }

    @Override
    public void afterCommit(@NotNull Transaction transaction2) {
        GlobalStatementInterceptor.DefaultImpls.afterCommit(this, transaction2);
    }

    @Override
    public void afterRollback(@NotNull Transaction transaction2) {
        GlobalStatementInterceptor.DefaultImpls.afterRollback(this, transaction2);
    }

    @Override
    public void afterStatementPrepared(@NotNull Transaction transaction2, @NotNull PreparedStatementApi preparedStatement) {
        GlobalStatementInterceptor.DefaultImpls.afterStatementPrepared(this, transaction2, preparedStatement);
    }
}

