/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.Closeable;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/exposed/sql/BasicBinaryColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "nonNullValueToString", "", "value", "", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/sql/BasicBinaryColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1005:1\n1#2:1006\n*E\n"})
public class BasicBinaryColumnType
extends ColumnType {
    public BasicBinaryColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().binaryType();
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return rs.getBytes(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object2 = value;
        if (object2 instanceof Blob) {
            Closeable closeable = ((Blob)value).getBinaryStream();
            Throwable throwable = null;
            try {
                Object it = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                it = ByteStreamsKt.readBytes((InputStream)it);
                object = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        } else if (object2 instanceof InputStream) {
            Closeable closeable = (Closeable)value;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byte[] byArray = ByteStreamsKt.readBytes(it);
                object = byArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        } else {
            object = value;
        }
        return object;
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return value instanceof byte[] ? new String((byte[])value, Charsets.UTF_8) : value.toString();
    }
}

