/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u001cR?\u0010\u0007\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00018\u00008\u0000 \t*\u0012\u0012\u000e\b\u0001\u0012\n \t*\u0004\u0018\u00018\u00008\u00000\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/EnumerationColumnType;", "T", "", "Lorg/jetbrains/exposed/sql/ColumnType;", "klass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "enumConstants", "", "kotlin.jvm.PlatformType", "getEnumConstants", "()[Ljava/lang/Enum;", "enumConstants$delegate", "Lkotlin/Lazy;", "getKlass", "()Lkotlin/reflect/KClass;", "equals", "", "other", "", "hashCode", "", "notNullValueToDB", "value", "(Ljava/lang/Object;)Ljava/lang/Integer;", "sqlType", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Enum;", "exposed-core"})
public final class EnumerationColumnType<T extends Enum<T>>
extends ColumnType {
    @NotNull
    private final KClass<T> klass;
    @NotNull
    private final Lazy enumConstants$delegate;

    public EnumerationColumnType(@NotNull KClass<T> klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        super(false, 1, null);
        this.klass = klass;
        this.enumConstants$delegate = LazyKt.lazy((Function0)new Function0<T[]>(this){
            final /* synthetic */ EnumerationColumnType<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final T[] invoke() {
                KClass<T>[] kClassArray = JvmClassMappingKt.getJavaClass(this.this$0.getKlass()).getEnumConstants();
                Intrinsics.checkNotNull(kClassArray);
                return (Enum[])kClassArray;
            }
        });
    }

    @NotNull
    public final KClass<T> getKlass() {
        return this.klass;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().integerType();
    }

    private final T[] getEnumConstants() {
        Lazy lazy = this.enumConstants$delegate;
        return (Enum[])lazy.getValue();
    }

    @NotNull
    public T valueFromDB(@NotNull Object value) {
        Enum enum_;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Number) {
            Enum enum_2 = this.getEnumConstants()[((Number)value).intValue()];
            enum_ = enum_2;
            Intrinsics.checkNotNullExpressionValue(enum_2, "enumConstants[value.toInt()]");
        } else if (object instanceof Enum) {
            enum_ = (Enum)value;
        } else {
            throw new IllegalStateException((value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName() + " is not valid for enum " + this.klass.getSimpleName()).toString());
        }
        return (T)enum_;
    }

    @Override
    @NotNull
    public Integer notNullValueToDB(@NotNull Object value) {
        int n;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Integer) {
            n = ((Number)value).intValue();
        } else if (object instanceof Enum) {
            n = ((Enum)value).ordinal();
        } else {
            throw new IllegalStateException((value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName() + " is not valid for enum " + this.klass.getSimpleName()).toString());
        }
        return n;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type org.jetbrains.exposed.sql.EnumerationColumnType<*>");
        EnumerationColumnType cfr_ignored_0 = (EnumerationColumnType)other;
        return Intrinsics.areEqual(this.klass, ((EnumerationColumnType)other).klass);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + ((Object)this.klass).hashCode();
        return result2;
    }
}

