/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ComplexExpression;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u001d\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/exposed/sql/IsNotDistinctFromOp;", "Lorg/jetbrains/exposed/sql/Op;", "", "Lorg/jetbrains/exposed/sql/ComplexExpression;", "Lorg/jetbrains/exposed/sql/Op$OpBoolean;", "expression1", "Lorg/jetbrains/exposed/sql/Expression;", "expression2", "(Lorg/jetbrains/exposed/sql/Expression;Lorg/jetbrains/exposed/sql/Expression;)V", "getExpression1", "()Lorg/jetbrains/exposed/sql/Expression;", "getExpression2", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "exposed-core"})
public final class IsNotDistinctFromOp
extends Op<Boolean>
implements ComplexExpression,
Op.OpBoolean {
    @NotNull
    private final Expression<?> expression1;
    @NotNull
    private final Expression<?> expression2;

    public IsNotDistinctFromOp(@NotNull Expression<?> expression1, @NotNull Expression<?> expression2) {
        Intrinsics.checkNotNullParameter(expression1, "expression1");
        Intrinsics.checkNotNullParameter(expression2, "expression2");
        this.expression1 = expression1;
        this.expression2 = expression2;
    }

    @NotNull
    public final Expression<?> getExpression1() {
        return this.expression1;
    }

    @NotNull
    public final Expression<?> getExpression2() {
        return this.expression2;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(this){
            final /* synthetic */ IsNotDistinctFromOp this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialectIfAvailable();
                if (databaseDialect instanceof MariaDBDialect ? true : databaseDialect instanceof MysqlDialect) {
                    Object[] objectArray = new Object[]{this.this$0.getExpression1(), " <=> ", this.this$0.getExpression2()};
                    ExpressionKt.append($this$invoke, objectArray);
                } else if (databaseDialect instanceof OracleDialect) {
                    Object[] objectArray = new Object[]{"DECODE(", this.this$0.getExpression1(), ", ", this.this$0.getExpression2(), ", 1, 0) = 1"};
                    ExpressionKt.append($this$invoke, objectArray);
                } else if (databaseDialect instanceof SQLiteDialect) {
                    Object[] objectArray = new Object[]{this.this$0.getExpression1(), " IS ", this.this$0.getExpression2()};
                    ExpressionKt.append($this$invoke, objectArray);
                } else {
                    Object[] objectArray = new Object[]{this.this$0.getExpression1(), " IS NOT DISTINCT FROM ", this.this$0.getExpression2()};
                    ExpressionKt.append($this$invoke, objectArray);
                }
            }
        });
    }
}

