/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.AliasKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.ForUpdateOption;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\"\u001a\u00020\u00002\u0017\u0010#\u001a\u0013\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$\u00a2\u0006\u0002\b&J-\u0010'\u001a\u00020\u00002%\u0010#\u001a!\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050$\u00a2\u0006\u0002\b&J%\u0010(\u001a\u00020\u00002\u001d\u0010#\u001a\u0019\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030)\u00a2\u0006\u0002\b&J-\u0010*\u001a\u00020\u00002%\u0010#\u001a!\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050$\u00a2\u0006\u0002\b&J\b\u0010+\u001a\u00020\u0000H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u000fH\u0016J'\u00100\u001a\u00020\u00002\u001a\u00101\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001102\"\u0006\u0012\u0002\b\u00030\u0011\u00a2\u0006\u0002\u00103J\u0006\u00104\u001a\u00020\u0006J%\u0010\u0015\u001a\u00020\u00002\u001d\u00105\u001a\u0019\u0012\u0004\u0012\u000206\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050$\u00a2\u0006\u0002\b&J\u0006\u00107\u001a\u00020\u0006J\b\u00108\u001a\u00020\u0000H\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0006H\u0016J\u0016\u0010?\u001a\u0004\u0018\u00010\u001a*\u00020@2\u0006\u0010A\u001a\u00020BH\u0016R$\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R.\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R.\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017\u00a8\u0006C"}, d2={"Lorg/jetbrains/exposed/sql/Query;", "Lorg/jetbrains/exposed/sql/AbstractQuery;", "set", "Lorg/jetbrains/exposed/sql/FieldSet;", "where", "Lorg/jetbrains/exposed/sql/Op;", "", "(Lorg/jetbrains/exposed/sql/FieldSet;Lorg/jetbrains/exposed/sql/Op;)V", "<set-?>", "distinct", "getDistinct", "()Z", "setDistinct", "(Z)V", "forUpdate", "Lorg/jetbrains/exposed/sql/vendors/ForUpdateOption;", "", "Lorg/jetbrains/exposed/sql/Expression;", "groupedByColumns", "getGroupedByColumns", "()Ljava/util/List;", "having", "getHaving", "()Lorg/jetbrains/exposed/sql/Op;", "queryToExecute", "Lorg/jetbrains/exposed/sql/statements/Statement;", "Ljava/sql/ResultSet;", "getQueryToExecute", "()Lorg/jetbrains/exposed/sql/statements/Statement;", "getSet", "()Lorg/jetbrains/exposed/sql/FieldSet;", "setSet", "(Lorg/jetbrains/exposed/sql/FieldSet;)V", "getWhere", "adjustColumnSet", "body", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/ColumnSet;", "Lkotlin/ExtensionFunctionType;", "adjustHaving", "adjustSlice", "Lkotlin/Function2;", "adjustWhere", "copy", "count", "", "empty", "option", "groupBy", "columns", "", "([Lorg/jetbrains/exposed/sql/Expression;)Lorg/jetbrains/exposed/sql/Query;", "hasCustomForUpdateState", "op", "Lorg/jetbrains/exposed/sql/SqlExpressionBuilder;", "isForUpdate", "notForUpdate", "prepareSQL", "", "builder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "withDistinct", "value", "executeInternal", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Query.kt\norg/jetbrains/exposed/sql/Query\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public class Query
extends AbstractQuery<Query> {
    @NotNull
    private FieldSet set;
    private boolean distinct;
    @NotNull
    private List<? extends Expression<?>> groupedByColumns;
    @Nullable
    private Op<Boolean> having;
    @Nullable
    private ForUpdateOption forUpdate;
    @Nullable
    private Op<Boolean> where;

    public Query(@NotNull FieldSet set, @Nullable Op<Boolean> where) {
        Intrinsics.checkNotNullParameter(set, "set");
        super(TableKt.targetTables(set.getSource()));
        this.set = set;
        this.groupedByColumns = new ArrayList();
        this.where = where;
    }

    @Override
    @NotNull
    public FieldSet getSet() {
        return this.set;
    }

    public void setSet(@NotNull FieldSet fieldSet) {
        Intrinsics.checkNotNullParameter(fieldSet, "<set-?>");
        this.set = fieldSet;
    }

    public final boolean getDistinct() {
        return this.distinct;
    }

    protected final void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    @NotNull
    public final List<Expression<?>> getGroupedByColumns() {
        return this.groupedByColumns;
    }

    @Nullable
    public final Op<Boolean> getHaving() {
        return this.having;
    }

    @Nullable
    public final Op<Boolean> getWhere() {
        return this.where;
    }

    @Override
    @NotNull
    protected Statement<ResultSet> getQueryToExecute() {
        List distinctExpressions = CollectionsKt.distinct((Iterable)this.getSet().getFields());
        return distinctExpressions.size() < this.getSet().getFields().size() ? (Statement)this.copy().adjustSlice((Function2<? super ColumnSet, ? super FieldSet, ? extends FieldSet>)new Function2<ColumnSet, FieldSet, FieldSet>(distinctExpressions){
            final /* synthetic */ List<Expression<?>> $distinctExpressions;
            {
                this.$distinctExpressions = $distinctExpressions;
                super(2);
            }

            @NotNull
            public final FieldSet invoke(@NotNull ColumnSet $this$adjustSlice, @NotNull FieldSet it) {
                Intrinsics.checkNotNullParameter($this$adjustSlice, "$this$adjustSlice");
                Intrinsics.checkNotNullParameter(it, "it");
                return $this$adjustSlice.slice(this.$distinctExpressions);
            }
        }) : (Statement)this;
    }

    @NotNull
    public Query copy() {
        Query query2;
        Query copy2 = query2 = new Query(this.getSet(), this.where);
        boolean bl = false;
        this.copyTo(copy2);
        copy2.distinct = this.distinct;
        copy2.groupedByColumns = CollectionsKt.toMutableList((Collection)this.groupedByColumns);
        copy2.having = this.having;
        copy2.forUpdate = this.forUpdate;
        return query2;
    }

    @NotNull
    public Query forUpdate(@NotNull ForUpdateOption option) {
        Intrinsics.checkNotNullParameter(option, "option");
        this.forUpdate = option;
        return this;
    }

    @NotNull
    public Query notForUpdate() {
        this.forUpdate = ForUpdateOption.NoForUpdateOption.INSTANCE;
        return this;
    }

    @Override
    @NotNull
    public Query withDistinct(boolean value) {
        Query query2;
        Query $this$withDistinct_u24lambda_u241 = query2 = this;
        boolean bl = false;
        $this$withDistinct_u24lambda_u241.distinct = value;
        return query2;
    }

    @NotNull
    public final Query adjustSlice(@NotNull Function2<? super ColumnSet, ? super FieldSet, ? extends FieldSet> body) {
        Query query2;
        Intrinsics.checkNotNullParameter(body, "body");
        Query $this$adjustSlice_u24lambda_u242 = query2 = this;
        boolean bl = false;
        $this$adjustSlice_u24lambda_u242.setSet(body.invoke($this$adjustSlice_u24lambda_u242.getSet().getSource(), $this$adjustSlice_u24lambda_u242.getSet()));
        return query2;
    }

    @NotNull
    public final Query adjustColumnSet(@NotNull Function1<? super ColumnSet, ? extends ColumnSet> body) {
        Intrinsics.checkNotNullParameter(body, "body");
        return this.adjustSlice((Function2<? super ColumnSet, ? super FieldSet, ? extends FieldSet>)new Function2<ColumnSet, FieldSet, FieldSet>(body){
            final /* synthetic */ Function1<ColumnSet, ColumnSet> $body;
            {
                this.$body = $body;
                super(2);
            }

            @NotNull
            public final FieldSet invoke(@NotNull ColumnSet $this$adjustSlice, @NotNull FieldSet oldSlice) {
                Intrinsics.checkNotNullParameter($this$adjustSlice, "$this$adjustSlice");
                Intrinsics.checkNotNullParameter(oldSlice, "oldSlice");
                return this.$body.invoke($this$adjustSlice).slice(oldSlice.getFields());
            }
        });
    }

    @NotNull
    public final Query adjustWhere(@NotNull Function1<? super Op<Boolean>, ? extends Op<Boolean>> body) {
        Query query2;
        Intrinsics.checkNotNullParameter(body, "body");
        Query $this$adjustWhere_u24lambda_u243 = query2 = this;
        boolean bl = false;
        $this$adjustWhere_u24lambda_u243.where = body.invoke($this$adjustWhere_u24lambda_u243.where);
        return query2;
    }

    @NotNull
    public final Query adjustHaving(@NotNull Function1<? super Op<Boolean>, ? extends Op<Boolean>> body) {
        Query query2;
        Intrinsics.checkNotNullParameter(body, "body");
        Query $this$adjustHaving_u24lambda_u244 = query2 = this;
        boolean bl = false;
        $this$adjustHaving_u24lambda_u244.having = body.invoke($this$adjustHaving_u24lambda_u244.having);
        return query2;
    }

    public final boolean hasCustomForUpdateState() {
        return this.forUpdate != null;
    }

    public final boolean isForUpdate() {
        boolean bl;
        ForUpdateOption forUpdateOption = this.forUpdate;
        if (forUpdateOption != null) {
            ForUpdateOption it = forUpdateOption;
            boolean bl2 = false;
            bl = !Intrinsics.areEqual(it, ForUpdateOption.NoForUpdateOption.INSTANCE);
        } else {
            bl = false;
        }
        return bl && DatabaseDialectKt.getCurrentDialect().supportsSelectForUpdate();
    }

    @Override
    @Nullable
    public ResultSet executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
        Integer fetchSize;
        Intrinsics.checkNotNullParameter($this$executeInternal, "<this>");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        Integer n = this.getFetchSize();
        if (n == null) {
            n = transaction2.getDb().getDefaultFetchSize();
        }
        if ((fetchSize = n) != null) {
            $this$executeInternal.setFetchSize(fetchSize);
        }
        return $this$executeInternal.executeQuery();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        builder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(this){
            final /* synthetic */ Query this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                block11: {
                    Object object;
                    Object it;
                    Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                    $this$invoke.append("SELECT ");
                    if (this.this$0.getCount()) {
                        $this$invoke.append("COUNT(*)");
                    } else {
                        if (this.this$0.getDistinct()) {
                            $this$invoke.append("DISTINCT ");
                        }
                        QueryBuilder.appendTo$default($this$invoke, this.this$0.getSet().getRealFields(), null, null, null, (Function2)prepareSQL.1.INSTANCE, 7, null);
                    }
                    if (!Intrinsics.areEqual(this.this$0.getSet().getSource(), Table.Dual.INSTANCE) || DatabaseDialectKt.getCurrentDialect().getSupportsDualTableConcept()) {
                        $this$invoke.append(" FROM ");
                        this.this$0.getSet().getSource().describe(this.this$0.getTransaction(), $this$invoke);
                    }
                    Op<Boolean> op = this.this$0.getWhere();
                    if (op != null) {
                        it = op;
                        boolean bl = false;
                        $this$invoke.append(" WHERE ");
                        $this$invoke.unaryPlus((Expression)it);
                    }
                    if (!this.this$0.getCount()) {
                        if (!((Collection)this.this$0.getGroupedByColumns()).isEmpty()) {
                            $this$invoke.append(" GROUP BY ");
                            QueryBuilder.appendTo$default($this$invoke, this.this$0.getGroupedByColumns(), null, null, null, (Function2)prepareSQL.3.INSTANCE, 7, null);
                        }
                        Op<Boolean> op2 = this.this$0.getHaving();
                        if (op2 != null) {
                            it = op2;
                            boolean bl = false;
                            $this$invoke.append(" HAVING ");
                            $this$invoke.append((Expression)it);
                        }
                        if (!((Collection)this.this$0.getOrderByExpressions()).isEmpty()) {
                            $this$invoke.append(" ORDER BY ");
                            QueryBuilder.appendTo$default($this$invoke, this.this$0.getOrderByExpressions(), null, null, null, (Function2)prepareSQL.5.INSTANCE, 7, null);
                        }
                        Integer n = this.this$0.getLimit();
                        if (n != null) {
                            object = n;
                            it = this.this$0;
                            int it2 = ((Number)object).intValue();
                            boolean bl = false;
                            $this$invoke.append(" ");
                            $this$invoke.append(DatabaseDialectKt.getCurrentDialect().getFunctionProvider().queryLimit(it2, ((AbstractQuery)it).getOffset(), !((Collection)((AbstractQuery)it).getOrderByExpressions()).isEmpty()));
                        }
                    }
                    if (!this.this$0.isForUpdate()) break block11;
                    ForUpdateOption forUpdateOption = Query.access$getForUpdate$p(this.this$0);
                    if (forUpdateOption != null) {
                        object = forUpdateOption;
                        ForUpdateOption $this$invoke_u24lambda_u243 = object;
                        boolean bl = false;
                        $this$invoke.append(' ' + $this$invoke_u24lambda_u243.getQuerySuffix());
                    }
                }
            }
        });
        return builder.toString();
    }

    @NotNull
    public final Query groupBy(Expression<?> ... columns2) {
        Intrinsics.checkNotNullParameter(columns2, "columns");
        for (Expression<?> column : columns2) {
            List<? extends Expression<?>> list = this.groupedByColumns;
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.MutableList<org.jetbrains.exposed.sql.Expression<*>>");
            TypeIntrinsics.asMutableList(list).add(column);
        }
        return this;
    }

    @NotNull
    public final Query having(@NotNull Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>> op) {
        Intrinsics.checkNotNullParameter(op, "op");
        Op<Boolean> oop = op.invoke(SqlExpressionBuilder.INSTANCE);
        if (this.having != null) {
            throw new IllegalStateException(("HAVING clause is specified twice. Old value = '" + this.having + "', new value = '" + oop + '\'').toString());
        }
        this.having = oop;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        if (this.distinct || !((Collection)this.groupedByColumns).isEmpty() || this.getLimit() != null) {
            long l2;
            FieldSet originalSet = this.getSet();
            try {
                Ref.IntRef expInx = new Ref.IntRef();
                this.adjustSlice((Function2<? super ColumnSet, ? super FieldSet, ? extends FieldSet>)new Function2<ColumnSet, FieldSet, FieldSet>(originalSet, expInx, this){
                    final /* synthetic */ FieldSet $originalSet;
                    final /* synthetic */ Ref.IntRef $expInx;
                    final /* synthetic */ Query this$0;
                    {
                        this.$originalSet = $originalSet;
                        this.$expInx = $expInx;
                        this.this$0 = $receiver;
                        super(2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final FieldSet invoke(@NotNull ColumnSet $this$adjustSlice, @NotNull FieldSet it) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullParameter($this$adjustSlice, "$this$adjustSlice");
                        Intrinsics.checkNotNullParameter(it, "it");
                        Iterable iterable = this.$originalSet.getFields();
                        Ref.IntRef intRef = this.$expInx;
                        Query query2 = this.this$0;
                        ColumnSet columnSet = $this$adjustSlice;
                        boolean $i$f$map = false;
                        void var7_8 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            Expression expression = (Expression)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Expression expression2 = it2 instanceof ExpressionAlias ? (ExpressionAlias)it2 : null;
                            if (expression2 == null && ((expression2 = it2 instanceof Column ? (Column)it2 : null) == null || (expression2 = Query.access$count$makeAlias((Column)expression2, query2)) == null)) {
                                int n = intRef.element;
                                intRef.element = n + 1;
                                expression2 = AliasKt.alias(it2, "exp" + n);
                            }
                            collection.add(expression2);
                        }
                        return columnSet.slice((List)destination$iv$iv);
                    }
                });
                l2 = QueriesKt.selectAll(AliasKt.alias((AbstractQuery)this, "subquery")).count();
            }
            finally {
                this.setSet(originalSet);
            }
            l = l2;
        } else {
            long l3;
            try {
                this.setCount(true);
                Object r = this.getTransaction().exec(this, count.2.INSTANCE);
                Intrinsics.checkNotNull(r);
                l3 = ((Number)r).longValue();
            }
            finally {
                this.setCount(false);
            }
            l = l3;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean empty() {
        Integer oldLimit = this.getLimit();
        try {
            boolean bl;
            if (!this.isForUpdate()) {
                this.setLimit(1);
            }
            Object t = this.getTransaction().exec(this);
            Intrinsics.checkNotNull(t);
            ResultSet resultSet = (ResultSet)t;
            boolean it = bl = resultSet.next();
            boolean bl2 = false;
            resultSet.close();
            bl = !bl;
            return bl;
        }
        finally {
            this.setLimit(oldLimit);
        }
    }

    private static final ExpressionAlias<? extends Object> count$makeAlias(Column<?> $this$count_u24makeAlias, Query this$0) {
        return AliasKt.alias($this$count_u24makeAlias, this$0.getTransaction().getDb().getIdentifierManager().quoteIfNecessary($this$count_u24makeAlias.getTable().getTableName() + '_' + $this$count_u24makeAlias.getName()));
    }

    public static final /* synthetic */ ForUpdateOption access$getForUpdate$p(Query $this) {
        return $this.forUpdate;
    }

    public static final /* synthetic */ ExpressionAlias access$count$makeAlias(Column $receiver, Query this$0) {
        return Query.count$makeAlias($receiver, this$0);
    }
}

