/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.exceptions.ExposedSQLException;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.DecimalColumnType;
import org.jetbrains.exposed.sql.EnumerationNameColumnType;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Function;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.JsonColumnMarker;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.SizedIterable;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.VarCharColumnType;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001KB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ/\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\r\u001a\u00020\n2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\u0011J/\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ/\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ3\u0010\u0015\u001a\u00020\u0010\"\b\b\u0000\u0010\u0016*\u00020\b2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00160\u0007\"\u0002H\u00162\b\b\u0002\u0010\u0017\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0019\u001a\u00020\u00102\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010 \u001a\u00020\u0014J3\u0010!\u001a\u00020\u00102\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\"J)\u0010#\u001a\u00020\u00102\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0\u0007\"\u00020%2\b\b\u0002\u0010\u0017\u001a\u00020\n\u00a2\u0006\u0002\u0010&J)\u0010'\u001a\u00020\u00102\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0\u0007\"\u00020)2\b\b\u0002\u0010\u0017\u001a\u00020\n\u00a2\u0006\u0002\u0010*J%\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010,J)\u0010-\u001a\u00020\u00102\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0018J)\u0010.\u001a\u00020\u00102\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001bJ3\u0010/\u001a\u00020\u00102\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0\u0007\"\u00020%2\b\b\u0002\u00100\u001a\u00020\n2\b\b\u0002\u0010\u0017\u001a\u00020\n\u00a2\u0006\u0002\u00101J)\u00102\u001a\u00020\u00102\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0\u0007\"\u00020)2\b\b\u0002\u0010\u0017\u001a\u00020\n\u00a2\u0006\u0002\u0010*J\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J2\u00105\u001a\u0002H6\"\u0004\b\u0000\u001062\u0006\u00107\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H609H\u0082\b\u00a2\u0006\u0002\u0010:J\u0018\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020%2\b\b\u0002\u0010\u0017\u001a\u00020\nJ\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0>J/\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010@\u001a\u00020\u0005*\u00020A2\n\u0010B\u001a\u0006\u0012\u0002\b\u00030C2\n\u0010D\u001a\u0006\u0012\u0002\b\u00030EH\u0002J\"\u0010F\u001a\u00020\u0010*\u00020G2\u0006\u0010\u0017\u001a\u00020\n2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u001e\u0010I\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0016*\u00020G2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002H\u001609\u00a8\u0006L"}, d2={"Lorg/jetbrains/exposed/sql/SchemaUtils;", "", "()V", "addMissingColumnConstraints", "", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "withLogs", "", "([Lorg/jetbrains/exposed/sql/Table;Z)Ljava/util/List;", "addMissingColumnsStatements", "checkCycle", "([Lorg/jetbrains/exposed/sql/Table;)Z", "checkExcessiveIndices", "", "([Lorg/jetbrains/exposed/sql/Table;)V", "checkMappingConsistence", "checkMissingIndices", "Lorg/jetbrains/exposed/sql/Index;", "create", "T", "inBatch", "([Lorg/jetbrains/exposed/sql/Table;Z)V", "createDatabase", "databases", "([Ljava/lang/String;Z)V", "createFKey", "foreignKey", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "createIndex", "index", "createMissingTablesAndColumns", "([Lorg/jetbrains/exposed/sql/Table;ZZ)V", "createSchema", "schemas", "Lorg/jetbrains/exposed/sql/Schema;", "([Lorg/jetbrains/exposed/sql/Schema;Z)V", "createSequence", "seq", "Lorg/jetbrains/exposed/sql/Sequence;", "([Lorg/jetbrains/exposed/sql/Sequence;Z)V", "createStatements", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/List;", "drop", "dropDatabase", "dropSchema", "cascade", "([Lorg/jetbrains/exposed/sql/Schema;ZZ)V", "dropSequence", "listDatabases", "listTables", "logTimeSpent", "R", "message", "block", "Lkotlin/Function0;", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "setSchema", "schema", "sortTablesByReferences", "", "statementsRequiredToActualizeScheme", "dbDefaultToString", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "column", "Lorg/jetbrains/exposed/sql/Column;", "exp", "Lorg/jetbrains/exposed/sql/Expression;", "execStatements", "Lorg/jetbrains/exposed/sql/Transaction;", "statements", "withDataBaseLock", "body", "TableDepthGraph", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nSchemaUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaUtils.kt\norg/jetbrains/exposed/sql/SchemaUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,709:1\n11#1,7:754\n11#1,7:761\n11#1,7:817\n11#1,7:846\n11#1,7:853\n11#1,7:860\n11#1,7:867\n11#1,3:874\n14#1,4:880\n11#1,3:894\n14#1,4:899\n11#1,3:903\n14#1,4:908\n11#1,3:912\n14#1,4:920\n819#2:710\n847#2,2:711\n1360#2:713\n1446#2,2:714\n3190#2,10:716\n1360#2:726\n1446#2,5:727\n1448#2,3:732\n1726#2,3:747\n1726#2,3:750\n1603#2,9:768\n1855#2:777\n1856#2:779\n1612#2:780\n766#2:781\n857#2,2:782\n1446#2,5:784\n766#2:789\n857#2:790\n1747#2,3:791\n858#2:794\n1855#2,2:795\n1238#2,4:799\n1549#2:827\n1620#2,3:828\n766#2:877\n857#2,2:878\n766#2:917\n857#2,2:918\n1360#2:924\n1446#2,5:925\n1855#2,2:940\n1477#2:949\n1502#2,3:950\n1505#2,3:960\n1855#2,2:973\n288#2,2:976\n766#2:987\n857#2,2:988\n766#2:990\n857#2,2:991\n1360#2:993\n1446#2,5:994\n819#2:999\n847#2,2:1000\n1360#2:1002\n1446#2,5:1003\n766#2:1008\n857#2,2:1009\n1360#2:1011\n1446#2,5:1012\n819#2:1017\n847#2,2:1018\n766#2:1020\n857#2,2:1021\n9972#3:735\n10394#3,5:736\n9972#3:741\n10394#3,5:742\n18717#3,2:815\n9972#3:824\n10394#3,2:825\n10396#3,3:831\n9972#3:834\n10394#3,5:835\n9972#3:840\n10394#3,5:841\n22765#3,10:884\n1#4:753\n1#4:778\n453#5:797\n403#5:798\n494#5,7:803\n526#5:930\n511#5,6:931\n372#5,7:953\n526#5:963\n511#5,6:964\n372#5,7:978\n96#6,5:810\n215#6,2:937\n215#6:939\n216#6:942\n76#6:943\n96#6,5:944\n215#6,2:970\n215#6:972\n216#6:975\n215#6,2:985\n37#7,2:897\n37#7,2:906\n37#7,2:915\n*S KotlinDebug\n*F\n+ 1 SchemaUtils.kt\norg/jetbrains/exposed/sql/SchemaUtils\n*L\n223#1:754,7\n227#1:761,7\n287#1:817,7\n429#1:846,7\n432#1:853,7\n437#1:860,7\n440#1:867,7\n445#1:874,3\n445#1:880,4\n463#1:894,3\n463#1:899,4\n466#1:903,3\n466#1:908,4\n470#1:912,3\n470#1:920,4\n96#1:710\n96#1:711,2\n98#1:713\n98#1:714,2\n99#1:716,10\n100#1:726\n100#1:727,5\n98#1:732,3\n121#1:747,3\n125#1:750,3\n236#1:768,9\n236#1:777\n236#1:779\n236#1:780\n240#1:781\n240#1:782,2\n242#1:784,5\n246#1:789\n246#1:790\n247#1:791,3\n246#1:794\n250#1:795,2\n254#1:799,4\n292#1:827\n292#1:828,3\n449#1:877\n449#1:878,2\n474#1:917\n474#1:918,2\n486#1:924\n486#1:925,5\n504#1:940,2\n513#1:949\n513#1:950,3\n513#1:960,3\n523#1:973,2\n564#1:976,2\n622#1:987\n622#1:988,2\n624#1:990\n624#1:991,2\n626#1:993\n626#1:994,5\n671#1:999\n671#1:1000,2\n672#1:1002\n672#1:1003,5\n699#1:1008\n699#1:1009,2\n701#1:1011\n701#1:1012,5\n543#1:1017\n543#1:1018,2\n550#1:1020\n550#1:1021,2\n108#1:735\n108#1:736,5\n115#1:741\n115#1:742,5\n269#1:815,2\n291#1:824\n291#1:825,2\n291#1:831,3\n348#1:834\n348#1:835,5\n395#1:840\n395#1:841,5\n462#1:884,10\n236#1:778\n254#1:797\n254#1:798\n264#1:803,7\n490#1:930\n490#1:931,6\n513#1:953,7\n514#1:963\n514#1:964,6\n574#1:978,7\n266#1:810,5\n494#1:937,2\n503#1:939\n503#1:942\n511#1:943\n511#1:944,5\n517#1:970,2\n522#1:972\n522#1:975\n583#1:985,2\n464#1:897,2\n467#1:906,2\n472#1:915,2\n*E\n"})
public final class SchemaUtils {
    @NotNull
    public static final SchemaUtils INSTANCE = new SchemaUtils();

    private SchemaUtils() {
    }

    private final <R> R logTimeSpent(String message, boolean withLogs, Function0<? extends R> block) {
        R r;
        boolean $i$f$logTimeSpent = false;
        if (withLogs) {
            long start = System.currentTimeMillis();
            R answer = block.invoke();
            SQLLogKt.getExposedLogger().info(message + " took " + (System.currentTimeMillis() - start) + "ms");
            r = answer;
        } else {
            r = block.invoke();
        }
        return r;
    }

    @NotNull
    public final List<Table> sortTablesByReferences(@NotNull Iterable<? extends Table> tables) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        return new TableDepthGraph(tables).sorted();
    }

    public final boolean checkCycle(Table ... tables) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        return new TableDepthGraph((Iterable<? extends Table>)ArraysKt.toList(tables)).hasCycle();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> createStatements(Table ... tables) {
        void $this$flatMapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        if (tables.length == 0) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filterNot$iv = this.sortTablesByReferences((Iterable<? extends Table>)ArraysKt.toList(tables));
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Table it = (Table)element$iv$iv;
            boolean bl = false;
            if (QueriesKt.exists(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toCreate = (List)destination$iv$iv;
        ArrayList alters = new ArrayList();
        Iterable $this$flatMap$iv = toCreate;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            Object element$iv2;
            Table table = (Table)element$iv$iv;
            boolean bl = false;
            Iterable $this$partition$iv = table.getDdl();
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                if (StringsKt.startsWith$default(it, "CREATE ", false, 2, null)) {
                    first$iv.add(element$iv2);
                    continue;
                }
                second$iv.add(element$iv2);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List create = pair.component1();
            List alter = pair.component2();
            Iterable $this$flatMap$iv2 = table.getIndices();
            boolean $i$f$flatMap2 = false;
            element$iv2 = $this$flatMap$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                Index it = (Index)element$iv$iv2;
                boolean bl3 = false;
                Iterable list$iv$iv = INSTANCE.createIndex(it);
                CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
            }
            List indicesDDL = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)alters, alter);
            Iterable list$iv$iv = CollectionsKt.plus((Collection)create, (Iterable)indicesDDL);
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Iterable)alters);
    }

    /*
     * WARNING - void declaration
     */
    public final void createSequence(@NotNull Sequence[] seq, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(seq, "seq");
        Transaction $this$createSequence_u24lambda_u245 = TransactionManager.Companion.current();
        boolean bl = false;
        Sequence[] $this$flatMap$iv = seq;
        boolean $i$f$flatMap = false;
        Sequence[] sequenceArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl2 = false;
            Iterable list$iv$iv = it.createStatement();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List createStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$createSequence_u24lambda_u245, inBatch, createStatements);
    }

    public static /* synthetic */ void createSequence$default(SchemaUtils schemaUtils, Sequence[] sequenceArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.createSequence(sequenceArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void dropSequence(@NotNull Sequence[] seq, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(seq, "seq");
        Transaction $this$dropSequence_u24lambda_u247 = TransactionManager.Companion.current();
        boolean bl = false;
        Sequence[] $this$flatMap$iv = seq;
        boolean $i$f$flatMap = false;
        Sequence[] sequenceArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl2 = false;
            Iterable list$iv$iv = it.dropStatement();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List dropStatements = (List)destination$iv$iv;
        INSTANCE.execStatements($this$dropSequence_u24lambda_u247, inBatch, dropStatements);
    }

    public static /* synthetic */ void dropSequence$default(SchemaUtils schemaUtils, Sequence[] sequenceArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.dropSequence(sequenceArray, bl);
    }

    @NotNull
    public final List<String> createFKey(@NotNull ForeignKeyConstraint foreignKey) {
        boolean allTargetColumnsBelongToTheSameTable;
        ForeignKeyConstraint $this$createFKey_u24lambda_u2415;
        block12: {
            boolean bl;
            boolean allFromColumnsBelongsToTheSameTable;
            block11: {
                boolean bl2;
                Intrinsics.checkNotNullParameter(foreignKey, "foreignKey");
                $this$createFKey_u24lambda_u2415 = foreignKey;
                boolean bl3 = false;
                Iterable $this$all$iv = $this$createFKey_u24lambda_u2415.getFrom();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Column it = (Column)element$iv;
                        boolean bl4 = false;
                        if (Intrinsics.areEqual(it.getTable(), $this$createFKey_u24lambda_u2415.getFromTable())) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = allFromColumnsBelongsToTheSameTable = true;
                }
            }
            if (!allFromColumnsBelongsToTheSameTable) {
                boolean $i$a$-require-SchemaUtils$createFKey$1$62 = false;
                String $i$a$-require-SchemaUtils$createFKey$1$62 = "not all referencing columns of " + foreignKey + " belong to the same table";
                throw new IllegalArgumentException($i$a$-require-SchemaUtils$createFKey$1$62.toString());
            }
            Iterable $this$all$iv = $this$createFKey_u24lambda_u2415.getTarget();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Column it = (Column)element$iv;
                    boolean bl5 = false;
                    if (Intrinsics.areEqual(it.getTable(), $this$createFKey_u24lambda_u2415.getTargetTable())) continue;
                    bl = false;
                    break block12;
                }
                bl = allTargetColumnsBelongToTheSameTable = true;
            }
        }
        if (!allTargetColumnsBelongToTheSameTable) {
            boolean bl = false;
            String string = "not all referenced columns of " + foreignKey + " belong to the same table";
            throw new IllegalArgumentException(string.toString());
        }
        if (!($this$createFKey_u24lambda_u2415.getFrom().size() == $this$createFKey_u24lambda_u2415.getTarget().size())) {
            boolean $i$a$-require-SchemaUtils$createFKey$1$72 = false;
            String $i$a$-require-SchemaUtils$createFKey$1$72 = foreignKey + " referencing columns are not in accordance with referenced";
            throw new IllegalArgumentException($i$a$-require-SchemaUtils$createFKey$1$72.toString());
        }
        if (!($this$createFKey_u24lambda_u2415.getDeleteRule() != null || $this$createFKey_u24lambda_u2415.getUpdateRule() != null)) {
            boolean $i$a$-require-SchemaUtils$createFKey$1$82 = false;
            String $i$a$-require-SchemaUtils$createFKey$1$82 = foreignKey + " has no reference constraint actions";
            throw new IllegalArgumentException($i$a$-require-SchemaUtils$createFKey$1$82.toString());
        }
        if (!(CollectionsKt.toHashSet((Iterable)$this$createFKey_u24lambda_u2415.getTarget()).size() == $this$createFKey_u24lambda_u2415.getTarget().size())) {
            boolean bl = false;
            String string = "not all referenced columns of " + foreignKey + " are unique";
            throw new IllegalArgumentException(string.toString());
        }
        return $this$createFKey_u24lambda_u2415.createStatement();
    }

    @NotNull
    public final List<String> createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter(index, "index");
        return index.createStatement();
    }

    private final String dbDefaultToString(DataTypeProvider $this$dbDefaultToString, Column<?> column, Expression<?> exp) {
        String string;
        Expression<?> expression = exp;
        if (expression instanceof LiteralOp) {
            DatabaseDialect dialect2 = DatabaseDialectKt.getCurrentDialect();
            Object value = ((LiteralOp)exp).getValue();
            if (value instanceof Boolean) {
                DatabaseDialect databaseDialect = dialect2;
                string = databaseDialect instanceof MysqlDialect ? (((Boolean)value).booleanValue() ? "1" : "0") : (databaseDialect instanceof PostgreSQLDialect ? String.valueOf((Boolean)value) : $this$dbDefaultToString.booleanToStatementString((Boolean)value));
            } else if (value instanceof String) {
                IColumnType iColumnType;
                string = dialect2 instanceof PostgreSQLDialect ? ((iColumnType = column.getColumnType()) instanceof VarCharColumnType ? "" + '\'' + value + "'::character varying" : (iColumnType instanceof TextColumnType ? "" + '\'' + value + "'::text" : $this$dbDefaultToString.processForDefaultValue(exp))) : (dialect2 instanceof OracleDialect || H2Kt.getH2Mode(dialect2) == H2Dialect.H2CompatibilityMode.Oracle ? (column.getColumnType() instanceof VarCharColumnType && Intrinsics.areEqual(value, "") ? "NULL" : (column.getColumnType() instanceof TextColumnType && Intrinsics.areEqual(value, "") ? "NULL" : (String)value)) : (String)value);
            } else if (value instanceof Enum) {
                string = ((LiteralOp)exp).getColumnType() instanceof EnumerationNameColumnType ? (dialect2 instanceof PostgreSQLDialect ? '\'' + ((Enum)value).name() + "'::character varying" : ((Enum)value).name()) : $this$dbDefaultToString.processForDefaultValue(exp);
            } else if (value instanceof BigDecimal) {
                String string2;
                if (dialect2 instanceof MysqlDialect) {
                    BigDecimal bigDecimal = (BigDecimal)value;
                    IColumnType iColumnType = ((LiteralOp)exp).getColumnType();
                    Intrinsics.checkNotNull(iColumnType, "null cannot be cast to non-null type org.jetbrains.exposed.sql.DecimalColumnType");
                    string2 = bigDecimal.setScale(((DecimalColumnType)iColumnType).getScale()).toString();
                } else {
                    string2 = $this$dbDefaultToString.processForDefaultValue(exp);
                }
                String string3 = string2;
                Intrinsics.checkNotNullExpressionValue(string3, "when (dialect) {\n       \u2026xp)\n                    }");
                string = string3;
            } else if (column.getColumnType() instanceof JsonColumnMarker) {
                String processed = $this$dbDefaultToString.processForDefaultValue(exp);
                DatabaseDialect databaseDialect = dialect2;
                if (databaseDialect instanceof PostgreSQLDialect) {
                    if (((JsonColumnMarker)((Object)column.getColumnType())).getUsesBinaryFormat()) {
                        CharSequence charSequence = processed;
                        Regex regex = new Regex("(\"|})(:|,)(\\[|\\{|\")");
                        String string4 = "$1$2 $3";
                        string = regex.replace(charSequence, string4);
                    } else {
                        string = processed;
                    }
                } else if (databaseDialect instanceof MariaDBDialect) {
                    char[] cArray = new char[]{'\''};
                    string = StringsKt.trim(processed, cArray);
                } else if (databaseDialect instanceof MysqlDialect) {
                    char[] cArray = new char[]{'(', ')', '\''};
                    string = "_utf8mb4\\'" + StringsKt.trim(processed, cArray) + '\\';
                } else {
                    char[] cArray = new char[]{'\''};
                    string = StringsKt.trim(processed, cArray);
                }
            } else {
                string = $this$dbDefaultToString.processForDefaultValue(exp);
            }
        } else if (expression instanceof Function) {
            String processed = $this$dbDefaultToString.processForDefaultValue(exp);
            if (((Function)exp).getColumnType() instanceof IDateColumnType && (StringsKt.startsWith$default(processed, "CURRENT_TIMESTAMP", false, 2, null) || Intrinsics.areEqual(processed, "GETDATE()"))) {
                DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
                if (databaseDialect instanceof SQLServerDialect) {
                    processed = "getdate";
                } else if (databaseDialect instanceof MariaDBDialect) {
                    String string5 = processed.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    processed = string5;
                }
            }
            string = processed;
        } else {
            string = $this$dbDefaultToString.processForDefaultValue(exp);
        }
        return string;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    public final List<String> addMissingColumnsStatements(@NotNull Table[] tables, boolean withLogs) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        if (tables.length == 0) {
            return CollectionsKt.emptyList();
        }
        statements = new ArrayList<String>();
        var5_4 = this;
        message$iv = "Extracting table columns";
        $i$f$logTimeSpent = false;
        if (withLogs) {
            start$iv = System.currentTimeMillis();
            $i$a$-logTimeSpent-SchemaUtils$addMissingColumnsStatements$existingTablesColumns$1 = false;
            answer$iv = DatabaseDialectKt.getCurrentDialect().tableColumns(Arrays.copyOf(tables, tables.length));
            SQLLogKt.getExposedLogger().info((String)message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            v0 = answer$iv;
        } else {
            $i$a$-logTimeSpent-SchemaUtils$addMissingColumnsStatements$existingTablesColumns$1 = false;
            v0 = DatabaseDialectKt.getCurrentDialect().tableColumns(Arrays.copyOf(tables, tables.length));
        }
        existingTablesColumns = v0;
        message$iv = this;
        message$iv = "Extracting primary keys";
        $i$f$logTimeSpent = false;
        if (withLogs) {
            start$iv = System.currentTimeMillis();
            $i$a$-logTimeSpent-SchemaUtils$addMissingColumnsStatements$existingPrimaryKeys$1 = false;
            answer$iv = DatabaseDialectKt.getCurrentDialect().existingPrimaryKeys(Arrays.copyOf(tables, tables.length));
            SQLLogKt.getExposedLogger().info(message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            v1 = answer$iv;
        } else {
            $i$a$-logTimeSpent-SchemaUtils$addMissingColumnsStatements$existingPrimaryKeys$1 = false;
            v1 = DatabaseDialectKt.getCurrentDialect().existingPrimaryKeys(Arrays.copyOf(tables, tables.length));
        }
        existingPrimaryKeys = v1;
        dbSupportsAlterTableWithAddColumn = TransactionManager.Companion.current().getDb().getSupportsAlterTableWithAddColumn();
        var8_11 = tables.length;
        for (var7_9 = 0; var7_9 < var8_11; ++var7_9) {
            table = tables[var7_9];
            v2 /* !! */  = existingTablesColumns.get(table);
            if (v2 /* !! */  == null) {
                v2 /* !! */  = CollectionsKt.emptyList();
            }
            thisTableExistingColumns = v2 /* !! */ ;
            $this$mapNotNull$iv = table.getColumns();
            $i$f$mapNotNull = false;
            var14_24 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var19_44 = $this$forEach$iv$iv$iv.iterator();
            while (var19_44.hasNext()) {
                block27: {
                    element$iv$iv = element$iv$iv$iv = var19_44.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    column = (Column)element$iv$iv;
                    $i$a$-mapNotNull-SchemaUtils$addMissingColumnsStatements$existingTableColumns$1 = false;
                    var25_71 = thisTableExistingColumns;
                    for (T var27_75 : var25_71) {
                        it = (ColumnMetadata)var27_75;
                        $i$a$-find-SchemaUtils$addMissingColumnsStatements$existingTableColumns$1$existingColumn$1 = false;
                        if (!StringsKt.equals(column.nameUnquoted(), it.getName(), true)) continue;
                        v3 = var27_75;
                        break block27;
                    }
                    v3 = null;
                }
                v4 = existingColumn = (ColumnMetadata)v3;
                if ((v4 != null ? TuplesKt.to(column, v4) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            existingTableColumns = MapsKt.toMap((List)destination$iv$iv);
            $this$filter$iv = table.getColumns();
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            $i$f$forEach = $this$filterTo$iv$iv.iterator();
            while ($i$f$forEach.hasNext()) {
                element$iv$iv = $i$f$forEach.next();
                it = (Column)element$iv$iv;
                $i$a$-filter-SchemaUtils$addMissingColumnsStatements$missingTableColumns$1 = false;
                v5 = !existingTableColumns.containsKey(it);
                if (!v5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            missingTableColumns = (List)destination$iv$iv;
            $this$flatMapTo$iv = missingTableColumns;
            $i$f$flatMapTo = false;
            $this$filterTo$iv$iv = $this$flatMapTo$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                element$iv = $this$filterTo$iv$iv.next();
                it = (Column)element$iv;
                $i$a$-flatMapTo-SchemaUtils$addMissingColumnsStatements$1 = false;
                list$iv = it.getDdl();
                CollectionsKt.addAll((Collection)statements, list$iv);
            }
            (Collection)statements;
            if (!dbSupportsAlterTableWithAddColumn) continue;
            $this$filter$iv = table.getIndices();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            $i$a$-flatMapTo-SchemaUtils$addMissingColumnsStatements$1 = $this$filterTo$iv$iv.iterator();
            while ($i$a$-flatMapTo-SchemaUtils$addMissingColumnsStatements$1.hasNext()) {
                block28: {
                    element$iv$iv = $i$a$-flatMapTo-SchemaUtils$addMissingColumnsStatements$1.next();
                    index = (Index)element$iv$iv;
                    $i$a$-filter-SchemaUtils$addMissingColumnsStatements$2 = false;
                    $this$any$iv = index.getColumns();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v6 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Column)element$iv;
                            $i$a$-any-SchemaUtils$addMissingColumnsStatements$2$1 = false;
                            if (!missingTableColumns.contains(it)) continue;
                            v6 = true;
                            break block28;
                        }
                        v6 = false;
                    }
                }
                if (!v6) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                element$iv = $this$filterTo$iv$iv.next();
                it = (Index)element$iv;
                $i$a$-forEach-SchemaUtils$addMissingColumnsStatements$3 = false;
                statements.addAll((Collection)SchemaUtils.INSTANCE.createIndex(it));
            }
            dataTypeProvider = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider();
            $this$mapValues$iv = existingTableColumns;
            $i$f$mapValues = false;
            it = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity($this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                $i$a$-mapNotNull-SchemaUtils$addMissingColumnsStatements$existingTableColumns$1 = (Map.Entry)element$iv$iv$iv;
                element$iv = destination$iv$iv;
                $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                var27_77 = (Map.Entry)element$iv$iv$iv;
                var40_92 = it$iv$iv.getKey();
                var39_91 = element$iv;
                $i$a$-mapValues-SchemaUtils$addMissingColumnsStatements$redoColumns$1 = false;
                col = (Column)var27_77.getKey();
                existingCol = (ColumnMetadata)var27_77.getValue();
                columnType = col.getColumnType();
                v7 = incorrectNullability = existingCol.getNullable() != columnType.getNullable();
                if (existingCol.getAutoIncrement() == ColumnTypeKt.isAutoInc(columnType)) ** GOTO lbl-1000
                v8 = ColumnTypeKt.getAutoIncColumnType(col);
                if ((v8 != null ? v8.getAutoincSeq() : null) == null) {
                    v9 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v9 = false;
                }
                incorrectAutoInc = v9;
                v10 = existingCol.getDefaultDbValue();
                if (col.getDbDefaultValue$exposed_core() != null) {
                    var35_87 = v10;
                    $i$a$-let-SchemaUtils$addMissingColumnsStatements$redoColumns$1$incorrectDefaults$1 = false;
                    v11 = SchemaUtils.INSTANCE.dbDefaultToString(dataTypeProvider, col, (Expression<?>)it);
                    v10 = var35_87;
                } else {
                    v11 = null;
                }
                incorrectDefaults = Intrinsics.areEqual(v10, v11) == false;
                incorrectCaseSensitiveName = Intrinsics.areEqual(DatabaseDialectKt.inProperCase(existingCol.getName()), DatabaseDialectKt.inProperCase(col.nameUnquoted())) == false;
                var41_93 = new ColumnDiff(incorrectNullability, incorrectAutoInc, incorrectDefaults, incorrectCaseSensitiveName);
                var39_91.put(var40_92, (ColumnDiff)var41_93);
            }
            $this$mapValues$iv = destination$iv$iv;
            $i$f$filterValues = false;
            result$iv = new LinkedHashMap<K, V>();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                it = (ColumnDiff)entry$iv.getValue();
                $i$a$-filterValues-SchemaUtils$addMissingColumnsStatements$redoColumns$2 = false;
                if (!it.hasDifferences()) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$flatMapTo$iv = redoColumns = (Map)result$iv;
            $i$f$flatMapTo = false;
            var17_37 = $this$flatMapTo$iv.entrySet().iterator();
            while (var17_37.hasNext()) {
                entry$iv = element$iv = var17_37.next();
                $i$a$-flatMapTo-SchemaUtils$addMissingColumnsStatements$4 = false;
                col = (Column)entry$iv.getKey();
                changedState = (ColumnDiff)entry$iv.getValue();
                list$iv = col.modifyStatements(changedState);
                CollectionsKt.addAll((Collection)statements, list$iv);
            }
            (Collection)statements;
            v12 = table.getPrimaryKey();
            if (v12 != null) {
                block29: {
                    pk = var17_37 = v12;
                    $i$a$-takeIf-SchemaUtils$addMissingColumnsStatements$missingPK$1 = false;
                    $this$none$iv = pk.getColumns();
                    $i$f$none = false;
                    var23_66 = $this$none$iv.length;
                    for (var22_62 = 0; var22_62 < var23_66; ++var22_62) {
                        it = element$iv = $this$none$iv[var22_62];
                        $i$a$-none-SchemaUtils$addMissingColumnsStatements$missingPK$1$1 = false;
                        if (!missingTableColumns.contains(it)) continue;
                        v13 = false;
                        break block29;
                    }
                    v13 = true;
                }
                v14 = v13 ? var17_37 : null;
            } else {
                v14 = missingPK = null;
            }
            if (missingPK == null || existingPrimaryKeys.get(table) != null) continue;
            it = var17_37 = missingPK.getName();
            $i$a$-takeIf-SchemaUtils$addMissingColumnsStatements$missingPKName$1 = false;
            missingPKName = table.isCustomPKNameDefined$exposed_core() != false ? var17_37 : null;
            var17_37 = missingPK.getColumns();
            statements.add(DatabaseDialectKt.getCurrentDialect().addPrimaryKey(table, (String)missingPKName, Arrays.copyOf(var17_37, var17_37.length)));
        }
        if (dbSupportsAlterTableWithAddColumn) {
            statements.addAll((Collection)this.addMissingColumnConstraints(Arrays.copyOf(tables, tables.length), withLogs));
        }
        return statements;
    }

    public static /* synthetic */ List addMissingColumnsStatements$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return schemaUtils.addMissingColumnsStatements(tableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> addMissingColumnConstraints(Table[] tables, boolean withLogs) {
        void $this$flatMapTo$iv$iv;
        int n;
        Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> map2;
        SchemaUtils schemaUtils = this;
        String message$iv = "Extracting column constraints";
        boolean $i$f$logTimeSpent = false;
        if (withLogs) {
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> answer$iv = DatabaseDialectKt.getCurrentDialect().columnConstraints(Arrays.copyOf(tables, tables.length));
            SQLLogKt.getExposedLogger().info(message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            map2 = answer$iv;
        } else {
            n = 0;
            map2 = DatabaseDialectKt.getCurrentDialect().columnConstraints(Arrays.copyOf(tables, tables.length));
        }
        Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> existingColumnConstraint = map2;
        Table[] $this$flatMap$iv = tables;
        boolean $i$f$flatMap = false;
        Table[] start$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n2 = ((void)$this$flatMapTo$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            void $this$mapTo$iv$iv;
            void element$iv$iv;
            void table = element$iv$iv = $this$flatMapTo$iv$iv[n];
            boolean bl = false;
            Iterable $this$map$iv = table.getForeignKeys();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                List<ForeignKeyConstraint> list = existingColumnConstraint.get(TuplesKt.to(table, it.getFrom()));
                collection.add(TuplesKt.to(it, list != null ? CollectionsKt.firstOrNull(list) : null));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List foreignKeyConstraints = (List)destination$iv$iv;
        ArrayList statements = new ArrayList();
        for (Pair pair : foreignKeyConstraints) {
            boolean updateRuleMismatch;
            ForeignKeyConstraint foreignKey = (ForeignKeyConstraint)pair.component1();
            ForeignKeyConstraint existingConstraint = (ForeignKeyConstraint)pair.component2();
            if (existingConstraint == null) {
                statements.addAll(this.createFKey(foreignKey));
                continue;
            }
            boolean noForeignKey = !Intrinsics.areEqual(existingConstraint.getTargetTable(), foreignKey.getTargetTable());
            boolean deleteRuleMismatch = foreignKey.getDeleteRule() != existingConstraint.getDeleteRule();
            boolean bl = updateRuleMismatch = foreignKey.getUpdateRule() != existingConstraint.getUpdateRule();
            if (!noForeignKey && !deleteRuleMismatch && !updateRuleMismatch) continue;
            statements.addAll(existingConstraint.dropStatement());
            statements.addAll(this.createFKey(foreignKey));
        }
        return statements;
    }

    private final void execStatements(Transaction $this$execStatements, boolean inBatch, List<String> statements) {
        if (inBatch) {
            $this$execStatements.execInBatch(statements);
        } else {
            for (String statement : statements) {
                Transaction.exec$default($this$execStatements, statement, null, null, 6, null);
            }
        }
    }

    public final <T extends Table> void create(@NotNull T[] tables, boolean inBatch) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        Transaction $this$create_u24lambda_u2435 = TransactionManager.Companion.current();
        boolean bl = false;
        INSTANCE.execStatements($this$create_u24lambda_u2435, inBatch, INSTANCE.createStatements((Table[])Arrays.copyOf(tables, tables.length)));
        $this$create_u24lambda_u2435.commit();
        DatabaseDialectKt.getCurrentDialect().resetCaches();
    }

    public static /* synthetic */ void create$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.create(tableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createDatabase(@NotNull String[] databases, boolean inBatch) {
        Intrinsics.checkNotNullParameter(databases, "databases");
        Transaction transaction2 = TransactionManager.Companion.current();
        try {
            void $this$flatMapTo$iv$iv;
            Transaction $this$createDatabase_u24lambda_u2437 = transaction2;
            boolean bl = false;
            String[] $this$flatMap$iv = databases;
            boolean $i$f$flatMap = false;
            String[] stringArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl2 = false;
                Iterable list$iv$iv = CollectionsKt.listOf(DatabaseDialectKt.getCurrentDialect().createDatabase((String)it));
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List createStatements = (List)destination$iv$iv;
            INSTANCE.execStatements($this$createDatabase_u24lambda_u2437, inBatch, createStatements);
        }
        catch (ExposedSQLException exception) {
            if (DatabaseDialectKt.getCurrentDialect().getRequiresAutoCommitOnCreateDrop() && !transaction2.getConnection().getAutoCommit()) {
                throw new IllegalStateException(DatabaseDialectKt.getCurrentDialect().getName() + " requires autoCommit to be enabled for CREATE DATABASE", exception);
            }
            throw exception;
        }
    }

    public static /* synthetic */ void createDatabase$default(SchemaUtils schemaUtils, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.createDatabase(stringArray, bl);
    }

    @NotNull
    public final List<String> listDatabases() {
        Transaction transaction2;
        Transaction $this$listDatabases_u24lambda_u2438 = transaction2 = TransactionManager.Companion.current();
        boolean bl = false;
        List<String> list = (List<String>)Transaction.exec$default($this$listDatabases_u24lambda_u2438, DatabaseDialectKt.getCurrentDialect().listDatabases(), null, null, listDatabases.1.1.INSTANCE, 6, null);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void dropDatabase(@NotNull String[] databases, boolean inBatch) {
        Intrinsics.checkNotNullParameter(databases, "databases");
        Transaction transaction2 = TransactionManager.Companion.current();
        try {
            void $this$flatMapTo$iv$iv;
            Transaction $this$dropDatabase_u24lambda_u2440 = transaction2;
            boolean bl = false;
            String[] $this$flatMap$iv = databases;
            boolean $i$f$flatMap = false;
            String[] stringArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl2 = false;
                Iterable list$iv$iv = CollectionsKt.listOf(DatabaseDialectKt.getCurrentDialect().dropDatabase((String)it));
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List createStatements = (List)destination$iv$iv;
            INSTANCE.execStatements($this$dropDatabase_u24lambda_u2440, inBatch, createStatements);
        }
        catch (ExposedSQLException exception) {
            if (DatabaseDialectKt.getCurrentDialect().getRequiresAutoCommitOnCreateDrop() && !transaction2.getConnection().getAutoCommit()) {
                throw new IllegalStateException(DatabaseDialectKt.getCurrentDialect().getName() + " requires autoCommit to be enabled for DROP DATABASE", exception);
            }
            throw exception;
        }
    }

    public static /* synthetic */ void dropDatabase$default(SchemaUtils schemaUtils, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.dropDatabase(stringArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createMissingTablesAndColumns(@NotNull Table[] tables, boolean inBatch, boolean withLogs) {
        boolean bl;
        List<String> list;
        long start$iv;
        boolean bl2;
        List<String> list2;
        long start$iv2;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Transaction $this$createMissingTablesAndColumns_u24lambda_u2447 = TransactionManager.Companion.current();
        boolean bl3 = false;
        $this$createMissingTablesAndColumns_u24lambda_u2447.getDb().getDialect().resetCaches();
        SchemaUtils schemaUtils = INSTANCE;
        Object message$iv = "Preparing create tables statements";
        boolean $i$f$logTimeSpent = false;
        if (withLogs) {
            start$iv2 = System.currentTimeMillis();
            boolean bl4 = false;
            List<String> answer$iv = INSTANCE.createStatements(Arrays.copyOf(tables, tables.length));
            SQLLogKt.getExposedLogger().info((String)message$iv + " took " + (System.currentTimeMillis() - start$iv2) + "ms");
            list2 = answer$iv;
        } else {
            boolean bl5 = false;
            list2 = INSTANCE.createStatements(Arrays.copyOf(tables, tables.length));
        }
        List<String> createStatements = list2;
        SchemaUtils this_$iv = INSTANCE;
        message$iv = "Executing create tables statements";
        $i$f$logTimeSpent = false;
        if (withLogs) {
            start$iv2 = System.currentTimeMillis();
            bl2 = false;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2447, inBatch, createStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2447.commit();
            Unit answer$iv = Unit.INSTANCE;
            SQLLogKt.getExposedLogger().info((String)message$iv + " took " + (System.currentTimeMillis() - start$iv2) + "ms");
        } else {
            bl2 = false;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2447, inBatch, createStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2447.commit();
        }
        message$iv = INSTANCE;
        Object message$iv2 = "Preparing alter table statements";
        boolean $i$f$logTimeSpent2 = false;
        if (withLogs) {
            start$iv = System.currentTimeMillis();
            boolean bl6 = false;
            List<String> answer$iv = INSTANCE.addMissingColumnsStatements(Arrays.copyOf(tables, tables.length), withLogs);
            SQLLogKt.getExposedLogger().info((String)message$iv2 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list = answer$iv;
        } else {
            boolean bl7 = false;
            list = INSTANCE.addMissingColumnsStatements(Arrays.copyOf(tables, tables.length), withLogs);
        }
        List<String> alterStatements = list;
        SchemaUtils this_$iv2 = INSTANCE;
        message$iv2 = "Executing alter table statements";
        $i$f$logTimeSpent2 = false;
        if (withLogs) {
            start$iv = System.currentTimeMillis();
            bl = false;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2447, inBatch, alterStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2447.commit();
            Unit answer$iv = Unit.INSTANCE;
            SQLLogKt.getExposedLogger().info((String)message$iv2 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
        } else {
            bl = false;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2447, inBatch, alterStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2447.commit();
        }
        List executedStatements = CollectionsKt.plus((Collection)createStatements, (Iterable)alterStatements);
        message$iv2 = INSTANCE;
        String message$iv3 = "Checking mapping consistence";
        boolean $i$f$logTimeSpent3 = false;
        if (withLogs) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            long start$iv3 = System.currentTimeMillis();
            boolean bl8 = false;
            Iterable iterable = INSTANCE.checkMappingConsistence(Arrays.copyOf(tables, tables.length), withLogs);
            boolean $i$f$filter = false;
            void var23_33 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl9 = false;
                if (!(!executedStatements.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List modifyTablesStatements = (List)destination$iv$iv;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2447, inBatch, modifyTablesStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2447.commit();
            Unit answer$iv = Unit.INSTANCE;
            SQLLogKt.getExposedLogger().info(message$iv3 + " took " + (System.currentTimeMillis() - start$iv3) + "ms");
        } else {
            boolean bl10 = false;
            Iterable $this$filter$iv = INSTANCE.checkMappingConsistence(Arrays.copyOf(tables, tables.length), withLogs);
            boolean $i$f$filter = false;
            Iterable $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl11 = false;
                if (!(!executedStatements.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List modifyTablesStatements = (List)destination$iv$iv;
            INSTANCE.execStatements($this$createMissingTablesAndColumns_u24lambda_u2447, inBatch, modifyTablesStatements);
            $this$createMissingTablesAndColumns_u24lambda_u2447.commit();
        }
        $this$createMissingTablesAndColumns_u24lambda_u2447.getDb().getDialect().resetCaches();
    }

    public static /* synthetic */ void createMissingTablesAndColumns$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        schemaUtils.createMissingTablesAndColumns(tableArray, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> statementsRequiredToActualizeScheme(@NotNull Table[] tables, boolean withLogs) {
        List list;
        Collection destination$iv$iv;
        Collection thisCollection$iv;
        List<String> list2;
        Table[] tableArray;
        Collection thisCollection$iv2;
        List<String> list3;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Table[] $this$partition$iv = tables;
        boolean $i$f$partition = false;
        ArrayList<Table> first$iv = new ArrayList<Table>();
        Object second$iv = new ArrayList<Table>();
        int n = $this$partition$iv.length;
        for (int i = 0; i < n; ++i) {
            Table element$iv;
            Table it = element$iv = $this$partition$iv[i];
            boolean bl = false;
            if (!QueriesKt.exists(it)) {
                first$iv.add(element$iv);
                continue;
            }
            ((ArrayList)second$iv).add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List tablesToCreate = pair.component1();
        List tablesToAlter = pair.component2();
        second$iv = this;
        Object message$iv = "Preparing create tables statements";
        boolean $i$f$logTimeSpent = false;
        if (withLogs) {
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToCreate;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv3 = $this$toTypedArray$iv;
            Table[] tableArray2 = thisCollection$iv3.toArray(new Table[0]);
            List<String> answer$iv = INSTANCE.createStatements(Arrays.copyOf(tableArray2, tableArray2.length));
            SQLLogKt.getExposedLogger().info((String)message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list3 = answer$iv;
        } else {
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToCreate;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv2 = $this$toTypedArray$iv;
            tableArray = thisCollection$iv2.toArray(new Table[0]);
            list3 = INSTANCE.createStatements(Arrays.copyOf(tableArray, tableArray.length));
        }
        List<String> createStatements = list3;
        message$iv = this;
        String message$iv2 = "Preparing alter table statements";
        boolean $i$f$logTimeSpent22 = false;
        if (withLogs) {
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv2 = $this$toTypedArray$iv;
            tableArray = thisCollection$iv2.toArray(new Table[0]);
            List<String> answer$iv = INSTANCE.addMissingColumnsStatements(Arrays.copyOf(tableArray, tableArray.length), withLogs);
            SQLLogKt.getExposedLogger().info(message$iv2 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list2 = answer$iv;
        } else {
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv4 = $this$toTypedArray$iv;
            Table[] tableArray3 = thisCollection$iv4.toArray(new Table[0]);
            list2 = INSTANCE.addMissingColumnsStatements(Arrays.copyOf(tableArray3, tableArray3.length), withLogs);
        }
        List<String> alterStatements = list2;
        List executedStatements = CollectionsKt.plus((Collection)createStatements, (Iterable)alterStatements);
        SchemaUtils $i$f$logTimeSpent22 = this;
        String message$iv3 = "Checking mapping consistence";
        boolean $i$f$logTimeSpent3 = false;
        if (withLogs) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray22 = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Object object = thisCollection$iv.toArray(new Table[0]);
            object = INSTANCE.checkMappingConsistence(Arrays.copyOf(object, ((Table[])object).length), withLogs);
            boolean $i$f$filter = false;
            void $i$f$toTypedArray22 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (!(!executedStatements.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List answer$iv = (List)destination$iv$iv;
            SQLLogKt.getExposedLogger().info(message$iv3 + " took " + (System.currentTimeMillis() - start$iv) + "ms");
            list = answer$iv;
        } else {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = tablesToAlter;
            boolean $i$f$toTypedArray32 = false;
            thisCollection$iv = $this$toTypedArray$iv;
            Object $this$filter$iv = thisCollection$iv.toArray(new Table[0]);
            $this$filter$iv = INSTANCE.checkMappingConsistence(Arrays.copyOf($this$filter$iv, ((Table[])$this$filter$iv).length), withLogs);
            boolean $i$f$filter = false;
            Object $i$f$toTypedArray32 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                if (!(!executedStatements.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List modifyTablesStatements = list;
        return CollectionsKt.plus((Collection)executedStatements, (Iterable)modifyTablesStatements);
    }

    public static /* synthetic */ List statementsRequiredToActualizeScheme$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return schemaUtils.statementsRequiredToActualizeScheme(tableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> checkMappingConsistence(@NotNull Table[] tables, boolean withLogs) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        if (withLogs) {
            this.checkExcessiveIndices(Arrays.copyOf(tables, tables.length));
        }
        Iterable $this$flatMap$iv = this.checkMissingIndices(Arrays.copyOf(tables, tables.length), withLogs);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Index it = (Index)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.createStatement();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List checkMappingConsistence$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return schemaUtils.checkMappingConsistence(tableArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void checkExcessiveIndices(Table ... tables) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        void $this$flatMapTo$iv$iv;
        DdlAware it;
        Iterator<Object> value;
        Map.Entry element$iv;
        Iterator $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> $this$filter$iv2 = DatabaseDialectKt.getCurrentDialect().columnConstraints(Arrays.copyOf(tables, tables.length));
        boolean $i$f$filter = false;
        Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> map2 = $this$filter$iv2;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo22 = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((List)entry.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map excessiveConstraints = destination$iv$iv;
        if (!excessiveConstraints.isEmpty()) {
            SQLLogKt.getExposedLogger().warn("List of excessive foreign key constraints:");
            Map $this$forEach$iv2 = excessiveConstraints;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv2.entrySet().iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Map.Entry $i$f$filterTo22 = element$iv = $this$filterTo$iv$iv2.next();
                boolean bl = false;
                Pair pair = (Pair)$i$f$filterTo22.getKey();
                List list = (List)$i$f$filterTo22.getValue();
                ForeignKeyConstraint constraint = (ForeignKeyConstraint)CollectionsKt.first(list);
                String fkPartToLog2 = CollectionsKt.joinToString$default(list, ", ", null, null, 0, null, checkExcessiveIndices.1.fkPartToLog.1.INSTANCE, 30, null);
                SQLLogKt.getExposedLogger().warn("\t\t\t'" + pair.getFirst() + "'.'" + pair.getSecond() + "' -> '" + constraint.getFromTableName() + "':\t" + (String)fkPartToLog2);
            }
            SQLLogKt.getExposedLogger().info("SQL Queries to remove excessive keys:");
            Map $this$forEach$iv = excessiveConstraints;
            $i$f$forEach = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv.entrySet().iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Map.Entry $i$f$filterTo22 = element$iv = $this$filterTo$iv$iv2.next();
                boolean bl = false;
                value = (List)$i$f$filterTo22.getValue();
                Iterable iterable = CollectionsKt.take((Iterable)((Object)value), value.size() - 1);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : iterable) {
                    it = (ForeignKeyConstraint)element$iv2;
                    boolean bl2 = false;
                    SQLLogKt.getExposedLogger().info("\t\t\t" + ((ForeignKeyConstraint)it).dropStatement() + ';');
                }
            }
        }
        Object $this$flatMap$iv = DatabaseDialectKt.getCurrentDialect().existingIndices(Arrays.copyOf(tables, tables.length));
        boolean $i$f$flatMap = false;
        element$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        value = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (value.hasNext()) {
            Map.Entry entry;
            Map.Entry it3 = entry = value.next();
            boolean bl = false;
            Iterable list$iv$iv = (List)it3.getValue();
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            Index it4 = (Index)t;
            boolean bl = false;
            Triple<Table, Boolean, String> key$iv$iv = new Triple<Table, Boolean, String>(it4.getTable(), it4.getUnique(), CollectionsKt.joinToString$default(it4.getColumns(), null, null, null, 0, null, checkExcessiveIndices.excessiveIndices.2.1.INSTANCE, 31, null));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        $this$groupBy$iv = destination$iv$iv3;
        boolean $i$f$filter2 = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo322 = false;
        value = $this$filterTo$iv$iv.entrySet().iterator();
        while (value.hasNext()) {
            Map.Entry entry;
            Map.Entry it5 = entry = (Map.Entry)value.next();
            boolean bl = false;
            if (!(((List)it5.getValue()).size() > 1)) continue;
            destination$iv$iv3.put(entry.getKey(), entry.getValue());
        }
        Map excessiveIndices2 = destination$iv$iv3;
        if (!excessiveIndices2.isEmpty()) {
            SQLLogKt.getExposedLogger().warn("List of excessive indices:");
            Map $this$forEach$iv3 = excessiveIndices2;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv3.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry $i$f$filterTo322 = element$iv3 = iterator3.next();
                boolean bl = false;
                Triple triple = (Triple)$i$f$filterTo322.getKey();
                List indices = (List)$i$f$filterTo322.getValue();
                String indexNames2 = CollectionsKt.joinToString$default(indices, ", ", null, null, 0, null, checkExcessiveIndices.3.indexNames.1.INSTANCE, 30, null);
                SQLLogKt.getExposedLogger().warn("\t\t\t'" + ((Table)triple.getFirst()).getTableName() + "'.'" + (String)triple.getThird() + "' -> " + indexNames2);
            }
            SQLLogKt.getExposedLogger().info("SQL Queries to remove excessive indices:");
            Map $this$forEach$iv = excessiveIndices2;
            $i$f$forEach = false;
            iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry it6 = element$iv2 = iterator3.next();
                boolean bl = false;
                Iterable iterable = CollectionsKt.take((Iterable)it6.getValue(), ((List)it6.getValue()).size() - 1);
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : iterable) {
                    it = (Index)element$iv3;
                    boolean bl4 = false;
                    SQLLogKt.getExposedLogger().info("\t\t\t" + ((Index)it).dropStatement() + ';');
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Index> checkMissingIndices(Table[] tables, boolean withLogs) {
        Object object;
        boolean isMysql = DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect;
        boolean isSQLite = DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect;
        Set<Pair<Table, LinkedHashSet<Column<?>>>> fKeyConstraints = DatabaseDialectKt.getCurrentDialect().columnConstraints(Arrays.copyOf(tables, tables.length)).keySet();
        Map<Table, List<Index>> existingIndices2 = DatabaseDialectKt.getCurrentDialect().existingIndices(Arrays.copyOf(tables, tables.length));
        HashSet missingIndices = new HashSet();
        HashMap notMappedIndices = new HashMap();
        HashSet<Index> nameDiffers = new HashSet<Index>();
        for (Table table : tables) {
            Object object2;
            void $this$getOrPut$iv;
            List<Index> list = existingIndices2.get(table);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List<Index> existingTableIndices = SchemaUtils.checkMissingIndices$filterInternalIndices(SchemaUtils.checkMissingIndices$filterFKeys(list, isMysql, fKeyConstraints), isSQLite);
            List<Index> mappedIndices = SchemaUtils.checkMissingIndices$filterInternalIndices(SchemaUtils.checkMissingIndices$filterFKeys(table.getIndices(), isMysql, fKeyConstraints), isSQLite);
            for (Index index : existingTableIndices) {
                Index mappedIndex;
                Object v1;
                block8: {
                    Iterable $this$firstOrNull$iv = mappedIndices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Index it = (Index)element$iv;
                        boolean bl = false;
                        if (!it.onlyNameDiffer(index)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                if ((Index)v1 == null) continue;
                if (withLogs) {
                    SQLLogKt.getExposedLogger().info("Index on table '" + table.getTableName() + "' differs only in name: in db " + index.getIndexName() + " -> in mapping " + mappedIndex.getIndexName());
                }
                nameDiffers.add(index);
                nameDiffers.add(mappedIndex);
            }
            object = notMappedIndices;
            String key$iv = table.nameInDatabaseCase();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Set answer$iv = new HashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((Set)object2).addAll(CollectionsKt.subtract((Iterable)existingTableIndices, (Iterable)mappedIndices));
            missingIndices.addAll(CollectionsKt.subtract((Iterable)mappedIndices, (Iterable)existingTableIndices));
        }
        Set toCreate = CollectionsKt.subtract(missingIndices, (Iterable)nameDiffers);
        SchemaUtils.checkMissingIndices$log(toCreate, withLogs, "Indices missed from database (will be created):");
        Map $this$forEach$iv = notMappedIndices;
        boolean $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            object = element$iv;
            boolean bl = false;
            String name2 = (String)object.getKey();
            Set indexes = (Set)object.getValue();
            SchemaUtils.checkMissingIndices$log(CollectionsKt.subtract(indexes, (Iterable)nameDiffers), withLogs, "Indices exist in database and not mapped in code on class '" + name2 + "':");
        }
        return CollectionsKt.toList(toCreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void withDataBaseLock(@NotNull Transaction $this$withDataBaseLock, @NotNull Function0<? extends T> body) {
        Intrinsics.checkNotNullParameter($this$withDataBaseLock, "<this>");
        Intrinsics.checkNotNullParameter(body, "body");
        Table buzyTable2 = new Table(){
            @NotNull
            private final Column<Boolean> busy;
            {
                this.busy = Table.uniqueIndex$default((Table)this, this.bool("busy"), null, 1, null);
            }

            @NotNull
            public final Column<Boolean> getBusy() {
                return this.busy;
            }
        };
        withDataBaseLock.buzyTable.1[] nullArray = new withDataBaseLock.buzyTable.1[]{buzyTable2};
        SchemaUtils.create$default(this, nullArray, false, 2, null);
        boolean isBusy = CollectionsKt.any(SizedIterable.DefaultImpls.forUpdate$default(QueriesKt.selectAll(buzyTable2), null, 1, null));
        if (!isBusy) {
            QueriesKt.insert((Table)buzyTable2, new Function2<withDataBaseLock.buzyTable.1<T>, InsertStatement<Number>, Unit>(buzyTable2){
                final /* synthetic */ withDataBaseLock.buzyTable.1<T> $buzyTable;
                {
                    this.$buzyTable = $buzyTable;
                    super(2);
                }

                public final void invoke(@NotNull withDataBaseLock.buzyTable.1<T> $this$insert, @NotNull InsertStatement<Number> it) {
                    Intrinsics.checkNotNullParameter($this$insert, "$this$insert");
                    Intrinsics.checkNotNullParameter(it, "it");
                    it.set(this.$buzyTable.getBusy(), true);
                }
            });
            try {
                body.invoke();
            }
            finally {
                QueriesKt.deleteAll(buzyTable2);
                $this$withDataBaseLock.getConnection().commit();
            }
        }
    }

    @NotNull
    public final List<String> listTables() {
        return DatabaseDialectKt.getCurrentDialect().allTablesNames();
    }

    /*
     * WARNING - void declaration
     */
    public final void drop(@NotNull Table[] tables, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Table it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        if (tables.length == 0) {
            return;
        }
        Transaction $this$drop_u24lambda_u2472 = TransactionManager.Companion.current();
        boolean bl = false;
        Iterable $this$filter$iv = CollectionsKt.reversed((Iterable)INSTANCE.sortTablesByReferences((Iterable<? extends Table>)ArraysKt.toList(tables)));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Table)element$iv$iv;
            boolean bl2 = false;
            if (!ArraysKt.contains(tables, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tablesForDeletion = (List)destination$iv$iv;
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsIfNotExists()) {
            $this$filter$iv = tablesForDeletion;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Table)element$iv$iv;
                boolean bl3 = false;
                if (!QueriesKt.exists(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tablesForDeletion = (List)destination$iv$iv;
        }
        Iterable $this$flatMap$iv = tablesForDeletion;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Table it2 = (Table)element$iv$iv;
            boolean bl4 = false;
            Iterable list$iv$iv = it2.dropStatement();
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List dropStatements = (List)destination$iv$iv2;
        INSTANCE.execStatements($this$drop_u24lambda_u2472, inBatch, dropStatements);
        DatabaseDialectKt.getCurrentDialect().resetCaches();
    }

    public static /* synthetic */ void drop$default(SchemaUtils schemaUtils, Table[] tableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.drop(tableArray, bl);
    }

    public final void setSchema(@NotNull Schema schema, boolean inBatch) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        Transaction $this$setSchema_u24lambda_u2473 = TransactionManager.Companion.current();
        boolean bl = false;
        List<String> createStatements = schema.setSchemaStatement();
        INSTANCE.execStatements($this$setSchema_u24lambda_u2473, inBatch, createStatements);
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        if (databaseDialect instanceof MysqlDialect) {
            $this$setSchema_u24lambda_u2473.getConnection().setCatalog(schema.getIdentifier());
        } else if (databaseDialect instanceof H2Dialect) {
            $this$setSchema_u24lambda_u2473.getConnection().setSchema(schema.getIdentifier());
        }
        DatabaseDialectKt.getCurrentDialect().resetCaches();
        $this$setSchema_u24lambda_u2473.getConnection().metadata(setSchema.1.1.INSTANCE);
    }

    public static /* synthetic */ void setSchema$default(SchemaUtils schemaUtils, Schema schema, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.setSchema(schema, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void createSchema(@NotNull Schema[] schemas2, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(schemas2, "schemas");
        if (schemas2.length == 0) {
            return;
        }
        Transaction $this$createSchema_u24lambda_u2476 = TransactionManager.Companion.current();
        boolean bl = false;
        Iterable $this$filterNot$iv = ArraysKt.distinct(schemas2);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Schema it = (Schema)element$iv$iv;
            boolean bl2 = false;
            if (it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toCreate = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = toCreate;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Schema it = (Schema)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.createStatement();
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List createStatements = (List)destination$iv$iv2;
        INSTANCE.execStatements($this$createSchema_u24lambda_u2476, inBatch, createStatements);
        $this$createSchema_u24lambda_u2476.commit();
        DatabaseDialectKt.getCurrentDialect().resetSchemaCaches();
    }

    public static /* synthetic */ void createSchema$default(SchemaUtils schemaUtils, Schema[] schemaArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        schemaUtils.createSchema(schemaArray, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void dropSchema(@NotNull Schema[] schemas2, boolean cascade, boolean inBatch) {
        void $this$flatMapTo$iv$iv;
        Iterable destination$iv$iv;
        List list;
        Intrinsics.checkNotNullParameter(schemas2, "schemas");
        if (schemas2.length == 0) {
            return;
        }
        Transaction $this$dropSchema_u24lambda_u2479 = TransactionManager.Companion.current();
        boolean bl = false;
        if (DatabaseDialectKt.getCurrentDialect().getSupportsIfNotExists()) {
            list = ArraysKt.distinct(schemas2);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ArraysKt.distinct(schemas2);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Schema it = (Schema)element$iv$iv;
                boolean bl2 = false;
                if (!it.exists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List schemasForDeletion = list;
        Iterable $this$flatMap$iv = schemasForDeletion;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Schema it = (Schema)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.dropStatement(cascade);
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        List dropStatements = (List)destination$iv$iv2;
        INSTANCE.execStatements($this$dropSchema_u24lambda_u2479, inBatch, dropStatements);
        DatabaseDialectKt.getCurrentDialect().resetSchemaCaches();
    }

    public static /* synthetic */ void dropSchema$default(SchemaUtils schemaUtils, Schema[] schemaArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        schemaUtils.dropSchema(schemaArray, bl, bl2);
    }

    private static final void checkMissingIndices$log(Collection<Index> $this$checkMissingIndices_u24log, boolean $withLogs, String mainMessage) {
        if ($withLogs && !$this$checkMissingIndices_u24log.isEmpty()) {
            String string = mainMessage + "\n\t\t";
            SQLLogKt.getExposedLogger().warn(CollectionsKt.joinToString$default($this$checkMissingIndices_u24log, "\n\t\t", string, null, 0, null, null, 60, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Index> checkMissingIndices$filterFKeys(List<Index> $this$checkMissingIndices_u24filterFKeys, boolean isMysql, Set<? extends Pair<? extends Table, ? extends LinkedHashSet<Column<?>>>> fKeyConstraints) {
        List list;
        if (isMysql) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = $this$checkMissingIndices_u24filterFKeys;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Index it = (Index)element$iv$iv;
                boolean bl = false;
                if (fKeyConstraints.contains(TuplesKt.to(it.getTable(), new LinkedHashSet(it.getColumns())))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = $this$checkMissingIndices_u24filterFKeys;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Index> checkMissingIndices$filterInternalIndices(List<Index> $this$checkMissingIndices_u24filterInternalIndices, boolean isSQLite) {
        List list;
        if (isSQLite) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$checkMissingIndices_u24filterInternalIndices;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Index it = (Index)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.startsWith$default(it.getIndexName(), "sqlite_", false, 2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = $this$checkMissingIndices_u24filterInternalIndices;
        }
        return list;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000ej\b\u0012\u0004\u0012\u00020\u0004`\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\bR#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/sql/SchemaUtils$TableDepthGraph;", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "(Ljava/lang/Iterable;)V", "graph", "", "", "getGraph", "()Ljava/util/Map;", "getTables", "()Ljava/lang/Iterable;", "fetchAllTables", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "hasCycle", "", "sorted", "exposed-core"})
    @SourceDebugExtension(value={"SMAP\nSchemaUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaUtils.kt\norg/jetbrains/exposed/sql/SchemaUtils$TableDepthGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,709:1\n1271#2,2:710\n1285#2,2:712\n1549#2:714\n1620#2,3:715\n1288#2:718\n1855#2,2:719\n1855#2,2:721\n1747#2,3:723\n1549#2:726\n1620#2,3:727\n1855#2,2:730\n1855#2,2:732\n1747#2,3:734\n*S KotlinDebug\n*F\n+ 1 SchemaUtils.kt\norg/jetbrains/exposed/sql/SchemaUtils$TableDepthGraph\n*L\n26#1:710,2\n26#1:712,2\n27#1:714\n27#1:715,3\n26#1:718\n40#1:719,2\n62#1:721,2\n85#1:723,3\n37#1:726\n37#1:727,3\n37#1:730,2\n53#1:732,2\n78#1:734,3\n*E\n"})
    private static final class TableDepthGraph {
        @NotNull
        private final Iterable<Table> tables;
        @NotNull
        private final Map<Table, List<Table>> graph;

        /*
         * WARNING - void declaration
         */
        public TableDepthGraph(@NotNull Iterable<? extends Table> tables) {
            Map map2;
            void tables2;
            Intrinsics.checkNotNullParameter(tables, "tables");
            this.tables = tables;
            HashSet<Table> hashSet = this.fetchAllTables();
            TableDepthGraph tableDepthGraph = this;
            boolean bl = false;
            if (tables2.isEmpty()) {
                map2 = MapsKt.emptyMap();
            } else {
                Iterable $this$associateWith$iv = (Iterable)tables2;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    void $this$mapTo$iv$iv;
                    void t;
                    Table table = (Table)element$iv$iv;
                    Object t2 = element$iv$iv;
                    Map map3 = result$iv;
                    boolean bl2 = false;
                    Iterable $this$map$iv = t.getForeignKeys();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(it.getTargetTable());
                    }
                    List list = (List)destination$iv$iv;
                    map3.put(t2, list);
                }
                map2 = result$iv;
            }
            tableDepthGraph.graph = map2;
        }

        @NotNull
        public final Iterable<Table> getTables() {
            return this.tables;
        }

        @NotNull
        public final Map<Table, List<Table>> getGraph() {
            return this.graph;
        }

        private final HashSet<Table> fetchAllTables() {
            HashSet<Table> result2 = new HashSet<Table>();
            Iterable<Table> $this$forEach$iv = this.tables;
            boolean $i$f$forEach = false;
            Iterator<Table> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Table element$iv;
                Table p0 = element$iv = iterator2.next();
                boolean bl = false;
                TableDepthGraph.fetchAllTables$parseTable(result2, p0);
            }
            return result2;
        }

        @NotNull
        public final List<Table> sorted() {
            if (!this.tables.iterator().hasNext()) {
                return CollectionsKt.emptyList();
            }
            Set visited = new LinkedHashSet();
            ArrayList<Table> result2 = new ArrayList<Table>();
            Iterable<Table> $this$forEach$iv = this.tables;
            boolean $i$f$forEach = false;
            Iterator<Table> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Table element$iv;
                Table p0 = element$iv = iterator2.next();
                boolean bl = false;
                TableDepthGraph.sorted$traverse(visited, this, result2, p0);
            }
            return result2;
        }

        public final boolean hasCycle() {
            boolean bl;
            block4: {
                if (!this.tables.iterator().hasNext()) {
                    return false;
                }
                Set visited = new LinkedHashSet();
                Set recursion = new LinkedHashSet();
                List<Table> sortedTables = this.sorted();
                Iterable $this$any$iv = sortedTables;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Table it = (Table)element$iv;
                        boolean bl2 = false;
                        if (!TableDepthGraph.hasCycle$traverse$8(recursion, visited, this, it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private static final void fetchAllTables$parseTable(HashSet<Table> result2, Table table) {
            if (result2.add(table)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = table.getForeignKeys();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getTargetTable());
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Table p0 = (Table)element$iv;
                    boolean bl = false;
                    TableDepthGraph.fetchAllTables$parseTable(result2, p0);
                }
            }
        }

        private static final void sorted$traverse(Set<Table> visited, TableDepthGraph this$0, ArrayList<Table> result2, Table table) {
            if (!visited.contains(table)) {
                ((Collection)visited).add(table);
                Iterable $this$forEach$iv = MapsKt.getValue(this$0.graph, table);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Table t = (Table)element$iv;
                    boolean bl = false;
                    if (visited.contains(t)) continue;
                    TableDepthGraph.sorted$traverse(visited, this$0, result2, t);
                }
                ((Collection)result2).add(table);
            }
        }

        private static final boolean hasCycle$traverse$8(Set<Table> recursion, Set<Table> visited, TableDepthGraph this$0, Table table) {
            boolean bl;
            boolean bl2;
            block7: {
                if (recursion.contains(table)) {
                    return true;
                }
                if (visited.contains(table)) {
                    return false;
                }
                ((Collection)recursion).add(table);
                ((Collection)visited).add(table);
                List<Table> list = this$0.graph.get(table);
                Intrinsics.checkNotNull(list);
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Table it = (Table)element$iv;
                        boolean bl3 = false;
                        if (!TableDepthGraph.hasCycle$traverse$8(recursion, visited, this$0, it)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                bl = true;
            } else {
                ((Collection)recursion).remove(table);
                bl = false;
            }
            return bl;
        }
    }
}

