/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BaseBatchInsertStatement;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\"\u0006\u0012\u0002\b\u00030\u0006\u0012\"\u0010\u0007\u001a\u001e\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u0018\u00010\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016R\u001f\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR-\u0010\u0007\u001a\u001e\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/sql/statements/BatchUpsertStatement;", "Lorg/jetbrains/exposed/sql/statements/BaseBatchInsertStatement;", "table", "Lorg/jetbrains/exposed/sql/Table;", "keys", "", "Lorg/jetbrains/exposed/sql/Column;", "onUpdate", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Expression;", "shouldReturnGeneratedValues", "", "(Lorg/jetbrains/exposed/sql/Table;[Lorg/jetbrains/exposed/sql/Column;Ljava/util/List;Z)V", "getKeys", "()[Lorg/jetbrains/exposed/sql/Column;", "[Lorg/jetbrains/exposed/sql/Column;", "getOnUpdate", "()Ljava/util/List;", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "prepared", "exposed-core"})
public class BatchUpsertStatement
extends BaseBatchInsertStatement {
    @NotNull
    private final Column<?>[] keys;
    @Nullable
    private final List<Pair<Column<?>, Expression<?>>> onUpdate;

    public BatchUpsertStatement(@NotNull Table table, @NotNull Column<?>[] keys2, @Nullable List<? extends Pair<? extends Column<?>, ? extends Expression<?>>> onUpdate, boolean shouldReturnGeneratedValues) {
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(keys2, "keys");
        super(table, false, shouldReturnGeneratedValues);
        this.keys = keys2;
        this.onUpdate = onUpdate;
    }

    public /* synthetic */ BatchUpsertStatement(Table table, Column[] columnArray, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(table, columnArray, list, bl);
    }

    @NotNull
    public final Column<?>[] getKeys() {
        return this.keys;
    }

    @Nullable
    public final List<Pair<Column<?>, Expression<?>>> getOnUpdate() {
        return this.onUpdate;
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction2, boolean prepared2) {
        FunctionProvider functionProvider2;
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        DatabaseDialect dialect2 = transaction2.getDb().getDialect();
        if (dialect2 instanceof H2Dialect) {
            H2Dialect.H2CompatibilityMode h2CompatibilityMode = ((H2Dialect)dialect2).getH2Mode();
            switch (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) {
                case 1: 
                case 2: {
                    functionProvider2 = new MysqlFunctionProvider();
                    break;
                }
                default: {
                    functionProvider2 = H2FunctionProvider.INSTANCE;
                    break;
                }
            }
        } else {
            functionProvider2 = dialect2.getFunctionProvider();
        }
        FunctionProvider functionProvider3 = functionProvider2;
        Table table = this.getTable();
        List<List<Pair<Column<?>, Object>>> list = this.getArguments();
        Intrinsics.checkNotNull(list);
        Column<?>[] columnArray = this.keys;
        return functionProvider3.upsert(table, CollectionsKt.first(list), this.onUpdate, null, transaction2, Arrays.copyOf(columnArray, columnArray.length));
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2CompatibilityMode.values().length];
            try {
                nArray[H2Dialect.H2CompatibilityMode.MariaDB.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.MySQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

