/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u0010\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00120\u00110\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u001b\u0010\u001a\u001a\u0004\u0018\u00010\u0002*\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u001cR\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\rR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/statements/InsertSelectStatement;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "selectQuery", "Lorg/jetbrains/exposed/sql/AbstractQuery;", "isIgnore", "", "(Ljava/util/List;Lorg/jetbrains/exposed/sql/AbstractQuery;Z)V", "getColumns", "()Ljava/util/List;", "()Z", "getSelectQuery", "()Lorg/jetbrains/exposed/sql/AbstractQuery;", "arguments", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "prepared", "executeInternal", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Integer;", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nInsertSelectStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertSelectStatement.kt\norg/jetbrains/exposed/sql/statements/InsertSelectStatement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,26:1\n1655#2,8:27\n*S KotlinDebug\n*F\n+ 1 InsertSelectStatement.kt\norg/jetbrains/exposed/sql/statements/InsertSelectStatement\n*L\n14#1:27,8\n*E\n"})
public class InsertSelectStatement
extends Statement<Integer> {
    @NotNull
    private final List<Column<?>> columns;
    @NotNull
    private final AbstractQuery<?> selectQuery;
    private final boolean isIgnore;

    public InsertSelectStatement(@NotNull List<? extends Column<?>> columns2, @NotNull AbstractQuery<?> selectQuery, boolean isIgnore) {
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(selectQuery, "selectQuery");
        super(StatementType.INSERT, CollectionsKt.listOf(CollectionsKt.first(columns2).getTable()));
        this.columns = columns2;
        this.selectQuery = selectQuery;
        this.isIgnore = isIgnore;
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("Can't insert without provided columns".toString());
        }
        Iterable $this$distinctBy$iv = this.columns;
        boolean $i$f$distinctBy = false;
        HashSet<Table> set$iv = new HashSet<Table>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Column it = (Column)e$iv;
            boolean bl = false;
            Table key$iv = it.getTable();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List tables = list$iv;
        if (((Collection)tables).size() > 1) {
            throw new IllegalStateException(("Can't insert to different tables " + CollectionsKt.joinToString$default(tables, null, null, null, 0, null, 1.INSTANCE, 31, null) + " from single select").toString());
        }
        if (this.columns.size() != this.selectQuery.getSet().getFields().size()) {
            throw new IllegalStateException("Columns count doesn't equal to query columns count".toString());
        }
    }

    public /* synthetic */ InsertSelectStatement(List list, AbstractQuery abstractQuery, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(list, abstractQuery, bl);
    }

    @NotNull
    public final List<Column<?>> getColumns() {
        return this.columns;
    }

    @NotNull
    public final AbstractQuery<?> getSelectQuery() {
        return this.selectQuery;
    }

    public final boolean isIgnore() {
        return this.isIgnore;
    }

    @Override
    @Nullable
    public Integer executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter($this$executeInternal, "<this>");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        return $this$executeInternal.executeUpdate();
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType, Object>>> arguments() {
        return this.selectQuery.arguments();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction2, boolean prepared2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        return transaction2.getDb().getDialect().getFunctionProvider().insert(this.isIgnore, CollectionsKt.single(this.getTargets()), this.columns, this.selectQuery.prepareSQL(transaction2, prepared2), transaction2);
    }
}

