/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.UpdateBuilder;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\u0018\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f0\u00190\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0019\u0010 \u001a\u00020\u0002*\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\"R,\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpdateStatement;", "Lorg/jetbrains/exposed/sql/statements/UpdateBuilder;", "", "targetsSet", "Lorg/jetbrains/exposed/sql/ColumnSet;", "limit", "where", "Lorg/jetbrains/exposed/sql/Op;", "", "(Lorg/jetbrains/exposed/sql/ColumnSet;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;)V", "firstDataSet", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Column;", "", "getFirstDataSet", "()Ljava/util/List;", "getLimit", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getTargetsSet", "()Lorg/jetbrains/exposed/sql/ColumnSet;", "getWhere", "()Lorg/jetbrains/exposed/sql/Op;", "arguments", "", "Lorg/jetbrains/exposed/sql/IColumnType;", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "prepared", "executeInternal", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Integer;", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nUpdateStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateStatement.kt\norg/jetbrains/exposed/sql/statements/UpdateStatement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,54:1\n1#2:55\n215#3,2:56\n215#3,2:58\n*S KotlinDebug\n*F\n+ 1 UpdateStatement.kt\norg/jetbrains/exposed/sql/statements/UpdateStatement\n*L\n42#1:56,2\n46#1:58,2\n*E\n"})
public class UpdateStatement
extends UpdateBuilder<Integer> {
    @NotNull
    private final ColumnSet targetsSet;
    @Nullable
    private final Integer limit;
    @Nullable
    private final Op<Boolean> where;

    public UpdateStatement(@NotNull ColumnSet targetsSet, @Nullable Integer limit, @Nullable Op<Boolean> where) {
        Intrinsics.checkNotNullParameter(targetsSet, "targetsSet");
        super(StatementType.UPDATE, TableKt.targetTables(targetsSet));
        this.targetsSet = targetsSet;
        this.limit = limit;
        this.where = where;
    }

    public /* synthetic */ UpdateStatement(ColumnSet columnSet, Integer n, Op op, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            op = null;
        }
        this(columnSet, n, op);
    }

    @NotNull
    public final ColumnSet getTargetsSet() {
        return this.targetsSet;
    }

    @Nullable
    public final Integer getLimit() {
        return this.limit;
    }

    @Nullable
    public final Op<Boolean> getWhere() {
        return this.where;
    }

    @NotNull
    public List<Pair<Column<?>, Object>> getFirstDataSet() {
        return MapsKt.toList(this.getValues());
    }

    @Override
    @NotNull
    public Integer executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter($this$executeInternal, "<this>");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        if (this.getValues().isEmpty()) {
            return 0;
        }
        return $this$executeInternal.executeUpdate();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction2, boolean prepared2) {
        String string;
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        if (!(!((Collection)this.getFirstDataSet()).isEmpty())) {
            boolean bl = false;
            String string2 = "Can't prepare UPDATE statement without fields to update";
            throw new IllegalArgumentException(string2.toString());
        }
        DatabaseDialect dialect2 = transaction2.getDb().getDialect();
        ColumnSet columnSet = this.targetsSet;
        if (columnSet instanceof Table) {
            string = dialect2.getFunctionProvider().update((Table)this.targetsSet, this.getFirstDataSet(), this.limit, this.where, transaction2);
        } else if (columnSet instanceof Join) {
            FunctionProvider functionProvider2;
            H2Dialect.H2CompatibilityMode h2CompatibilityMode = H2Kt.getH2Mode(dialect2);
            switch (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    functionProvider2 = H2FunctionProvider.INSTANCE;
                    break;
                }
                default: {
                    functionProvider2 = dialect2.getFunctionProvider();
                }
            }
            FunctionProvider functionProvider3 = functionProvider2;
            string = functionProvider3.update((Join)this.targetsSet, this.getFirstDataSet(), this.limit, this.where, transaction2);
        } else {
            ExceptionsKt.throwUnsupportedException(transaction2, "UPDATE with " + Reflection.getOrCreateKotlinClass(this.targetsSet.getClass()).getSimpleName() + " unsupported");
            throw new KotlinNothingValueException();
        }
        return string;
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType, Object>>> arguments() {
        QueryBuilder $this$arguments_u24lambda_u243;
        block4: {
            block3: {
                $this$arguments_u24lambda_u243 = new QueryBuilder(true);
                boolean bl = false;
                if (!(this.targetsSet instanceof Join) || !(DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect)) break block3;
                Op<Boolean> op = this.where;
                if (op != null) {
                    op.toQueryBuilder($this$arguments_u24lambda_u243);
                }
                Map<Column<?>, Object> $this$forEach$iv = this.getValues();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<Column<?>, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<Column<?>, Object> element$iv;
                    Map.Entry<Column<?>, Object> it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    $this$arguments_u24lambda_u243.registerArgument(it.getKey(), it.getValue());
                }
                break block4;
            }
            Map<Column<?>, Object> $this$forEach$iv = this.getValues();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Column<?>, Object>> iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry<Column<?>, Object> element$iv;
                Map.Entry<Column<?>, Object> it = element$iv = iterator3.next();
                boolean bl = false;
                $this$arguments_u24lambda_u243.registerArgument(it.getKey(), it.getValue());
            }
            Op<Boolean> op = this.where;
            if (op == null) break block4;
            op.toQueryBuilder($this$arguments_u24lambda_u243);
        }
        return !((Collection)$this$arguments_u24lambda_u243.getArgs()).isEmpty() ? CollectionsKt.listOf($this$arguments_u24lambda_u243.getArgs()) : CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2CompatibilityMode.values().length];
            try {
                nArray[H2Dialect.H2CompatibilityMode.PostgreSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.Oracle.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2CompatibilityMode.SQLServer.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

