/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.BinaryColumnType;
import org.jetbrains.exposed.sql.BlobColumnType;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\u0019\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\t2\u0006\u0010\b\u001a\u00020!H\u0096\u0002J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\t2\u0006\u0010&\u001a\u00020'H\u0016R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcPreparedStatementImpl;", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "statement", "Ljava/sql/PreparedStatement;", "wasGeneratedKeysRequested", "", "supportsGetGeneratedKeys", "(Ljava/sql/PreparedStatement;ZZ)V", "value", "", "fetchSize", "getFetchSize", "()Ljava/lang/Integer;", "setFetchSize", "(Ljava/lang/Integer;)V", "resultSet", "Ljava/sql/ResultSet;", "getResultSet", "()Ljava/sql/ResultSet;", "getStatement", "()Ljava/sql/PreparedStatement;", "getWasGeneratedKeysRequested", "()Z", "addBatch", "", "cancel", "closeIfPossible", "executeBatch", "", "executeQuery", "executeUpdate", "set", "index", "", "setInputStream", "inputStream", "Ljava/io/InputStream;", "setNull", "columnType", "Lorg/jetbrains/exposed/sql/IColumnType;", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcPreparedStatementImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcPreparedStatementImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcPreparedStatementImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,84:1\n1#2:85\n11095#3:86\n11430#3,3:87\n*S KotlinDebug\n*F\n+ 1 JdbcPreparedStatementImpl.kt\norg/jetbrains/exposed/sql/statements/jdbc/JdbcPreparedStatementImpl\n*L\n71#1:86\n71#1:87,3\n*E\n"})
public final class JdbcPreparedStatementImpl
implements PreparedStatementApi {
    @NotNull
    private final PreparedStatement statement;
    private final boolean wasGeneratedKeysRequested;
    private final boolean supportsGetGeneratedKeys;

    public JdbcPreparedStatementImpl(@NotNull PreparedStatement statement, boolean wasGeneratedKeysRequested, boolean supportsGetGeneratedKeys) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        this.statement = statement;
        this.wasGeneratedKeysRequested = wasGeneratedKeysRequested;
        this.supportsGetGeneratedKeys = supportsGetGeneratedKeys;
    }

    @NotNull
    public final PreparedStatement getStatement() {
        return this.statement;
    }

    public final boolean getWasGeneratedKeysRequested() {
        return this.wasGeneratedKeysRequested;
    }

    @Override
    @Nullable
    public ResultSet getResultSet() {
        return !this.wasGeneratedKeysRequested ? this.statement.getResultSet() : (this.supportsGetGeneratedKeys ? this.statement.getGeneratedKeys() : (DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? this.statement.getConnection().prepareStatement("select last_insert_rowid();").executeQuery() : this.statement.getResultSet()));
    }

    @Override
    @Nullable
    public Integer getFetchSize() {
        return this.statement.getFetchSize();
    }

    @Override
    public void setFetchSize(@Nullable Integer value) {
        block0: {
            Integer n = value;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.statement.setFetchSize(value);
        }
    }

    @Override
    public void addBatch() {
        this.statement.addBatch();
    }

    @Override
    @NotNull
    public ResultSet executeQuery() {
        ResultSet resultSet = this.statement.executeQuery();
        Intrinsics.checkNotNullExpressionValue(resultSet, "statement.executeQuery()");
        return resultSet;
    }

    @Override
    public int executeUpdate() {
        return this.statement.executeUpdate();
    }

    @Override
    public void set(int index, @NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.statement.setObject(index, value);
    }

    @Override
    public void setNull(int index, @NotNull IColumnType columnType) {
        Intrinsics.checkNotNullParameter(columnType, "columnType");
        if (columnType instanceof BinaryColumnType || columnType instanceof BlobColumnType) {
            this.statement.setNull(index, -4);
        } else {
            this.statement.setObject(index, null);
        }
    }

    @Override
    public void setInputStream(int index, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        this.statement.setBinaryStream(index, inputStream, inputStream.available());
    }

    @Override
    public void closeIfPossible() {
        if (!this.statement.isClosed()) {
            this.statement.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Integer> executeBatch() {
        void $this$mapTo$iv$iv;
        int[] nArray = this.statement.executeBatch();
        Intrinsics.checkNotNullExpressionValue(nArray, "statement.executeBatch()");
        int[] $this$map$iv = nArray;
        boolean $i$f$map = false;
        int[] nArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            int n2;
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (it) {
                case -2: {
                    n2 = 1;
                    break;
                }
                case -3: {
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = it;
                }
            }
            collection.add(n2);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void cancel() {
        if (!this.statement.isClosed()) {
            this.statement.cancel();
        }
    }

    @Override
    public int fillParameters(@NotNull Iterable<? extends Pair<? extends IColumnType, ? extends Object>> args2) {
        return PreparedStatementApi.DefaultImpls.fillParameters(this, args2);
    }
}

