/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExposedSQLException;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.SqlLogger;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionApiKt;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001aT\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0014\u001a-\u0010\u0015\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\n0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018\u001aH\u0010\u0002\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0019\u001a6\u0010\u0002\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\n0\u0012\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"closeStatementsAndConnection", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "handleSQLException", "cause", "Ljava/sql/SQLException;", "repetitions", "", "inTopLevelTransaction", "T", "transactionIsolation", "readOnly", "", "db", "Lorg/jetbrains/exposed/sql/Database;", "outerTransaction", "statement", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(IZLorg/jetbrains/exposed/sql/Database;Lorg/jetbrains/exposed/sql/Transaction;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "keepAndRestoreTransactionRefAfterRun", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "(IZLorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nThreadLocalTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadLocalTransactionManager.kt\norg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 TransactionApi.kt\norg/jetbrains/exposed/sql/transactions/TransactionApiKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n1855#2:329\n800#2,11:330\n1855#2,2:341\n1856#2:343\n164#3,6:344\n1#4:350\n*S KotlinDebug\n*F\n+ 1 ThreadLocalTransactionManager.kt\norg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManagerKt\n*L\n301#1:329\n302#1:330,11\n302#1:341,2\n301#1:343\n324#1:344,6\n*E\n"})
public final class ThreadLocalTransactionManagerKt {
    public static final <T> T transaction(@Nullable Database db, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        return ThreadLocalTransactionManagerKt.transaction(TransactionApiKt.getTransactionManager(db).getDefaultIsolationLevel(), TransactionApiKt.getTransactionManager(db).getDefaultReadOnly(), db, statement);
    }

    public static /* synthetic */ Object transaction$default(Database database, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(database, function1);
    }

    public static final <T> T transaction(int transactionIsolation, boolean readOnly, @Nullable Database db, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(db, new Function0<T>(db, transactionIsolation, readOnly, statement){
            final /* synthetic */ Database $db;
            final /* synthetic */ int $transactionIsolation;
            final /* synthetic */ boolean $readOnly;
            final /* synthetic */ Function1<Transaction, T> $statement;
            {
                this.$db = $db;
                this.$transactionIsolation = $transactionIsolation;
                this.$readOnly = $readOnly;
                this.$statement = $statement;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T invoke() {
                Object object;
                block15: {
                    block16: {
                        T t;
                        Transaction outer;
                        block14: {
                            T t2;
                            outer = TransactionManager.Companion.currentOrNull();
                            if (outer == null || this.$db != null && !Intrinsics.areEqual(outer.getDb(), this.$db)) break block14;
                            TransactionManager outerManager = TransactionApiKt.getTransactionManager(outer.getDb());
                            Transaction transaction2 = outerManager.newTransaction(this.$transactionIsolation, this.$readOnly, outer);
                            try {
                                T it = t2 = this.$statement.invoke(transaction2);
                                boolean bl = false;
                                if (outer.getDb().getUseNestedTransactions()) {
                                    transaction2.commit();
                                }
                            }
                            finally {
                                TransactionManager.Companion.resetCurrent(outerManager);
                            }
                            object = t2;
                            break block15;
                        }
                        Database database = this.$db;
                        TransactionManager existingForDb = database != null ? TransactionApiKt.getTransactionManager(database) : null;
                        object = existingForDb;
                        if (object == null || (object = object.currentOrNull()) == null) break block16;
                        Object object2 = object;
                        Function1<Transaction, T> function1 = this.$statement;
                        Database database2 = this.$db;
                        Object transaction3 = object2;
                        boolean bl = false;
                        Transaction transaction4 = outer;
                        TransactionManager currentManager = TransactionApiKt.getTransactionManager(transaction4 != null ? transaction4.getDb() : null);
                        try {
                            TransactionManager.Companion.resetCurrent(existingForDb);
                            T it = t = function1.invoke((Transaction)transaction3);
                            boolean bl2 = false;
                            if (database2.getUseNestedTransactions()) {
                                ((Transaction)transaction3).commit();
                            }
                        }
                        finally {
                            TransactionManager.Companion.resetCurrent(currentManager);
                        }
                        T t3 = t;
                        object = t3;
                        if (t3 != null) break block15;
                    }
                    object = ThreadLocalTransactionManagerKt.inTopLevelTransaction(this.$transactionIsolation, this.$readOnly, this.$db, null, this.$statement);
                }
                return (T)object;
            }
        });
    }

    public static /* synthetic */ Object transaction$default(int n, boolean bl, Database database, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(n, bl, database, function1);
    }

    public static final <T> T inTopLevelTransaction(int transactionIsolation, boolean readOnly, @Nullable Database db, @Nullable Transaction outerTransaction, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(db, new Function0<T>(outerTransaction, db, transactionIsolation, readOnly, statement){
            final /* synthetic */ Transaction $outerTransaction;
            final /* synthetic */ Database $db;
            final /* synthetic */ int $transactionIsolation;
            final /* synthetic */ boolean $readOnly;
            final /* synthetic */ Function1<Transaction, T> $statement;
            {
                this.$outerTransaction = $outerTransaction;
                this.$db = $db;
                this.$transactionIsolation = $transactionIsolation;
                this.$readOnly = $readOnly;
                this.$statement = $statement;
                super(0);
            }

            public final T invoke() {
                return (T)ThreadLocalTransactionManagerKt.access$inTopLevelTransaction$run(this.$outerTransaction, this.$db, this.$transactionIsolation, this.$readOnly, this.$statement);
            }
        });
    }

    public static /* synthetic */ Object inTopLevelTransaction$default(int n, boolean bl, Database database, Transaction transaction2, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        if ((n2 & 8) != 0) {
            transaction2 = null;
        }
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction(n, bl, database, transaction2, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T keepAndRestoreTransactionRefAfterRun(Database db, Function0<? extends T> block) {
        T t;
        TransactionManager manager = TransactionApiKt.getTransactionManager(db);
        Transaction currentTransaction = manager.currentOrNull();
        try {
            t = block.invoke();
        }
        finally {
            manager.bindTransactionToThread(currentTransaction);
        }
        return t;
    }

    static /* synthetic */ Object keepAndRestoreTransactionRefAfterRun$default(Database database, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, function0);
    }

    /*
     * WARNING - void declaration
     */
    public static final void handleSQLException(@NotNull SQLException cause, @NotNull Transaction transaction2, int repetitions) {
        Intrinsics.checkNotNullParameter(cause, "cause");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        ExposedSQLException exposedSQLException = cause instanceof ExposedSQLException ? (ExposedSQLException)cause : null;
        Object object = exposedSQLException;
        if (object == null || (object = ((ExposedSQLException)object).causedByQueries()) == null || (object = CollectionsKt.joinToString$default((Iterable)object, ";\n", null, null, 0, null, null, 62, null)) == null) {
            object = String.valueOf(transaction2.getCurrentStatement());
        }
        Object queriesToLog = object;
        String message = "Transaction attempt #" + repetitions + " failed: " + cause.getMessage() + ". Statement(s): " + (String)queriesToLog;
        Iterable<Throwable> iterable = exposedSQLException;
        if (iterable != null && (iterable = iterable.getContexts()) != null) {
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterIsInstanceTo$iv$iv;
                StatementContext it = (StatementContext)element$iv;
                boolean bl = false;
                Iterable $this$filterIsInstance$iv = transaction2.getInterceptors$exposed_core();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable2 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof SqlLogger)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SqlLogger logger = (SqlLogger)element$iv2;
                    boolean bl2 = false;
                    logger.log(it, transaction2);
                }
            }
        }
        SQLLogKt.getExposedLogger().warn(message, cause);
        TransactionApiKt.rollbackLoggingException(transaction2, handleSQLException.2.INSTANCE);
    }

    public static final void closeStatementsAndConnection(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        PreparedStatementApi currentStatement = transaction2.getCurrentStatement();
        try {
            PreparedStatementApi preparedStatementApi = currentStatement;
            if (preparedStatementApi != null) {
                PreparedStatementApi it = preparedStatementApi;
                boolean bl = false;
                it.closeIfPossible();
                transaction2.setCurrentStatement(null);
            }
            transaction2.closeExecutedStatements();
        }
        catch (Exception cause) {
            SQLLogKt.getExposedLogger().warn("Statements close failed", cause);
        }
        TransactionInterface $this$closeLoggingException$iv = transaction2;
        boolean $i$f$closeLoggingException = false;
        try {
            $this$closeLoggingException$iv.close();
        }
        catch (Exception e$iv) {
            Exception it = e$iv;
            boolean bl = false;
            SQLLogKt.getExposedLogger().warn("Transaction close failed: " + it.getMessage() + ". Statement: " + currentStatement, it);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T inTopLevelTransaction$run(Transaction $outerTransaction, Database $db, int $transactionIsolation, boolean $readOnly, Function1<? super Transaction, ? extends T> $statement) {
        TransactionManager transactionManager;
        int repetitions = 0;
        Transaction transaction2 = $outerTransaction;
        TransactionManager it = transactionManager = TransactionApiKt.getTransactionManager(transaction2 != null ? transaction2.getDb() : null);
        boolean bl = false;
        TransactionManager outerManager = it.currentOrNull() != null ? transactionManager : null;
        long intermediateDelay = 0L;
        Long retryInterval = null;
        while (true) {
            if ($db != null) {
                boolean bl2 = false;
                TransactionManager m = TransactionApiKt.getTransactionManager($db);
                boolean bl3 = false;
                TransactionManager.Companion.resetCurrent(m);
            }
            Transaction transaction3 = TransactionApiKt.getTransactionManager($db).newTransaction($transactionIsolation, $readOnly, $outerTransaction);
            try {
                Schema schema = transaction3.getDb().getConfig().getDefaultSchema();
                if (schema != null) {
                    Schema it2 = schema;
                    boolean bl4 = false;
                    SchemaUtils.setSchema$default(SchemaUtils.INSTANCE, it2, false, 2, null);
                }
                T answer = $statement.invoke(transaction3);
                transaction3.commit();
                T bl2 = answer;
                return bl2;
            }
            catch (SQLException cause) {
                ThreadLocalTransactionManagerKt.handleSQLException(cause, transaction3, repetitions);
                if (++repetitions >= transaction3.getRepetitionAttempts()) {
                    throw cause;
                }
                if (retryInterval == null) {
                    retryInterval = transaction3.getRetryInterval$exposed_core();
                    intermediateDelay = transaction3.getMinRepetitionDelay();
                }
                long delay = transaction3.getMinRepetitionDelay() < transaction3.getMaxRepetitionDelay() ? ThreadLocalRandom.current().nextLong(intermediateDelay += retryInterval * (long)repetitions, intermediateDelay + retryInterval) : (transaction3.getMinRepetitionDelay() == transaction3.getMaxRepetitionDelay() ? transaction3.getMinRepetitionDelay() : 0L);
                SQLLogKt.getExposedLogger().warn("Wait " + delay + " milliseconds before retrying");
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            catch (Throwable cause) {
                PreparedStatementApi currentStatement = transaction3.getCurrentStatement();
                TransactionApiKt.rollbackLoggingException(transaction3, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(currentStatement){
                    final /* synthetic */ PreparedStatementApi $currentStatement;
                    {
                        this.$currentStatement = $currentStatement;
                        super(1);
                    }

                    public final void invoke(@NotNull Exception it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + this.$currentStatement, it);
                    }
                });
                throw cause;
            }
            finally {
                TransactionManager.Companion.resetCurrent(outerManager);
                ThreadLocalTransactionManagerKt.closeStatementsAndConnection(transaction3);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ Object access$inTopLevelTransaction$run(Transaction $outerTransaction, Database $db, int $transactionIsolation, boolean $readOnly, Function1 $statement) {
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction$run($outerTransaction, $db, $transactionIsolation, $readOnly, $statement);
    }
}

