/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.Function;
import org.jetbrains.exposed.sql.JsonColumnMarker;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H&J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0014\u0010%\u001a\u00020\u00042\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\"H\u0016J\b\u0010'\u001a\u00020\u0004H\u0016J\b\u0010(\u001a\u00020\u0004H\u0016J\b\u0010)\u001a\u00020\u0004H\u0016J\b\u0010*\u001a\u00020\u0004H\u0016J\b\u0010+\u001a\u00020\u0004H\u0016J\b\u0010,\u001a\u00020\u0004H\u0016J\b\u0010-\u001a\u00020\u0004H\u0016J\b\u0010.\u001a\u00020\u0004H\u0016J\u0010\u0010/\u001a\u00020\u00012\u0006\u0010\n\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u0004H\u0016J\u0010\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0006H\u0016\u00a8\u00064"}, d2={"Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "", "()V", "binaryType", "", "length", "", "blobType", "booleanFromStringToBoolean", "", "value", "booleanToStatementString", "bool", "booleanType", "byteType", "dateTimeType", "dateType", "doubleType", "floatType", "hexToDb", "hexString", "integerAutoincType", "integerType", "jsonBType", "jsonType", "largeTextType", "longAutoincType", "longType", "mediumTextType", "precessOrderByClause", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "sortOrder", "Lorg/jetbrains/exposed/sql/SortOrder;", "processForDefaultValue", "e", "shortType", "textType", "timeType", "timestampWithTimeZoneType", "ubyteType", "uintegerType", "ulongType", "ushortType", "uuidToDB", "Ljava/util/UUID;", "uuidType", "varcharType", "colLength", "exposed-core"})
public abstract class DataTypeProvider {
    @NotNull
    public String byteType() {
        return "TINYINT";
    }

    @NotNull
    public String ubyteType() {
        return "SMALLINT";
    }

    @NotNull
    public String shortType() {
        return "SMALLINT";
    }

    @NotNull
    public String ushortType() {
        return "INT";
    }

    @NotNull
    public String integerType() {
        return "INT";
    }

    @NotNull
    public String uintegerType() {
        return "BIGINT";
    }

    @NotNull
    public String integerAutoincType() {
        return "INT AUTO_INCREMENT";
    }

    @NotNull
    public String longType() {
        return "BIGINT";
    }

    @NotNull
    public String ulongType() {
        return "BIGINT";
    }

    @NotNull
    public String longAutoincType() {
        return "BIGINT AUTO_INCREMENT";
    }

    @NotNull
    public String floatType() {
        return "FLOAT";
    }

    @NotNull
    public String doubleType() {
        return "DOUBLE PRECISION";
    }

    @NotNull
    public String varcharType(int colLength) {
        return "VARCHAR(" + colLength + ')';
    }

    @NotNull
    public String textType() {
        return "TEXT";
    }

    @NotNull
    public String mediumTextType() {
        return "TEXT";
    }

    @NotNull
    public String largeTextType() {
        return "TEXT";
    }

    @NotNull
    public abstract String binaryType();

    @NotNull
    public String binaryType(int length) {
        return length == Integer.MAX_VALUE ? "VARBINARY(MAX)" : "VARBINARY(" + length + ')';
    }

    @NotNull
    public String blobType() {
        return "BLOB";
    }

    @NotNull
    public String uuidType() {
        return "BINARY(16)";
    }

    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter(value, "value");
        byte[] byArray = ByteBuffer.allocate(16).putLong(value.getMostSignificantBits()).putLong(value.getLeastSignificantBits()).array();
        Intrinsics.checkNotNullExpressionValue(byArray, "allocate(16).putLong(val\u2026tSignificantBits).array()");
        return byArray;
    }

    @NotNull
    public String dateTimeType() {
        return "DATETIME";
    }

    @NotNull
    public String timestampWithTimeZoneType() {
        return "TIMESTAMP WITH TIME ZONE";
    }

    @NotNull
    public String timeType() {
        return "TIME";
    }

    @NotNull
    public String dateType() {
        return "DATE";
    }

    @NotNull
    public String booleanType() {
        return "BOOLEAN";
    }

    @NotNull
    public String booleanToStatementString(boolean bool) {
        String string = String.valueOf(bool).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string;
    }

    public boolean booleanFromStringToBoolean(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return Boolean.parseBoolean(value);
    }

    @NotNull
    public String jsonType() {
        return "JSON";
    }

    @NotNull
    public String jsonBType() {
        throw new UnsupportedByDialectException("This vendor does not support binary JSON data type", DatabaseDialectKt.getCurrentDialect());
    }

    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof JsonColumnMarker ? (DatabaseDialectKt.getCurrentDialect() instanceof H2Dialect ? StringsKt.substringAfter$default(String.valueOf(e), "JSON ", null, 2, null) : "" + '\'' + e + '\'') : (e instanceof LiteralOp ? String.valueOf(e) : (e instanceof Function ? String.valueOf(e) : (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect ? String.valueOf(e) : (DatabaseDialectKt.getCurrentDialect() instanceof SQLServerDialect ? String.valueOf(e) : "" + '(' + e + ')'))));
    }

    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter((Object)sortOrder, "sortOrder");
        Object[] objectArray = new Object[3];
        ExpressionAlias expressionAlias = expression instanceof ExpressionAlias ? (ExpressionAlias)expression : null;
        if (expressionAlias == null || (expressionAlias = expressionAlias.getAlias()) == null) {
            expressionAlias = expression;
        }
        objectArray[0] = expressionAlias;
        objectArray[1] = " ";
        objectArray[2] = sortOrder.getCode();
        ExpressionKt.append(queryBuilder, objectArray);
    }

    @NotNull
    public abstract String hexToDb(@NotNull String var1);
}

