/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Sequence;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J2\u0010\u0012\u001a\u00020\u0013\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0016J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016JW\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u001e\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0006\u0012\u0004\u0018\u00010\"0!0\r2\b\u0010#\u001a\u0004\u0018\u00010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010'R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006("}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2FunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "()V", "isH2Oracle", "", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "(Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;)Z", "insert", "", "ignore", "table", "Lorg/jetbrains/exposed/sql/Table;", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "expr", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "locate", "", "T", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "Lorg/jetbrains/exposed/sql/Expression;", "substring", "nextVal", "seq", "Lorg/jetbrains/exposed/sql/Sequence;", "builder", "update", "targets", "Lorg/jetbrains/exposed/sql/Join;", "columnsAndValues", "Lkotlin/Pair;", "", "limit", "", "where", "Lorg/jetbrains/exposed/sql/Op;", "(Lorg/jetbrains/exposed/sql/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nH2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2.kt\norg/jetbrains/exposed/sql/vendors/H2FunctionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n766#2:277\n857#2,2:278\n1446#2,5:280\n1549#2:285\n1620#2,3:286\n1#3:289\n*S KotlinDebug\n*F\n+ 1 H2.kt\norg/jetbrains/exposed/sql/vendors/H2FunctionProvider\n*L\n46#1:277\n46#1:278,2\n46#1:280,5\n80#1:285\n80#1:286,3\n*E\n"})
public final class H2FunctionProvider
extends FunctionProvider {
    @NotNull
    public static final H2FunctionProvider INSTANCE = new H2FunctionProvider();

    private H2FunctionProvider() {
    }

    private final boolean isH2Oracle(DatabaseDialect $this$isH2Oracle) {
        return H2Kt.getH2Mode($this$isH2Oracle) == H2Dialect.H2CompatibilityMode.Oracle;
    }

    @Override
    public void nextVal(@NotNull Sequence seq, @NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter(seq, "seq");
        Intrinsics.checkNotNullParameter(builder, "builder");
        DatabaseDialect databaseDialect = TransactionManager.Companion.current().getDb().getDialect();
        Intrinsics.checkNotNull(databaseDialect, "null cannot be cast to non-null type org.jetbrains.exposed.sql.vendors.H2Dialect");
        switch (WhenMappings.$EnumSwitchMapping$0[((H2Dialect)databaseDialect).getMajorVersion$exposed_core().ordinal()]) {
            case 1: {
                super.nextVal(seq, builder);
                break;
            }
            case 2: {
                builder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(seq){
                    final /* synthetic */ Sequence $seq;
                    {
                        this.$seq = $seq;
                        super(1);
                    }

                    public final void invoke(@NotNull QueryBuilder $this$invoke) {
                        Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                        $this$invoke.append("NEXT VALUE FOR " + this.$seq.getIdentifier());
                    }
                });
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction2) {
        String string;
        void $this$flatMapTo$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        Set uniqueCols = new LinkedHashSet();
        Iterable $this$filter$iv = table.getIndices();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            Index it = (Index)element$iv$iv;
            boolean bl = false;
            if (!it.getUnique()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Index it = (Index)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getColumns();
            CollectionsKt.addAll((Collection)uniqueCols, list$iv);
        }
        Column<?>[] columnArray = table.getPrimaryKey();
        if (columnArray != null && (columnArray = columnArray.getColumns()) != null) {
            Column<?>[] primaryKeys = columnArray;
            boolean bl = false;
            CollectionsKt.addAll((Collection)uniqueCols, primaryKeys);
        }
        DatabaseDialect databaseDialect = transaction2.getDb().getDialect();
        Intrinsics.checkNotNull(databaseDialect, "null cannot be cast to non-null type org.jetbrains.exposed.sql.vendors.H2Dialect");
        H2Dialect h2Dialect = (H2Dialect)databaseDialect;
        String version2 = h2Dialect.getVersion$exposed_core();
        boolean isMySQLMode = h2Dialect.getH2Mode() == H2Dialect.H2CompatibilityMode.MySQL;
        if (ignore && !((Collection)uniqueCols).isEmpty() && isMySQLMode && version2.compareTo("1.4.197") < 0) {
            String def = super.insert(false, table, columns2, expr, transaction2);
            string = def + " ON DUPLICATE KEY UPDATE " + CollectionsKt.joinToString$default(uniqueCols, null, null, null, 0, null, new Function1<Column<?>, CharSequence>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = $transaction;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Column<?> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$transaction.identity(it) + "=VALUES(" + this.$transaction.identity(it) + ')';
                }
            }, 31, null);
        } else if (ignore && !((Collection)uniqueCols).isEmpty() && isMySQLMode) {
            string = StringsKt.replace$default(super.insert(false, table, columns2, expr, transaction2), "INSERT", "INSERT IGNORE", false, 4, null);
        } else {
            if (ignore) {
                ExceptionsKt.throwUnsupportedException(transaction2, "INSERT IGNORE supported only on H2 v1.4.197+ with MODE=MYSQL.");
                throw new KotlinNothingValueException();
            }
            string = super.insert(ignore, table, columns2, expr, transaction2);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String update(@NotNull Join targets, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        QueryBuilder $this$update_u24lambda_u246;
        block7: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(targets, "targets");
            Intrinsics.checkNotNullParameter(columnsAndValues, "columnsAndValues");
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            $this$update_u24lambda_u246 = new QueryBuilder(true);
            boolean bl = false;
            if (limit != null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 doesn't support LIMIT in UPDATE with join clause.");
                throw new KotlinNothingValueException();
            }
            if (where != null && !INSTANCE.isH2Oracle(transaction2.getDb().getDialect())) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 doesn't support WHERE in UPDATE with join clause.");
                throw new KotlinNothingValueException();
            }
            Iterable $this$map$iv = columnsAndValues;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Column)it.getFirst()).getTable());
            }
            Table table = (Table)CollectionsKt.singleOrNull(CollectionsKt.distinct((List)destination$iv$iv));
            if (table == null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 supports a join updates with a single table columns to update.");
                throw new KotlinNothingValueException();
            }
            Table tableToUpdate = table;
            Join.JoinPart joinPart = CollectionsKt.singleOrNull(targets.getJoinParts$exposed_core());
            if (joinPart == null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 supports a join updates with only one table to join.");
                throw new KotlinNothingValueException();
            }
            Join.JoinPart joinPart2 = joinPart;
            if (joinPart2.getJoinType() != JoinType.INNER) {
                SQLLogKt.getExposedLogger().warn("All tables in UPDATE statement will be joined with inner join");
            }
            $this$update_u24lambda_u246.unaryPlus("MERGE INTO ");
            tableToUpdate.describe(transaction2, $this$update_u24lambda_u246);
            $this$update_u24lambda_u246.unaryPlus(" USING ");
            ColumnSet it = $i$f$map = joinPart2.getJoinPart();
            boolean bl3 = false;
            ColumnSet columnSet = !Intrinsics.areEqual(it, tableToUpdate) ? $i$f$map : null;
            if (columnSet == null) {
                columnSet = targets.getTable();
            }
            columnSet.describe(transaction2, $this$update_u24lambda_u246);
            $this$update_u24lambda_u246.unaryPlus(" ON ");
            joinPart2.appendConditions($this$update_u24lambda_u246);
            $this$update_u24lambda_u246.unaryPlus(" WHEN MATCHED THEN UPDATE SET ");
            ExpressionKt.appendTo$default(columnsAndValues, $this$update_u24lambda_u246, null, null, null, new Function2<QueryBuilder, Pair<? extends Column<?>, ? extends Object>, Unit>(transaction2){
                final /* synthetic */ Transaction $transaction;
                {
                    this.$transaction = $transaction;
                    super(2);
                }

                public final void invoke(@NotNull QueryBuilder $this$appendTo, @NotNull Pair<? extends Column<?>, ? extends Object> pair) {
                    Intrinsics.checkNotNullParameter($this$appendTo, "$this$appendTo");
                    Intrinsics.checkNotNullParameter(pair, "<name for destructuring parameter 0>");
                    Column<?> col = pair.component1();
                    Object value = pair.component2();
                    $this$appendTo.append(this.$transaction.fullIdentity(col) + '=');
                    $this$appendTo.registerArgument(col, value);
                }
            }, 14, null);
            Op<Boolean> op = where;
            if (op == null) break block7;
            Op<Boolean> it2 = op;
            boolean bl4 = false;
            $this$update_u24lambda_u246.unaryPlus(" WHERE ");
            $this$update_u24lambda_u246.unaryPlus((Expression)it2);
        }
        return $this$update_u24lambda_u246.toString();
    }

    @Override
    public <T extends String> void locate(@NotNull QueryBuilder queryBuilder, @NotNull Expression<T> expr, @NotNull String substring2) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(substring2, "substring");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(substring2, expr){
            final /* synthetic */ String $substring;
            final /* synthetic */ Expression<T> $expr;
            {
                this.$substring = $substring;
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                Object[] objectArray = new Object[]{"LOCATE('", this.$substring, "',", this.$expr, ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2MajorVersion.values().length];
            try {
                nArray[H2Dialect.H2MajorVersion.One.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[H2Dialect.H2MajorVersion.Two.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

