/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.JsonColumnMarker;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u00020\u00042\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "booleanFromStringToBoolean", "", "value", "dateTimeType", "hexToDb", "hexString", "jsonBType", "largeTextType", "mediumTextType", "precessOrderByClause", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "expression", "Lorg/jetbrains/exposed/sql/Expression;", "sortOrder", "Lorg/jetbrains/exposed/sql/SortOrder;", "processForDefaultValue", "e", "textType", "timestampWithTimeZoneType", "ubyteType", "uintegerType", "ulongType", "ushortType", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nMysqlDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlDialect.kt\norg/jetbrains/exposed/sql/vendors/MysqlDataTypeProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1#2:401\n*E\n"})
public final class MysqlDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final MysqlDataTypeProvider INSTANCE = new MysqlDataTypeProvider();

    private MysqlDataTypeProvider() {
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("The length of the Binary column is missing.");
        throw new IllegalStateException("The length of the Binary column is missing.".toString());
    }

    @Override
    @NotNull
    public String dateTimeType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
        return (mysqlDialect != null ? mysqlDialect.isFractionDateTimeSupported() : false) ? "DATETIME(6)" : "DATETIME";
    }

    @Override
    @NotNull
    public String timestampWithTimeZoneType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
        if (!(mysqlDialect != null ? mysqlDialect.isTimeZoneOffsetSupported() : false)) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("This vendor does not support timestamp with time zone data type");
            databaseDialect = DatabaseDialectKt.getCurrentDialect();
            MariaDBDialect mariaDBDialect = databaseDialect instanceof MariaDBDialect ? (MariaDBDialect)databaseDialect : null;
            if (mariaDBDialect != null) {
                MariaDBDialect mariaDBDialect2 = mariaDBDialect;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                string = "";
                stringBuilder = stringBuilder2;
            } else {
                string = " for this version";
            }
            DatabaseDialect databaseDialect2 = DatabaseDialectKt.getCurrentDialect();
            String string2 = stringBuilder.append(string).toString();
            throw new UnsupportedByDialectException(string2, databaseDialect2);
        }
        return "TIMESTAMP(6)";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "TINYINT UNSIGNED";
    }

    @Override
    @NotNull
    public String ushortType() {
        return "SMALLINT UNSIGNED";
    }

    @Override
    @NotNull
    public String uintegerType() {
        return "INT UNSIGNED";
    }

    @Override
    @NotNull
    public String ulongType() {
        return "BIGINT UNSIGNED";
    }

    @Override
    @NotNull
    public String textType() {
        return "text";
    }

    @Override
    @NotNull
    public String mediumTextType() {
        return "MEDIUMTEXT";
    }

    @Override
    @NotNull
    public String largeTextType() {
        return "LONGTEXT";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        String string = value;
        return Intrinsics.areEqual(string, "0") ? false : (Intrinsics.areEqual(string, "1") ? true : Boolean.parseBoolean(value));
    }

    @Override
    @NotNull
    public String jsonBType() {
        return "JSON";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkNotNullParameter(e, "e");
        if (e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof JsonColumnMarker) {
            if (DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect) {
                string = super.processForDefaultValue(e);
                return string;
            } else {
                DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
                MysqlDialect mysqlDialect = databaseDialect instanceof MysqlDialect ? (MysqlDialect)databaseDialect : null;
                boolean bl = mysqlDialect != null ? mysqlDialect.isMysql8$exposed_core() : false;
                if (!bl) throw new UnsupportedByDialectException("MySQL versions prior to 8.0.13 do not accept default values on JSON columns", DatabaseDialectKt.getCurrentDialect());
                string = '(' + super.processForDefaultValue(e) + ')';
            }
            return string;
        } else {
            string = super.processForDefaultValue(e);
        }
        return string;
    }

    @Override
    public void precessOrderByClause(@NotNull QueryBuilder queryBuilder, @NotNull Expression<?> expression, @NotNull SortOrder sortOrder) {
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter((Object)sortOrder, "sortOrder");
        switch (WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
            case 1: 
            case 2: {
                super.precessOrderByClause(queryBuilder, expression, sortOrder);
                break;
            }
            case 3: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.ASC);
                break;
            }
            case 4: {
                super.precessOrderByClause(queryBuilder, expression, SortOrder.DESC);
                break;
            }
            default: {
                ExpressionAlias expressionAlias = expression instanceof ExpressionAlias ? (ExpressionAlias)expression : null;
                if (expressionAlias == null || (expressionAlias = expressionAlias.getAlias()) == null) {
                    expressionAlias = expression;
                }
                ExpressionAlias exp = expressionAlias;
                SortOrder sortOrderAdjusted = sortOrder == SortOrder.ASC_NULLS_LAST ? SortOrder.DESC : SortOrder.ASC;
                Object[] objectArray = new Object[]{"-", exp, " ", sortOrderAdjusted.getCode()};
                ExpressionKt.append(queryBuilder, objectArray);
            }
        }
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        return "0x" + hexString;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SortOrder.values().length];
            try {
                nArray[SortOrder.ASC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.ASC_NULLS_FIRST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SortOrder.DESC_NULLS_LAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

