/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import org.jetbrains.exposed.sql.vendors.MysqlDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 .2\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0004H\u0016J\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0014J\u0014\u0010&\u001a\u00020\u00042\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(H\u0016J\u0006\u0010)\u001a\u00020\u0004J\u0006\u0010*\u001a\u00020\u0004J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010,\u001a\u00020\u0004*\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010-\u001a\u00020%H\u0014R\u001b\u0010\u0003\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006/"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "isMysql8", "", "isMysql8$exposed_core", "()Z", "isMysql8$delegate", "Lkotlin/Lazy;", "supportsCreateSequence", "getSupportsCreateSequence", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "supportsTernaryAffectedRowValues", "getSupportsTernaryAffectedRowValues", "createIndex", "", "index", "Lorg/jetbrains/exposed/sql/Index;", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropSchema", "cascade", "fillConstraintCacheForTables", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "isFractionDateTimeSupported", "isTimeZoneOffsetSupported", "setSchema", "metadataMatchesTable", "table", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nMysqlDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlDialect.kt\norg/jetbrains/exposed/sql/vendors/MysqlDialect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,400:1\n1194#2,2:401\n1222#2,4:403\n1603#2,9:407\n1855#2:416\n1856#2:418\n1612#2:419\n1#3:417\n*S KotlinDebug\n*F\n+ 1 MysqlDialect.kt\norg/jetbrains/exposed/sql/vendors/MysqlDialect\n*L\n300#1:401,2\n300#1:403,4\n304#1:407,9\n304#1:416\n304#1:418\n304#1:419\n304#1:417\n*E\n"})
public class MysqlDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy isMysql8$delegate = LazyKt.lazy(isMysql8.2.INSTANCE);
    private final boolean supportsCreateSequence;
    private final boolean supportsTernaryAffectedRowValues;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsSetDefaultReferenceOption;

    public MysqlDialect() {
        super(Companion.getDialectName(), MysqlDataTypeProvider.INSTANCE, MysqlFunctionProvider.INSTANCE.INSTANCE);
        this.supportsTernaryAffectedRowValues = true;
        this.supportsSubqueryUnions = true;
    }

    public final boolean isMysql8$exposed_core() {
        Lazy lazy = this.isMysql8$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        return this.supportsTernaryAffectedRowValues;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    public final boolean isFractionDateTimeSupported() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("5.6"));
    }

    public final boolean isTimeZoneOffsetSupported() {
        return !(DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect) && this.isMysql8$exposed_core();
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (super.isAllowedAsColumnDefault(e)) {
            return true;
        }
        String[] stringArray = new String[]{"CURRENT_TIMESTAMP", "CURRENT_TIMESTAMP()", "NOW()", "CURRENT_TIMESTAMP(6)", "NOW(6)"};
        String[] acceptableDefaults = stringArray;
        return ArraysKt.contains(acceptableDefaults, ((Object)StringsKt.trim((CharSequence)e.toString())).toString()) && this.isFractionDateTimeSupported();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object;
        Object element$iv$iv2;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Iterable $this$associateBy$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable<? extends Table>)tables);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo22 = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            Table table = (Table)element$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.nameInDatabaseCaseUnquoted(), element$iv$iv2);
        }
        Map allTables = destination$iv$iv;
        Set<String> allTableNames = allTables.keySet();
        String inTableList = CollectionsKt.joinToString$default(allTableNames, "','", " ku.TABLE_NAME IN ('", "')", 0, null, null, 56, null);
        Transaction tr = TransactionManager.Companion.current();
        Iterable $i$f$associateByTo22 = tables;
        object = new StringBuilder().append('\'');
        boolean $i$f$mapNotNull = false;
        element$iv$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Table it = (Table)element$iv$iv3;
            boolean bl2 = false;
            if (it.getSchemaName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        String string = (String)CollectionsKt.singleOrNull(CollectionsKt.toSet((List)destination$iv$iv2));
        if (string == null) {
            string = this.getDatabase();
        }
        String tableSchema = ((StringBuilder)object).append(string).append('\'').toString();
        HashMap<String, Map<String, ForeignKeyConstraint>> constraintsToLoad = new HashMap<String, Map<String, ForeignKeyConstraint>>();
        Transaction.exec$default(tr, StringsKt.trimIndent("SELECT\n                  rc.CONSTRAINT_NAME,\n                  ku.TABLE_NAME,\n                  ku.COLUMN_NAME,\n                  ku.REFERENCED_TABLE_NAME,\n                  ku.REFERENCED_COLUMN_NAME,\n                  rc.UPDATE_RULE,\n                  rc.DELETE_RULE\n                FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc\n                  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE ku\n                    ON ku.TABLE_SCHEMA = rc.CONSTRAINT_SCHEMA AND rc.CONSTRAINT_NAME = ku.CONSTRAINT_NAME\n                WHERE ku.TABLE_SCHEMA = " + tableSchema + "\n                  AND ku.CONSTRAINT_SCHEMA = " + tableSchema + "\n                  AND rc.CONSTRAINT_SCHEMA = " + tableSchema + "\n                  AND " + inTableList + "\n                ORDER BY ku.ORDINAL_POSITION\n            "), null, null, new Function1<ResultSet, Unit>(allTableNames, this, tr, (Map<String, ? extends Table>)allTables, constraintsToLoad){
            final /* synthetic */ Set<String> $allTableNames;
            final /* synthetic */ MysqlDialect this$0;
            final /* synthetic */ Transaction $tr;
            final /* synthetic */ Map<String, Table> $allTables;
            final /* synthetic */ HashMap<String, Map<String, ForeignKeyConstraint>> $constraintsToLoad;
            {
                this.$allTableNames = $allTableNames;
                this.this$0 = $receiver;
                this.$tr = $tr;
                this.$allTables = $allTables;
                this.$constraintsToLoad = $constraintsToLoad;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ResultSet rs) {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                Column column;
                Map fromTableName;
                Intrinsics.checkNotNullParameter(rs, "rs");
                while (rs.next()) {
                    String constraintName;
                    Object object;
                    T element$iv3;
                    Column fromColumn;
                    Object object2;
                    block7: {
                        String targetTableName;
                        Object v1;
                        Column $this$firstOrNull$iv;
                        Transaction transaction2;
                        MysqlDialect mysqlDialect;
                        block6: {
                            Intrinsics.checkNotNull(rs.getString("TABLE_NAME"));
                            if (!this.$allTableNames.contains(fromTableName)) continue;
                            String string = rs.getString("COLUMN_NAME");
                            Intrinsics.checkNotNull(string);
                            String fromColumnName = this.this$0.quoteIdentifierWhenWrongCaseOrNecessary(string, this.$tr);
                            Iterable iterable = MapsKt.getValue(this.$allTables, fromTableName).getColumns();
                            mysqlDialect = this.this$0;
                            transaction2 = this.$tr;
                            boolean $i$f$firstOrNull = false;
                            object2 = $this$firstOrNull$iv.iterator();
                            while (object2.hasNext()) {
                                T element$iv2 = object2.next();
                                Column it = (Column)element$iv2;
                                boolean bl = false;
                                if (!Intrinsics.areEqual(mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase(), transaction2), fromColumnName)) continue;
                                v1 = element$iv2;
                                break block6;
                            }
                            v1 = null;
                        }
                        if ((column = (Column)v1) == null) continue;
                        $this$firstOrNull$iv = column;
                        mysqlDialect = this.this$0;
                        transaction2 = this.$tr;
                        Map<String, Table> $i$f$firstOrNull = this.$allTables;
                        object2 = this.$constraintsToLoad;
                        fromColumn = $this$firstOrNull$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull(rs.getString("CONSTRAINT_NAME"));
                        Intrinsics.checkNotNull(rs.getString("REFERENCED_TABLE_NAME"));
                        String string = rs.getString("REFERENCED_COLUMN_NAME");
                        Intrinsics.checkNotNull(string);
                        String targetColumnName = mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(string, transaction2);
                        Iterable $this$first$iv = MapsKt.getValue($i$f$firstOrNull, targetTableName).getColumns();
                        boolean $i$f$first = false;
                        for (T element$iv3 : $this$first$iv) {
                            Column it = (Column)element$iv3;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase(), transaction2), targetColumnName)) continue;
                            break block7;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Column targetColumn = (Column)element$iv3;
                    String string = rs.getString("UPDATE_RULE");
                    Intrinsics.checkNotNull(string);
                    ReferenceOption constraintUpdateRule = ReferenceOption.valueOf(StringsKt.replace$default(string, " ", "_", false, 4, null));
                    String string2 = rs.getString("DELETE_RULE");
                    Intrinsics.checkNotNull(string2);
                    ReferenceOption constraintDeleteRule = ReferenceOption.valueOf(StringsKt.replace$default(string2, " ", "_", false, 4, null));
                    Map $this$getOrPut$iv = (Map)object2;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(fromTableName);
                    if (value$iv == null) {
                        boolean bl = false;
                        Map answer$iv = new LinkedHashMap<K, V>();
                        $this$getOrPut$iv.put(fromTableName, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Map)object).merge(constraintName, new ForeignKeyConstraint(targetColumn, fromColumn, constraintUpdateRule, constraintDeleteRule, constraintName), (arg_0, arg_1) -> fillConstraintCacheForTables.1.invoke$lambda$4$lambda$3(fillConstraintCacheForTables.2.2.INSTANCE, arg_0, arg_1));
                }
                fromTableName = this.$constraintsToLoad;
                Map<String, Collection<ForeignKeyConstraint>> map2 = this.this$0.getColumnConstraintsCache();
                boolean $i$f$mapValues = false;
                column = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity($this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry bl = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl3 = false;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    K k = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl4 = false;
                    Map v = (Map)entry.getValue();
                    Collection<V> collection = v.values();
                    map4.put(k, collection);
                }
                map2.putAll(destination$iv$iv);
            }

            private static final ForeignKeyConstraint invoke$lambda$4$lambda$3(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                return (ForeignKeyConstraint)$tmp0.invoke(p0, p1);
            }
        }, 6, null);
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter(index, "index");
        if (index.getFunctions() != null && !this.isMysql8$exposed_core()) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default(index.getFunctions(), null, null, null, 0, null, createIndex.1.INSTANCE, 31, null) + " can't be created in MySQL prior to 8.0");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(indexName2, "indexName");
        return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP INDEX " + this.getIdentifierManager().quoteIfNecessary(indexName2);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "USE " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(schema, "schema");
        StringBuilder $this$createSchema_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA IF NOT EXISTS ", schema.getIdentifier()};
        StringsKt.append($this$createSchema_u24lambda_u242, stringArray);
        if (schema.getAuthorization() != null) {
            throw new UnsupportedByDialectException(DatabaseDialectKt.getCurrentDialect().getName() + " do not have database owners. You can use GRANT to allow or deny rights on database.", DatabaseDialectKt.getCurrentDialect());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "DROP SCHEMA IF EXISTS " + schema.getIdentifier();
    }

    @Override
    protected boolean metadataMatchesTable(@NotNull String $this$metadataMatchesTable, @NotNull String schema, @NotNull Table table) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$metadataMatchesTable, "<this>");
        Intrinsics.checkNotNullParameter(schema, "schema");
        Intrinsics.checkNotNullParameter(table, "table");
        if (((CharSequence)schema).length() == 0) {
            bl = Intrinsics.areEqual($this$metadataMatchesTable, table.nameInDatabaseCaseUnquoted());
        } else {
            String sanitizedTableName = StringsKt.replace$default(table.getTableNameWithoutScheme$exposed_core(), "`", "", false, 4, null);
            String nameInDb = DatabaseDialectKt.inProperCase(schema + '.' + sanitizedTableName);
            bl = Intrinsics.areEqual($this$metadataMatchesTable, nameInDb);
        }
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("MySQL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

