/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\u0014\u0010\u0018\u001a\u00020\u00042\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020\u0004H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0004H\u0016J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0006H\u0016\u00a8\u0006'"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "length", "", "booleanFromStringToBoolean", "", "value", "booleanToStatementString", "bool", "booleanType", "byteType", "dateTimeType", "hexToDb", "hexString", "integerAutoincType", "integerType", "jsonType", "largeTextType", "longAutoincType", "longType", "mediumTextType", "processForDefaultValue", "e", "Lorg/jetbrains/exposed/sql/Expression;", "textType", "timeType", "ubyteType", "uintegerType", "ulongType", "ushortType", "uuidToDB", "", "Ljava/util/UUID;", "uuidType", "varcharType", "colLength", "exposed-core"})
public final class OracleDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final OracleDataTypeProvider INSTANCE = new OracleDataTypeProvider();

    private OracleDataTypeProvider() {
    }

    @Override
    @NotNull
    public String byteType() {
        return "SMALLINT";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "NUMBER(4)";
    }

    @Override
    @NotNull
    public String ushortType() {
        return "NUMBER(6)";
    }

    @Override
    @NotNull
    public String integerType() {
        return "NUMBER(12)";
    }

    @Override
    @NotNull
    public String integerAutoincType() {
        return "NUMBER(12)";
    }

    @Override
    @NotNull
    public String uintegerType() {
        return "NUMBER(13)";
    }

    @Override
    @NotNull
    public String longType() {
        return "NUMBER(19)";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return "NUMBER(19)";
    }

    @Override
    @NotNull
    public String ulongType() {
        return "NUMBER(20)";
    }

    @Override
    @NotNull
    public String varcharType(int colLength) {
        return "VARCHAR2(" + colLength + " CHAR)";
    }

    @Override
    @NotNull
    public String textType() {
        return "CLOB";
    }

    @Override
    @NotNull
    public String mediumTextType() {
        return this.textType();
    }

    @Override
    @NotNull
    public String largeTextType() {
        return this.textType();
    }

    @Override
    @NotNull
    public String timeType() {
        return this.dateTimeType();
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("Binary type is unsupported for Oracle. Please use blob column type instead.");
        throw new IllegalStateException("Binary type is unsupported for Oracle. Please use blob column type instead.".toString());
    }

    @Override
    @NotNull
    public String binaryType(int length) {
        return length < 2000 ? "RAW (" + length + ')' : this.binaryType();
    }

    @Override
    @NotNull
    public String uuidType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if ((h2Dialect != null ? h2Dialect.getH2Mode() : null) != H2Dialect.H2CompatibilityMode.Oracle) {
            return "RAW(16)";
        }
        return "UUID";
    }

    @Override
    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter(value, "value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        return (h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.Oracle ? H2DataTypeProvider.INSTANCE.uuidToDB(value) : super.uuidToDB(value);
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    @NotNull
    public String booleanType() {
        return "CHAR(1)";
    }

    @Override
    @NotNull
    public String booleanToStatementString(boolean bool) {
        return bool ? "1" : "0";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter(value, "value");
        try {
            bl = Long.parseLong(value) != 0L;
        }
        catch (NumberFormatException ex) {
            boolean bl2;
            try {
                String string = value.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                bl2 = StringsKt.toBooleanStrict(string);
            }
            catch (IllegalArgumentException ex2) {
                throw new IllegalStateException(("Unexpected value of type Boolean: " + value).toString());
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    @NotNull
    public String jsonType() {
        return "VARCHAR2(4000)";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkNotNullParameter(e, "e");
        if (e instanceof LiteralOp) {
            IColumnType iColumnType = ((LiteralOp)e).getColumnType();
            IDateColumnType iDateColumnType = iColumnType instanceof IDateColumnType ? (IDateColumnType)((Object)iColumnType) : null;
            boolean bl = iDateColumnType != null ? !iDateColumnType.getHasTimePart() : false;
            if (bl) {
                string = "DATE " + super.processForDefaultValue(e);
                return string;
            }
        }
        if (e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof IDateColumnType) {
            string = "TIMESTAMP " + super.processForDefaultValue(e);
            return string;
        }
        string = super.processForDefaultValue(e);
        return string;
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        return "HEXTORAW('" + hexString + "')";
    }
}

