/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.OracleDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.OracleFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 92\u00020\u0001:\u00019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J(\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bH\u0016J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020\bH\u0016J\u0014\u0010+\u001a\u00020\b2\n\u0010,\u001a\u0006\u0012\u0002\b\u00030-H\u0016J\b\u0010.\u001a\u00020\u001eH\u0016J\"\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001e002\n\u00101\u001a\u0006\u0012\u0002\b\u0003022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0014\u0010\u0017\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u0014\u0010\u0019\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\nR\u0014\u0010\u001b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\n\u00a8\u0006:"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsIfNotExists", "getSupportsIfNotExists", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsOnUpdate", "getSupportsOnUpdate", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsRestrictReferenceOption", "getSupportsRestrictReferenceOption", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "createDatabase", "", "name", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropDatabase", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropSchema", "cascade", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "listDatabases", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "resolveRefOptionFromJdbc", "refOption", "", "setSchema", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nOracleDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OracleDialect.kt\norg/jetbrains/exposed/sql/vendors/OracleDialect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,383:1\n1549#2:384\n1620#2,3:385\n1549#2:388\n1620#2,3:389\n*S KotlinDebug\n*F\n+ 1 OracleDialect.kt\norg/jetbrains/exposed/sql/vendors/OracleDialect\n*L\n327#1:384\n327#1:385,3\n332#1:388\n332#1:389,3\n*E\n"})
public class OracleDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsSequenceToAutoInc;
    @NotNull
    private final ReferenceOption defaultReferenceOption = ReferenceOption.NO_ACTION;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsDualTableConcept;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsOnUpdate;
    private final boolean supportsSetDefaultReferenceOption;
    private final boolean supportsRestrictReferenceOption;

    public OracleDialect() {
        super(Companion.getDialectName(), OracleDataTypeProvider.INSTANCE, OracleFunctionProvider.INSTANCE);
        this.needsSequenceToAutoInc = true;
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        this.supportsDualTableConcept = true;
        this.supportsOrderByNullsFirstLast = true;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return this.needsSequenceToAutoInc;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return this.defaultReferenceOption;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return this.supportsDualTableConcept;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsOnUpdate() {
        return this.supportsOnUpdate;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return this.supportsRestrictReferenceOption;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return true;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(indexName2, "indexName");
        return "DROP INDEX " + this.getIdentifierManager().quoteIfNecessary(indexName2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        List list;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, "column");
        Intrinsics.checkNotNullParameter(columnDiff, "columnDiff");
        Iterable $this$map$iv = super.modifyColumn(column, columnDiff);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, "MODIFY COLUMN", "MODIFY", false, 4, null));
        }
        List result2 = (List)destination$iv$iv;
        if (!columnDiff.getNullability()) {
            void $this$mapTo$iv$iv2;
            String nullableState = column.getColumnType().getNullable() ? "NULL " : "NOT NULL";
            Iterable $this$map$iv2 = result2;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(StringsKt.replace$default((String)it, nullableState, "", false, 4, null));
            }
            list = (List)destination$iv$iv2;
        } else {
            list = result2;
        }
        return list;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(name2);
    }

    @Override
    @NotNull
    public String listDatabases() {
        throw new IllegalStateException("This operation is not supported by Oracle dialect".toString());
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "DROP DATABASE";
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "ALTER SESSION SET CURRENT_SCHEMA = " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(schema, "schema");
        StringBuilder $this$createSchema_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (schema.getQuota() == null ^ schema.getOn() == null) {
            throw new IllegalArgumentException("You must either provide both <quota> and <on> options or non of them");
        }
        String[] stringArray = new String[]{"CREATE USER ", schema.getIdentifier()};
        StringsKt.append($this$createSchema_u24lambda_u242, stringArray);
        stringArray = new String[]{" IDENTIFIED BY ", schema.getPassword()};
        StringsKt.append($this$createSchema_u24lambda_u242, stringArray);
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " DEFAULT TABLESPACE ", schema.getDefaultTablespace());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " TEMPORARY TABLESPACE ", schema.getTemporaryTablespace());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " QUOTA ", schema.getQuota());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u242, " ON ", schema.getOn());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(schema, "schema");
        StringBuilder $this$dropSchema_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"DROP USER ", schema.getIdentifier()};
        StringsKt.append($this$dropSchema_u24lambda_u243, stringArray);
        if (cascade) {
            $this$dropSchema_u24lambda_u243.append(" CASCADE");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public ReferenceOption resolveRefOptionFromJdbc(int refOption) {
        ReferenceOption referenceOption;
        switch (refOption) {
            case 0: {
                referenceOption = ReferenceOption.CASCADE;
                break;
            }
            case 2: {
                referenceOption = ReferenceOption.SET_NULL;
                break;
            }
            case 1: {
                referenceOption = ReferenceOption.NO_ACTION;
                break;
            }
            default: {
                referenceOption = DatabaseDialectKt.getCurrentDialect().getDefaultReferenceOption();
            }
        }
        return referenceOption;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("Oracle");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

