/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.PostgreSQLFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J0\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J(\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0014\u0010\u001b\u001a\u00020\b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006)"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "requiresAutoCommitOnCreateDrop", "", "getRequiresAutoCommitOnCreateDrop", "()Z", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsWindowFrameGroupsMode", "getSupportsWindowFrameGroupsMode", "createDatabase", "createIndexWithType", "table", "columns", "type", "filterCondition", "dropDatabase", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "listDatabases", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "setSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "Companion", "exposed-core"})
public class PostgreSQLDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean requiresAutoCommitOnCreateDrop;
    private final boolean supportsWindowFrameGroupsMode;

    public PostgreSQLDialect(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        super(Companion.getDialectName(), PostgreSQLDataTypeProvider.INSTANCE, PostgreSQLFunctionProvider.INSTANCE);
        this.name = name2;
        this.supportsOrderByNullsFirstLast = true;
        this.requiresAutoCommitOnCreateDrop = true;
        this.supportsWindowFrameGroupsMode = true;
    }

    public /* synthetic */ PostgreSQLDialect(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = Companion.getDialectName();
        }
        this(string);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getRequiresAutoCommitOnCreateDrop() {
        return this.requiresAutoCommitOnCreateDrop;
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        return this.supportsWindowFrameGroupsMode;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return true;
    }

    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        StringBuilder stringBuilder;
        block6: {
            Expression<?> expression;
            String colName;
            StringBuilder $this$modifyColumn_u24lambda_u242;
            block7: {
                Intrinsics.checkNotNullParameter(column, "column");
                Intrinsics.checkNotNullParameter(columnDiff, "columnDiff");
                $this$modifyColumn_u24lambda_u242 = stringBuilder = new StringBuilder();
                boolean bl = false;
                Transaction tr = TransactionManager.Companion.current();
                $this$modifyColumn_u24lambda_u242.append("ALTER TABLE " + tr.identity(column.getTable()) + ' ');
                colName = tr.identity(column);
                $this$modifyColumn_u24lambda_u242.append("ALTER COLUMN " + colName + " TYPE " + column.getColumnType().sqlType());
                if (columnDiff.getNullability()) {
                    $this$modifyColumn_u24lambda_u242.append(", ALTER COLUMN " + colName + ' ');
                    if (column.getColumnType().getNullable()) {
                        $this$modifyColumn_u24lambda_u242.append("DROP ");
                    } else {
                        $this$modifyColumn_u24lambda_u242.append("SET ");
                    }
                    $this$modifyColumn_u24lambda_u242.append("NOT NULL");
                }
                if (!columnDiff.getDefaults()) break block6;
                expression = column.getDbDefaultValue$exposed_core();
                if (expression == null) break block7;
                Expression<?> it = expression;
                boolean bl2 = false;
                StringBuilder stringBuilder2 = $this$modifyColumn_u24lambda_u242.append(", ALTER COLUMN " + colName + " SET DEFAULT " + PostgreSQLDataTypeProvider.INSTANCE.processForDefaultValue(it));
                expression = stringBuilder2;
                if (stringBuilder2 != null) break block6;
            }
            StringBuilder $this$modifyColumn_u24lambda_u242_u24lambda_u241 = $this$modifyColumn_u24lambda_u242;
            boolean bl = false;
            expression = $this$modifyColumn_u24lambda_u242_u24lambda_u241.append(",  ALTER COLUMN " + colName + " DROP DEFAULT");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return CollectionsKt.listOf(string);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(name2);
    }

    @Override
    @NotNull
    public String listDatabases() {
        return "SELECT datname FROM pg_database";
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "DROP DATABASE " + DatabaseDialectKt.inProperCase(name2);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "SET search_path TO " + schema.getIdentifier();
    }

    @Override
    @NotNull
    protected String createIndexWithType(@NotNull String name2, @NotNull String table, @NotNull String columns2, @NotNull String type2, @NotNull String filterCondition) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(filterCondition, "filterCondition");
        return "CREATE INDEX " + name2 + " ON " + table + " USING " + type2 + ' ' + columns2 + filterCondition;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(indexName2, "indexName");
        return isUnique && !isPartialOrFunctional ? "ALTER TABLE IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP CONSTRAINT IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName2) : "DROP INDEX IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName2);
    }

    public PostgreSQLDialect() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("PostgreSQL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

