/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.SQLServerDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLServerFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0016J0\u0010!\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012H\u0014J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J(\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020\rH\u0016J\u0018\u0010/\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u00100\u001a\u00020\rH\u0016J\u0014\u00101\u001a\u00020\r2\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0016J\b\u00104\u001a\u00020\u0012H\u0016J\"\u00105\u001a\b\u0012\u0004\u0012\u00020\u0012062\n\u00107\u001a\u0006\u0012\u0002\b\u0003082\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000f\u00a8\u0006="}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "likePatternSpecialChars", "", "", "getLikePatternSpecialChars", "()Ljava/util/Map;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "nonAcceptableDefaults", "", "", "[Ljava/lang/String;", "supportsIfNotExists", "getSupportsIfNotExists", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "supportsRestrictReferenceOption", "getSupportsRestrictReferenceOption", "supportsSequenceAsGeneratedKeys", "getSupportsSequenceAsGeneratedKeys", "createDatabase", "name", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "createIndexWithType", "table", "columns", "type", "filterCondition", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropDatabase", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "dropSchema", "cascade", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "listDatabases", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "setSchema", "Companion", "exposed-core"})
public class SQLServerDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsSequenceAsGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsRestrictReferenceOption;
    @NotNull
    private final String[] nonAcceptableDefaults;
    @NotNull
    private final Map<Character, Character> likePatternSpecialChars;
    @NotNull
    private static final Map<Character, Character> sqlServerLikePatternSpecialChars;

    public SQLServerDialect() {
        super(Companion.getDialectName(), SQLServerDataTypeProvider.INSTANCE, SQLServerFunctionProvider.INSTANCE);
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        String[] stringArray = new String[]{"DEFAULT"};
        this.nonAcceptableDefaults = stringArray;
        this.likePatternSpecialChars = sqlServerLikePatternSpecialChars;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return ReferenceOption.NO_ACTION;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return this.supportsSequenceAsGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return this.supportsRestrictReferenceOption;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        String string = e.toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        String columnDefault = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return !ArraysKt.contains(this.nonAcceptableDefaults, columnDefault);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        List statements;
        block7: {
            StringBuilder stringBuilder;
            List list;
            block9: {
                void $this$modifyColumn_u24lambda_u242;
                Expression<?> expression;
                String dropConstraint;
                String alterTablePart;
                block8: {
                    void $this$modifyColumn_u24lambda_u240;
                    StringBuilder stringBuilder2;
                    Intrinsics.checkNotNullParameter(column, "column");
                    Intrinsics.checkNotNullParameter(columnDiff, "columnDiff");
                    Transaction transaction2 = TransactionManager.Companion.current();
                    alterTablePart = "ALTER TABLE " + transaction2.identity(column.getTable()) + ' ';
                    statements = new ArrayList();
                    StringBuilder stringBuilder3 = stringBuilder2 = new StringBuilder();
                    list = statements;
                    boolean bl = false;
                    $this$modifyColumn_u24lambda_u240.append(alterTablePart + "ALTER COLUMN " + transaction2.identity(column) + ' ' + column.getColumnType().sqlType());
                    if (columnDiff.getNullability()) {
                        boolean isPKColumn;
                        Expression<?> defaultValue = column.getDbDefaultValue$exposed_core();
                        Column<?>[] columnArray = column.getTable().getPrimaryKey();
                        boolean bl2 = columnArray != null && (columnArray = columnArray.getColumns()) != null ? ArraysKt.contains(columnArray, column) : (isPKColumn = false);
                        if (column.getColumnType().getNullable() || defaultValue != null && column.getDefaultValueFun() == null && !DatabaseDialectKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
                            $this$modifyColumn_u24lambda_u240.append(" NULL");
                        } else if (!isPKColumn) {
                            $this$modifyColumn_u24lambda_u240.append(" NOT NULL");
                        }
                    }
                    String string = stringBuilder2.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
                    list.add(string);
                    if (!columnDiff.getDefaults()) break block7;
                    String tableName = column.getTable().getTableName();
                    String columnName = column.getName();
                    String constraintName = "DF_" + tableName + '_' + columnName;
                    dropConstraint = "DROP CONSTRAINT IF EXISTS " + constraintName;
                    StringBuilder stringBuilder4 = stringBuilder = new StringBuilder();
                    list = statements;
                    boolean bl3 = false;
                    expression = column.getDbDefaultValue$exposed_core();
                    if (expression == null) break block8;
                    Expression<?> it = expression;
                    boolean bl4 = false;
                    $this$modifyColumn_u24lambda_u242.append(alterTablePart + dropConstraint);
                    $this$modifyColumn_u24lambda_u242.append("; ");
                    StringBuilder stringBuilder5 = $this$modifyColumn_u24lambda_u242.append(alterTablePart + "ADD CONSTRAINT " + constraintName + " DEFAULT " + SQLServerDataTypeProvider.INSTANCE.processForDefaultValue(it) + " for " + transaction2.identity(column));
                    expression = stringBuilder5;
                    if (stringBuilder5 != null) break block9;
                }
                expression = $this$modifyColumn_u24lambda_u242.append(alterTablePart + dropConstraint);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
            list.add(string);
        }
        return statements;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "CREATE DATABASE " + DatabaseDialectKt.inProperCase(name2);
    }

    @Override
    @NotNull
    public String listDatabases() {
        return "SELECT name FROM sys.databases";
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return "DROP DATABASE " + DatabaseDialectKt.inProperCase(name2);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "ALTER USER " + schema.getAuthorization() + " WITH DEFAULT_SCHEMA = " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(schema, "schema");
        StringBuilder $this$createSchema_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA ", schema.getIdentifier()};
        StringsKt.append($this$createSchema_u24lambda_u243, stringArray);
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u243, " AUTHORIZATION ", schema.getAuthorization());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "DROP SCHEMA " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter(index, "index");
        if (index.getFunctions() != null) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default(index.getFunctions(), null, null, null, 0, null, createIndex.1.INSTANCE, 31, null) + " can't be created in SQLServer");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    protected String createIndexWithType(@NotNull String name2, @NotNull String table, @NotNull String columns2, @NotNull String type2, @NotNull String filterCondition) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(filterCondition, "filterCondition");
        return "CREATE " + type2 + " INDEX " + name2 + " ON " + table + ' ' + columns2 + filterCondition;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(indexName2, "indexName");
        return isUnique && !isPartialOrFunctional ? "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP CONSTRAINT IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName2) : "DROP INDEX IF EXISTS " + this.getIdentifierManager().quoteIfNecessary(indexName2) + " ON " + this.getIdentifierManager().quoteIfNecessary(tableName);
    }

    @Override
    @NotNull
    public Map<Character, Character> getLikePatternSpecialChars() {
        return this.likePatternSpecialChars;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('%'), null), TuplesKt.to(Character.valueOf('_'), null), TuplesKt.to(Character.valueOf('['), Character.valueOf(']'))};
        sqlServerLikePatternSpecialChars = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDialect$Companion;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "()V", "sqlServerLikePatternSpecialChars", "", "", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("SQLServer");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

