/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Function;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.sql.vendors.PrimaryKeyMetadata;
import org.jetbrains.exposed.sql.vendors.SQLServerDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;
import org.jetbrains.exposed.sql.vendors.SchemaMetadata;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001]B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ;\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u00032\u001a\u0010,\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030.0-\"\u0006\u0012\u0002\b\u00030.H\u0016\u00a2\u0006\u0002\u0010/J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0016JW\u00100\u001a8\u0012(\u0012&\u0012\u0004\u0012\u00020*\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030.02j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030.`301\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\n0\f2\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0-\"\u00020*H\u0016\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u000208H\u0016J0\u00109\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u0003H\u0014J(\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020!2\u0006\u0010A\u001a\u00020!H\u0016J3\u0010B\u001a\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\n0\f2\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0-\"\u00020*H\u0016\u00a2\u0006\u0002\u00105J/\u0010C\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010D0\f2\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0-\"\u00020*H\u0016\u00a2\u0006\u0002\u00105J\u0016\u0010E\u001a\u00020F2\f\u00104\u001a\b\u0012\u0004\u0012\u00020*0\nH\u0014J\u0010\u0010<\u001a\u0004\u0018\u00010\u00032\u0006\u00107\u001a\u000208J\u000e\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002J\u001a\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\fH\u0004J\b\u0010I\u001a\u00020\u0003H\u0016J\u0014\u0010J\u001a\u00020\u00032\n\u0010K\u001a\u0006\u0012\u0002\b\u00030LH\u0002J\"\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\n\u0010N\u001a\u0006\u0012\u0002\b\u00030.2\u0006\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u00020FH\u0016J\b\u0010R\u001a\u00020FH\u0016J\u0010\u0010S\u001a\u00020!2\u0006\u0010T\u001a\u00020UH\u0016J\b\u0010$\u001a\u00020!H\u0016J3\u0010V\u001a\u0014\u0012\u0004\u0012\u00020*\u0012\n\u0012\b\u0012\u0004\u0012\u00020W0\n0\f2\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0-\"\u00020*H\u0016\u00a2\u0006\u0002\u00105J\u0010\u0010X\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0016J\u001c\u0010Y\u001a\u00020!*\u00020\u00032\u0006\u0010T\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*H\u0014J\u0014\u0010Z\u001a\u00020\u0003*\u00020\u00032\u0006\u0010[\u001a\u00020\\H\u0004R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001b\u0010$\u001a\u00020!8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b%\u0010#\u00a8\u0006^"}, d2={"Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "name", "", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "functionProvider", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;)V", "_allSchemaNames", "", "_allTableNames", "", "allTablesNames", "getAllTablesNames", "()Ljava/util/List;", "columnConstraintsCache", "", "", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "getColumnConstraintsCache", "()Ljava/util/Map;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "identifierManager", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "getName", "()Ljava/lang/String;", "supportsMultipleGeneratedKeys", "", "getSupportsMultipleGeneratedKeys", "()Z", "supportsSelectForUpdate", "getSupportsSelectForUpdate", "supportsSelectForUpdate$delegate", "Lkotlin/Lazy;", "addPrimaryKey", "table", "Lorg/jetbrains/exposed/sql/Table;", "pkName", "pkColumns", "", "Lorg/jetbrains/exposed/sql/Column;", "(Lorg/jetbrains/exposed/sql/Table;Ljava/lang/String;[Lorg/jetbrains/exposed/sql/Column;)Ljava/lang/String;", "columnConstraints", "Lkotlin/Pair;", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "tables", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "createIndexWithType", "columns", "type", "filterCondition", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "existingIndices", "existingPrimaryKeys", "Lorg/jetbrains/exposed/sql/vendors/PrimaryKeyMetadata;", "fillConstraintCacheForTables", "", "getAllSchemaNamesCache", "getAllTableNamesCache", "getDatabase", "indexFunctionToString", "function", "Lorg/jetbrains/exposed/sql/Function;", "modifyColumn", "column", "columnDiff", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "resetCaches", "resetSchemaCaches", "schemaExists", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "tableColumns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tableExists", "metadataMatchesTable", "quoteIdentifierWhenWrongCaseOrNecessary", "tr", "Lorg/jetbrains/exposed/sql/Transaction;", "DialectNameProvider", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nVendorDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VendorDialect.kt\norg/jetbrains/exposed/sql/vendors/VendorDialect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1747#2,3:240\n1747#2,3:243\n1747#2,3:246\n1855#2:253\n1856#2:261\n3792#3:249\n4307#3,2:250\n13309#3:252\n13310#3:262\n372#4,7:254\n1#5:263\n*S KotlinDebug\n*F\n+ 1 VendorDialect.kt\norg/jetbrains/exposed/sql/vendors/VendorDialect\n*L\n65#1:240,3\n72#1:243,3\n91#1:246,3\n106#1:253\n106#1:261\n102#1:249\n102#1:250,2\n105#1:252\n105#1:262\n107#1:254,7\n*E\n"})
public abstract class VendorDialect
implements DatabaseDialect {
    @NotNull
    private final String name;
    @NotNull
    private final DataTypeProvider dataTypeProvider;
    @NotNull
    private final FunctionProvider functionProvider;
    @Nullable
    private Map<String, ? extends List<String>> _allTableNames;
    @Nullable
    private List<String> _allSchemaNames;
    private final boolean supportsMultipleGeneratedKeys;
    @NotNull
    private final Lazy supportsSelectForUpdate$delegate;
    @NotNull
    private final Map<String, Collection<ForeignKeyConstraint>> columnConstraintsCache;

    public VendorDialect(@NotNull String name2, @NotNull DataTypeProvider dataTypeProvider2, @NotNull FunctionProvider functionProvider2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(dataTypeProvider2, "dataTypeProvider");
        Intrinsics.checkNotNullParameter(functionProvider2, "functionProvider");
        this.name = name2;
        this.dataTypeProvider = dataTypeProvider2;
        this.functionProvider = functionProvider2;
        this.supportsMultipleGeneratedKeys = true;
        this.supportsSelectForUpdate$delegate = LazyKt.lazy(supportsSelectForUpdate.2.INSTANCE);
        this.columnConstraintsCache = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DataTypeProvider getDataTypeProvider() {
        return this.dataTypeProvider;
    }

    @Override
    @NotNull
    public FunctionProvider getFunctionProvider() {
        return this.functionProvider;
    }

    @NotNull
    protected final IdentifierManagerApi getIdentifierManager() {
        return TransactionManager.Companion.current().getDb().getIdentifierManager();
    }

    @NotNull
    public final List<String> getAllTablesNames() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        return (List)connection.metadata((Function1)new Function1<ExposedDatabaseMetadata, List<? extends String>>(this){
            final /* synthetic */ VendorDialect this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter($this$metadata, "$this$metadata");
                return $this$metadata.tableNamesByCurrentSchema(this.this$0.getAllTableNamesCache()).getTableNames();
            }
        });
    }

    @NotNull
    protected final Map<String, List<String>> getAllTableNamesCache() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        if (this._allTableNames == null) {
            this._allTableNames = (Map)connection.metadata(getAllTableNamesCache.1.INSTANCE);
        }
        Map<String, List<String>> map2 = this._allTableNames;
        Intrinsics.checkNotNull(map2);
        return map2;
    }

    private final List<String> getAllSchemaNamesCache() {
        ExposedConnection<?> connection = TransactionManager.Companion.current().getConnection();
        if (this._allSchemaNames == null) {
            this._allSchemaNames = (List)connection.metadata(getAllSchemaNamesCache.1.INSTANCE);
        }
        List<String> list = this._allSchemaNames;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    @NotNull
    public String getDatabase() {
        return this.catalog(TransactionManager.Companion.current());
    }

    @Override
    @NotNull
    public List<String> allTablesNames() {
        return (List)TransactionManager.Companion.current().getConnection().metadata(allTablesNames.2.INSTANCE);
    }

    @Override
    public boolean tableExists(@NotNull Table table) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter(table, "table");
            String string = table.getSchemaName();
            if (string != null) {
                String schema = string;
                boolean bl2 = false;
                Iterable $this$any$iv = MapsKt.getValue(this.getAllTableNamesCache(), DatabaseDialectKt.inProperCase(schema));
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it, table.nameInDatabaseCase())) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                VendorDialect $this$tableExists_u24lambda_u243 = this;
                boolean bl4 = false;
                SchemaMetadata schemaMetadata = (SchemaMetadata)TransactionManager.Companion.current().getConnection().metadata((Function1)new Function1<ExposedDatabaseMetadata, SchemaMetadata>($this$tableExists_u24lambda_u243){
                    final /* synthetic */ VendorDialect $this_run;
                    {
                        this.$this_run = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final SchemaMetadata invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                        Intrinsics.checkNotNullParameter($this$metadata, "$this$metadata");
                        return $this$metadata.tableNamesByCurrentSchema(this.$this_run.getAllTableNamesCache());
                    }
                });
                String schema = schemaMetadata.component1();
                List<String> allTables = schemaMetadata.component2();
                Iterable $this$any$iv = allTables;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl5 = false;
                        if (!$this$tableExists_u24lambda_u243.metadataMatchesTable(it, schema, table)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected boolean metadataMatchesTable(@NotNull String $this$metadataMatchesTable, @NotNull String schema, @NotNull Table table) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$metadataMatchesTable, "<this>");
        Intrinsics.checkNotNullParameter(schema, "schema");
        Intrinsics.checkNotNullParameter(table, "table");
        if (((CharSequence)schema).length() == 0) {
            bl = Intrinsics.areEqual($this$metadataMatchesTable, table.nameInDatabaseCaseUnquoted());
        } else {
            String sanitizedTableName = table.getTableNameWithoutSchemeSanitized$exposed_core();
            String nameInDb = DatabaseDialectKt.inProperCase(schema + '.' + sanitizedTableName);
            bl = Intrinsics.areEqual($this$metadataMatchesTable, nameInDb);
        }
        return bl;
    }

    @Override
    public boolean schemaExists(@NotNull Schema schema) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(schema, "schema");
            List<String> allSchemas = this.getAllSchemaNamesCache();
            Iterable $this$any$iv = allSchemas;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it, DatabaseDialectKt.inProperCase(schema.getIdentifier()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Map<Table, List<ColumnMetadata>> tableColumns(Table ... tables) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        return (Map)TransactionManager.Companion.current().getConnection().metadata((Function1)new Function1<ExposedDatabaseMetadata, Map<Table, ? extends List<? extends ColumnMetadata>>>(tables){
            final /* synthetic */ Table[] $tables;
            {
                this.$tables = $tables;
                super(1);
            }

            @NotNull
            public final Map<Table, List<ColumnMetadata>> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter($this$metadata, "$this$metadata");
                return $this$metadata.columns(Arrays.copyOf(this.$tables, this.$tables.length));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Pair<Table, LinkedHashSet<Column<?>>>, List<ForeignKeyConstraint>> columnConstraints(Table ... tables) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        HashMap constraints = new HashMap();
        Table[] $this$filter$iv = tables;
        boolean $i$f$filter = false;
        Table[] tableArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Iterable element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(!this.columnConstraintsCache.containsKey(it.nameInDatabaseCaseUnquoted()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tablesToLoad = (List)destination$iv$iv;
        this.fillConstraintCacheForTables(tablesToLoad);
        Table[] $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            void $this$forEach$iv2;
            Table element$iv;
            Iterable element$iv$iv;
            Table table = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Collection collection = this.columnConstraintsCache.get(table.nameInDatabaseCaseUnquoted());
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            element$iv$iv = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                void $this$getOrPut$iv;
                ForeignKeyConstraint it = (ForeignKeyConstraint)element$iv2;
                boolean bl2 = false;
                Map map2 = constraints;
                Pair<Table, LinkedHashSet<Column<?>>> key$iv = TuplesKt.to(table, it.getFrom());
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(it);
            }
        }
        return constraints;
    }

    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_core((Function1)new Function1<ExposedDatabaseMetadata, Map<Table, ? extends List<? extends Index>>>(tables){
            final /* synthetic */ Table[] $tables;
            {
                this.$tables = $tables;
                super(1);
            }

            @NotNull
            public final Map<Table, List<Index>> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter($this$metadata, "$this$metadata");
                return $this$metadata.existingIndices(Arrays.copyOf(this.$tables, this.$tables.length));
            }
        });
    }

    @Override
    @NotNull
    public Map<Table, PrimaryKeyMetadata> existingPrimaryKeys(Table ... tables) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        return (Map)TransactionManager.Companion.current().getDb().metadata$exposed_core((Function1)new Function1<ExposedDatabaseMetadata, Map<Table, ? extends PrimaryKeyMetadata>>(tables){
            final /* synthetic */ Table[] $tables;
            {
                this.$tables = $tables;
                super(1);
            }

            @NotNull
            public final Map<Table, PrimaryKeyMetadata> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter($this$metadata, "$this$metadata");
                return $this$metadata.existingPrimaryKeys(Arrays.copyOf(this.$tables, this.$tables.length));
            }
        });
    }

    private final boolean getSupportsSelectForUpdate() {
        Lazy lazy = this.supportsSelectForUpdate$delegate;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return this.getSupportsSelectForUpdate();
    }

    @NotNull
    protected final String quoteIdentifierWhenWrongCaseOrNecessary(@NotNull String $this$quoteIdentifierWhenWrongCaseOrNecessary, @NotNull Transaction tr) {
        Intrinsics.checkNotNullParameter($this$quoteIdentifierWhenWrongCaseOrNecessary, "<this>");
        Intrinsics.checkNotNullParameter(tr, "tr");
        return tr.getDb().getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary($this$quoteIdentifierWhenWrongCaseOrNecessary);
    }

    @NotNull
    protected final Map<String, Collection<ForeignKeyConstraint>> getColumnConstraintsCache() {
        return this.columnConstraintsCache;
    }

    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        this.columnConstraintsCache.putAll((Map)TransactionManager.Companion.current().getDb().metadata$exposed_core((Function1)new Function1<ExposedDatabaseMetadata, Map<String, ? extends List<? extends ForeignKeyConstraint>>>(tables){
            final /* synthetic */ List<Table> $tables;
            {
                this.$tables = $tables;
                super(1);
            }

            @NotNull
            public final Map<String, List<ForeignKeyConstraint>> invoke(@NotNull ExposedDatabaseMetadata $this$metadata) {
                Intrinsics.checkNotNullParameter($this$metadata, "$this$metadata");
                return $this$metadata.tableConstraints(this.$tables);
            }
        }));
    }

    @Override
    public void resetCaches() {
        this._allTableNames = null;
        this.columnConstraintsCache.clear();
        TransactionManager.Companion.current().getDb().metadata$exposed_core(resetCaches.1.INSTANCE);
    }

    @Override
    public void resetSchemaCaches() {
        this._allSchemaNames = null;
        this.resetCaches();
    }

    @Nullable
    public final String filterCondition(@NotNull Index index) {
        Op<Boolean> op;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(index, "index");
                op = index.getFilterCondition();
                if (op == null) break block4;
                Op<Boolean> it = op;
                boolean bl = false;
                DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
                if (!((databaseDialect instanceof PostgreSQLDialect ? true : databaseDialect instanceof SQLServerDialect) ? true : databaseDialect instanceof SQLiteDialect)) {
                    SQLLogKt.getExposedLogger().warn("Index creation with a filter condition is not supported in " + DatabaseDialectKt.getCurrentDialect().getName());
                    return null;
                }
                String string = new QueryBuilder(false).append(" WHERE ").append((Expression)it).toString();
                op = string;
                if (string != null) break block5;
            }
            op = "";
        }
        return op;
    }

    private final String indexFunctionToString(Function<?> function) {
        String string;
        String baseString = function.toString();
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        if (databaseDialect instanceof SQLiteDialect ? true : databaseDialect instanceof OracleDialect) {
            CharSequence charSequence = baseString;
            Regex regex = new Regex("^*[^( ]*\\.");
            String string2 = "";
            string = regex.replace(charSequence, string2);
        } else {
            string = databaseDialect instanceof MysqlDialect ? (StringsKt.first(baseString) != '(' ? '(' + baseString + ')' : baseString) : baseString;
        }
        return string;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter(index, "index");
        Transaction t = TransactionManager.Companion.current();
        String quotedTableName = t.identity(index.getTable());
        String quotedIndexName = t.getDb().getIdentifierManager().cutIfNecessaryAndQuote(index.getIndexName());
        List<ExpressionWithColumnType<?>> list = index.getFunctions();
        List keyFields = CollectionsKt.plus((Collection)index.getColumns(), list != null ? (Iterable)list : (Iterable)CollectionsKt.emptyList());
        String fieldsList2 = CollectionsKt.joinToString$default(keyFields, null, "(", ")", 0, null, new Function1<ExpressionWithColumnType<?>, CharSequence>(t, this){
            final /* synthetic */ Transaction $t;
            final /* synthetic */ VendorDialect this$0;
            {
                this.$t = $t;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull ExpressionWithColumnType<?> it) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter(it, "it");
                ExpressionWithColumnType<?> expressionWithColumnType = it;
                if (expressionWithColumnType instanceof Column) {
                    charSequence = this.$t.identity((Column)it);
                } else if (expressionWithColumnType instanceof Function) {
                    charSequence = VendorDialect.access$indexFunctionToString(this.this$0, (Function)it);
                } else if (expressionWithColumnType instanceof LiteralOp) {
                    char[] cArray = new char[]{'\"'};
                    charSequence = StringsKt.trim(String.valueOf(((LiteralOp)it).getValue()), cArray);
                } else {
                    SQLLogKt.getExposedLogger().warn("Unexpected defining key field will be passed as String: " + it);
                    charSequence = it.toString();
                }
                return charSequence;
            }
        }, 25, null);
        List<ExpressionWithColumnType<?>> list2 = index.getFunctions();
        boolean includesOnlyColumns = !(list2 != null ? !list2.isEmpty() : false);
        String string = this.filterCondition(index);
        if (string == null) {
            return "";
        }
        String maybeFilterCondition = string;
        return index.getUnique() && ((CharSequence)maybeFilterCondition).length() == 0 && includesOnlyColumns ? "ALTER TABLE " + quotedTableName + " ADD CONSTRAINT " + quotedIndexName + " UNIQUE " + fieldsList2 : (index.getUnique() ? "CREATE UNIQUE INDEX " + quotedIndexName + " ON " + quotedTableName + ' ' + fieldsList2 + maybeFilterCondition : (index.getIndexType() != null ? this.createIndexWithType(quotedIndexName, quotedTableName, fieldsList2, index.getIndexType(), maybeFilterCondition) : "CREATE INDEX " + quotedIndexName + " ON " + quotedTableName + ' ' + fieldsList2 + maybeFilterCondition));
    }

    @NotNull
    protected String createIndexWithType(@NotNull String name2, @NotNull String table, @NotNull String columns2, @NotNull String type2, @NotNull String filterCondition) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(filterCondition, "filterCondition");
        return "CREATE INDEX " + name2 + " ON " + table + ' ' + columns2 + " USING " + type2 + filterCondition;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(indexName2, "indexName");
        return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP CONSTRAINT " + this.getIdentifierManager().quoteIfNecessary(indexName2);
    }

    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, @NotNull ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter(column, "column");
        Intrinsics.checkNotNullParameter(columnDiff, "columnDiff");
        return CollectionsKt.listOf("ALTER TABLE " + TransactionManager.Companion.current().identity(column.getTable()) + " MODIFY COLUMN " + column.descriptionDdl(true));
    }

    @Override
    @NotNull
    public String addPrimaryKey(@NotNull Table table, @Nullable String pkName, Column<?> ... pkColumns) {
        String string;
        String columns2;
        Transaction transaction2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(table, "table");
                Intrinsics.checkNotNullParameter(pkColumns, "pkColumns");
                transaction2 = TransactionManager.Companion.current();
                columns2 = ArraysKt.joinToString$default(pkColumns, null, (CharSequence)"(", (CharSequence)")", 0, null, new Function1<Column<?>, CharSequence>(transaction2){
                    final /* synthetic */ Transaction $transaction;
                    {
                        this.$transaction = $transaction;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Column<?> it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$transaction.identity(it);
                    }
                }, 25, null);
                string = pkName;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = " CONSTRAINT " + this.getIdentifierManager().quoteIfNecessary(it) + ' ';
                string = string2;
                if (string2 != null) break block3;
            }
            string = " ";
        }
        String constraint = string;
        return "ALTER TABLE " + transaction2.identity(table) + " ADD" + constraint + "PRIMARY KEY " + columns2;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return DatabaseDialect.DefaultImpls.getSupportsIfNotExists(this);
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return DatabaseDialect.DefaultImpls.getSupportsCreateSequence(this);
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return DatabaseDialect.DefaultImpls.getNeedsSequenceToAutoInc(this);
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return DatabaseDialect.DefaultImpls.getDefaultReferenceOption(this);
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return DatabaseDialect.DefaultImpls.getNeedsQuotesWhenSymbolsInNames(this);
    }

    @Override
    public boolean getSupportsSequenceAsGeneratedKeys() {
        return DatabaseDialect.DefaultImpls.getSupportsSequenceAsGeneratedKeys(this);
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return DatabaseDialect.DefaultImpls.getSupportsOnlyIdentifiersInGeneratedKeys(this);
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        return DatabaseDialect.DefaultImpls.getSupportsTernaryAffectedRowValues(this);
    }

    @Override
    public boolean getSupportsCreateSchema() {
        return DatabaseDialect.DefaultImpls.getSupportsCreateSchema(this);
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return DatabaseDialect.DefaultImpls.getSupportsSubqueryUnions(this);
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return DatabaseDialect.DefaultImpls.getSupportsDualTableConcept(this);
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return DatabaseDialect.DefaultImpls.getSupportsOrderByNullsFirstLast(this);
    }

    @Override
    public boolean getSupportsWindowFrameGroupsMode() {
        return DatabaseDialect.DefaultImpls.getSupportsWindowFrameGroupsMode(this);
    }

    @Override
    public boolean getSupportsOnUpdate() {
        return DatabaseDialect.DefaultImpls.getSupportsOnUpdate(this);
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return DatabaseDialect.DefaultImpls.getSupportsSetDefaultReferenceOption(this);
    }

    @Override
    public boolean getSupportsRestrictReferenceOption() {
        return DatabaseDialect.DefaultImpls.getSupportsRestrictReferenceOption(this);
    }

    @Override
    @NotNull
    public Map<Character, Character> getLikePatternSpecialChars() {
        return DatabaseDialect.DefaultImpls.getLikePatternSpecialChars(this);
    }

    @Override
    public boolean getRequiresAutoCommitOnCreateDrop() {
        return DatabaseDialect.DefaultImpls.getRequiresAutoCommitOnCreateDrop(this);
    }

    @Override
    public boolean checkTableMapping(@NotNull Table table) {
        return DatabaseDialect.DefaultImpls.checkTableMapping(this, table);
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        return DatabaseDialect.DefaultImpls.isAllowedAsColumnDefault(this, e);
    }

    @Override
    @NotNull
    public String catalog(@NotNull Transaction transaction2) {
        return DatabaseDialect.DefaultImpls.catalog(this, transaction2);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name2) {
        return DatabaseDialect.DefaultImpls.createDatabase(this, name2);
    }

    @Override
    @NotNull
    public String listDatabases() {
        return DatabaseDialect.DefaultImpls.listDatabases(this);
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name2) {
        return DatabaseDialect.DefaultImpls.dropDatabase(this, name2);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        return DatabaseDialect.DefaultImpls.setSchema(this, schema);
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        return DatabaseDialect.DefaultImpls.createSchema(this, schema);
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        return DatabaseDialect.DefaultImpls.dropSchema(this, schema, cascade);
    }

    @Override
    @NotNull
    public ReferenceOption resolveRefOptionFromJdbc(int refOption) {
        return DatabaseDialect.DefaultImpls.resolveRefOptionFromJdbc(this, refOption);
    }

    public static final /* synthetic */ String access$indexFunctionToString(VendorDialect $this, Function function) {
        return $this.indexFunctionToString(function);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "", "dialectName", "", "(Ljava/lang/String;)V", "getDialectName", "()Ljava/lang/String;", "exposed-core"})
    public static abstract class DialectNameProvider {
        @NotNull
        private final String dialectName;

        public DialectNameProvider(@NotNull String dialectName) {
            Intrinsics.checkNotNullParameter(dialectName, "dialectName");
            this.dialectName = dialectName;
        }

        @NotNull
        public final String getDialectName() {
            return this.dialectName;
        }
    }
}

