/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.serializers.LocalTimeIso8601Serializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=LocalTimeIso8601Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001eB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lkotlinx/datetime/LocalTime;", "", "hour", "", "minute", "second", "nanosecond", "(IIII)V", "value", "Ljava/time/LocalTime;", "(Ljava/time/LocalTime;)V", "getHour", "()I", "getMinute", "getNanosecond", "getSecond", "getValue$kotlinx_datetime", "()Ljava/time/LocalTime;", "compareTo", "other", "equals", "", "", "hashCode", "toMillisecondOfDay", "toNanosecondOfDay", "", "toSecondOfDay", "toString", "", "Companion", "kotlinx-datetime"})
public final class LocalTime
implements Comparable<LocalTime> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.LocalTime value;
    @NotNull
    private static final LocalTime MIN;
    @NotNull
    private static final LocalTime MAX;

    public LocalTime(@NotNull java.time.LocalTime value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
    }

    @NotNull
    public final java.time.LocalTime getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalTime(int hour, int minute, int second2, int nanosecond) {
        java.time.LocalTime localTime;
        LocalTime localTime2;
        LocalTime localTime3 = this;
        try {
            localTime2 = localTime3;
            localTime = java.time.LocalTime.of(hour, minute, second2, nanosecond);
        }
        catch (DateTimeException dateTimeException) {
            void e;
            LocalTime localTime4 = localTime3;
            throw new IllegalArgumentException((Throwable)e);
        }
        java.time.LocalTime localTime5 = localTime;
        Intrinsics.checkNotNull(localTime5);
        localTime2(localTime5);
    }

    public /* synthetic */ LocalTime(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, n4);
    }

    public final int getHour() {
        return this.value.getHour();
    }

    public final int getMinute() {
        return this.value.getMinute();
    }

    public final int getSecond() {
        return this.value.getSecond();
    }

    public final int getNanosecond() {
        return this.value.getNano();
    }

    public final int toSecondOfDay() {
        return this.value.toSecondOfDay();
    }

    public final int toMillisecondOfDay() {
        return (int)(this.value.toNanoOfDay() / (long)1000000);
    }

    public final long toNanosecondOfDay() {
        return this.value.toNanoOfDay();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof LocalTime && Intrinsics.areEqual(this.value, ((LocalTime)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public int compareTo(@NotNull LocalTime other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.value.compareTo(other.value);
    }

    static {
        java.time.LocalTime localTime = java.time.LocalTime.MIN;
        Intrinsics.checkNotNullExpressionValue(localTime, "MIN");
        MIN = new LocalTime(localTime);
        java.time.LocalTime localTime2 = java.time.LocalTime.MAX;
        Intrinsics.checkNotNullExpressionValue(localTime2, "MAX");
        MAX = new LocalTime(localTime2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u00c6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lkotlinx/datetime/LocalTime$Companion;", "", "()V", "MAX", "Lkotlinx/datetime/LocalTime;", "getMAX$kotlinx_datetime", "()Lkotlinx/datetime/LocalTime;", "MIN", "getMIN$kotlinx_datetime", "fromMillisecondOfDay", "millisecondOfDay", "", "fromNanosecondOfDay", "nanosecondOfDay", "", "fromSecondOfDay", "secondOfDay", "parse", "isoString", "", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    @SourceDebugExtension(value={"SMAP\nLocalTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTime.kt\nkotlinx/datetime/LocalTime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalTime parse(@NotNull String isoString) {
            LocalTime localTime;
            Intrinsics.checkNotNullParameter(isoString, "isoString");
            try {
                java.time.LocalTime p0 = java.time.LocalTime.parse(isoString);
                boolean bl = false;
                localTime = new LocalTime(p0);
            }
            catch (DateTimeParseException e) {
                throw new DateTimeFormatException(e);
            }
            return localTime;
        }

        @NotNull
        public final LocalTime fromSecondOfDay(int secondOfDay) {
            LocalTime localTime;
            try {
                java.time.LocalTime p0 = java.time.LocalTime.ofSecondOfDay(secondOfDay);
                boolean bl = false;
                localTime = new LocalTime(p0);
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
            return localTime;
        }

        @NotNull
        public final LocalTime fromMillisecondOfDay(int millisecondOfDay) {
            LocalTime localTime;
            try {
                java.time.LocalTime p0 = java.time.LocalTime.ofNanoOfDay((long)millisecondOfDay * 1000000L);
                boolean bl = false;
                localTime = new LocalTime(p0);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
            return localTime;
        }

        @NotNull
        public final LocalTime fromNanosecondOfDay(long nanosecondOfDay) {
            LocalTime localTime;
            try {
                java.time.LocalTime p0 = java.time.LocalTime.ofNanoOfDay(nanosecondOfDay);
                boolean bl = false;
                localTime = new LocalTime(p0);
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
            return localTime;
        }

        @NotNull
        public final LocalTime getMIN$kotlinx_datetime() {
            return MIN;
        }

        @NotNull
        public final LocalTime getMAX$kotlinx_datetime() {
            return MAX;
        }

        @NotNull
        public final KSerializer<LocalTime> serializer() {
            return LocalTimeIso8601Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

