/*
 * Decompiled with CFR 0.152.
 */
package me.okonecny.wysiwyg;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import me.okonecny.wysiwyg.SourceEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B)\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0004J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u001c\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010 \u001a\u00020\u0000J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\u0006\u0010#\u001a\u00020\u0000R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006$"}, d2={"Lme/okonecny/wysiwyg/UndoManager;", "", "stack", "", "Lme/okonecny/wysiwyg/SourceEditor;", "undoSteps", "", "maxCapacity", "(Ljava/util/List;II)V", "currentHistory", "getCurrentHistory", "()Lme/okonecny/wysiwyg/SourceEditor;", "currentHistoryIndex", "getCurrentHistoryIndex", "()I", "hasHistory", "", "getHasHistory", "()Z", "getMaxCapacity", "getStack", "()Ljava/util/List;", "getUndoSteps", "add", "newHistory", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "redo", "toString", "", "undo", "interactive-text"})
@StabilityInferred(parameters=0)
public final class UndoManager {
    @NotNull
    private final List<SourceEditor> stack;
    private final int undoSteps;
    private final int maxCapacity;
    public static final int $stable = 8;

    public UndoManager(@NotNull List<SourceEditor> stack, int undoSteps, int maxCapacity) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        this.stack = stack;
        this.undoSteps = undoSteps;
        this.maxCapacity = maxCapacity;
    }

    public /* synthetic */ UndoManager(List list, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 100;
        }
        this(list, n, n2);
    }

    @NotNull
    public final List<SourceEditor> getStack() {
        return this.stack;
    }

    public final int getUndoSteps() {
        return this.undoSteps;
    }

    public final int getMaxCapacity() {
        return this.maxCapacity;
    }

    public final boolean getHasHistory() {
        return !((Collection)this.stack).isEmpty();
    }

    public final int getCurrentHistoryIndex() {
        return CollectionsKt.getLastIndex(this.stack) - this.undoSteps;
    }

    @NotNull
    public final SourceEditor getCurrentHistory() {
        return this.stack.get(this.getCurrentHistoryIndex());
    }

    @NotNull
    public final UndoManager add(@NotNull SourceEditor newHistory) {
        UndoManager undoManager;
        Intrinsics.checkNotNullParameter((Object)newHistory, (String)"newHistory");
        if (!((Collection)this.stack).isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.last(this.stack), (Object)newHistory)) {
            undoManager = this;
        } else {
            List undoneStack = CollectionsKt.slice(this.stack, (IntRange)new IntRange(0, this.getCurrentHistoryIndex()));
            List trimmedStack = undoneStack.size() >= this.maxCapacity ? CollectionsKt.slice(this.stack, (IntRange)new IntRange(undoneStack.size() - this.maxCapacity, CollectionsKt.getLastIndex((List)undoneStack))) : undoneStack;
            undoManager = UndoManager.copy$default(this, CollectionsKt.plus((Collection)trimmedStack, (Object)newHistory), 0, 0, 4, null);
        }
        return undoManager;
    }

    @NotNull
    public final UndoManager undo() {
        return this.undoSteps >= CollectionsKt.getLastIndex(this.stack) ? this : UndoManager.copy$default(this, null, this.undoSteps + 1, 0, 5, null);
    }

    @NotNull
    public final UndoManager redo() {
        return this.undoSteps <= 0 ? this : UndoManager.copy$default(this, null, this.undoSteps - 1, 0, 5, null);
    }

    @NotNull
    public final List<SourceEditor> component1() {
        return this.stack;
    }

    public final int component2() {
        return this.undoSteps;
    }

    public final int component3() {
        return this.maxCapacity;
    }

    @NotNull
    public final UndoManager copy(@NotNull List<SourceEditor> stack, int undoSteps, int maxCapacity) {
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        return new UndoManager(stack, undoSteps, maxCapacity);
    }

    public static /* synthetic */ UndoManager copy$default(UndoManager undoManager, List list, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            list = undoManager.stack;
        }
        if ((n3 & 2) != 0) {
            n = undoManager.undoSteps;
        }
        if ((n3 & 4) != 0) {
            n2 = undoManager.maxCapacity;
        }
        return undoManager.copy(list, n, n2);
    }

    @NotNull
    public String toString() {
        return "UndoManager(stack=" + this.stack + ", undoSteps=" + this.undoSteps + ", maxCapacity=" + this.maxCapacity + ")";
    }

    public int hashCode() {
        int result = ((Object)this.stack).hashCode();
        result = result * 31 + Integer.hashCode(this.undoSteps);
        result = result * 31 + Integer.hashCode(this.maxCapacity);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UndoManager)) {
            return false;
        }
        UndoManager undoManager = (UndoManager)other;
        if (!Intrinsics.areEqual(this.stack, undoManager.stack)) {
            return false;
        }
        if (this.undoSteps != undoManager.undoSteps) {
            return false;
        }
        return this.maxCapacity == undoManager.maxCapacity;
    }

    public UndoManager() {
        this(null, 0, 0, 7, null);
    }
}

