/*
 * Decompiled with CFR 0.152.
 */
package me.okonecny.interactivetext;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.CompositionLocalKt;
import androidx.compose.runtime.ProvidableCompositionLocal;
import androidx.compose.ui.ComposedModifierKt;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.draw.DrawModifierKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathOperation;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.okonecny.interactivetext.InteractiveComponent;
import me.okonecny.interactivetext.InteractiveScope;
import me.okonecny.interactivetext.PaintSelectionModifierKt;
import me.okonecny.interactivetext.Selection;
import me.okonecny.interactivetext.SelectionStyle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u001a#\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\u000bj\u0002`\n\u00a2\u0006\u0002\u0010\f\u001a&\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0015"}, d2={"LocalSelectionStyle", "Landroidx/compose/runtime/ProvidableCompositionLocal;", "Lme/okonecny/interactivetext/SelectionStyle;", "getLocalSelectionStyle", "()Landroidx/compose/runtime/ProvidableCompositionLocal;", "paintSelection", "Landroidx/compose/ui/Modifier;", "interactiveScope", "Lme/okonecny/interactivetext/InteractiveScope;", "interactiveId", "Lme/okonecny/interactivetext/InteractiveId;", "", "(Landroidx/compose/ui/Modifier;Lme/okonecny/interactivetext/InteractiveScope;J)Landroidx/compose/ui/Modifier;", "getFilledPathForRange", "Landroidx/compose/ui/graphics/Path;", "Landroidx/compose/ui/text/TextLayoutResult;", "start", "", "end", "growBy", "", "interactive-text"})
public final class PaintSelectionModifierKt {
    @NotNull
    private static final ProvidableCompositionLocal<SelectionStyle> LocalSelectionStyle = CompositionLocalKt.compositionLocalOf$default(null, PaintSelectionModifierKt::LocalSelectionStyle$lambda$0, (int)1, null);

    @NotNull
    public static final ProvidableCompositionLocal<SelectionStyle> getLocalSelectionStyle() {
        return LocalSelectionStyle;
    }

    @NotNull
    public static final Modifier paintSelection(@NotNull Modifier $this$paintSelection, @NotNull InteractiveScope interactiveScope, long interactiveId) {
        Intrinsics.checkNotNullParameter((Object)$this$paintSelection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)interactiveScope, (String)"interactiveScope");
        return ComposedModifierKt.composed$default((Modifier)$this$paintSelection, null, (Function3)((Function3)new Function3<Modifier, Composer, Integer, Modifier>(interactiveScope, interactiveId){
            final /* synthetic */ InteractiveScope $interactiveScope;
            final /* synthetic */ long $interactiveId;
            {
                this.$interactiveScope = $interactiveScope;
                this.$interactiveId = $interactiveId;
            }

            /*
             * WARNING - void declaration
             */
            @Composable
            public final Modifier invoke(Modifier $this$composed, Composer $composer, int $changed) {
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)$this$composed, (String)"$this$composed");
                $composer.startReplaceableGroup(357128866);
                CompositionLocal compositionLocal = (CompositionLocal)PaintSelectionModifierKt.getLocalSelectionStyle();
                int $changed$iv = 6;
                boolean $i$f$getCurrent = false;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)2023513938, (String)"CC:CompositionLocal.kt#9igjgp");
                Object object = $composer.consume((CompositionLocal)this_$iv);
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                SelectionStyle selectionStyle = (SelectionStyle)object;
                compositionLocal = DrawModifierKt.drawWithContent((Modifier)$this$composed, arg_0 -> paintSelection.1.invoke$lambda$0(this.$interactiveScope, this.$interactiveId, selectionStyle, arg_0));
                $composer.endReplaceableGroup();
                return compositionLocal;
            }

            private static final Unit invoke$lambda$0(InteractiveScope $interactiveScope, long $interactiveId, SelectionStyle $selectionStyle, ContentDrawScope $this$drawWithContent) {
                Intrinsics.checkNotNullParameter((Object)$interactiveScope, (String)"$interactiveScope");
                Intrinsics.checkNotNullParameter((Object)$selectionStyle, (String)"$selectionStyle");
                Intrinsics.checkNotNullParameter((Object)$this$drawWithContent, (String)"$this$drawWithContent");
                Selection selection = $interactiveScope.getSelection();
                if (selection.isEmpty() || !$interactiveScope.isPlaced() || !$interactiveScope.hasComponent($interactiveId) || !$interactiveScope.isComponentBetween($interactiveId, selection.getStart().getComponentId(), selection.getEnd().getComponentId())) {
                    $this$drawWithContent.drawContent();
                    return Unit.INSTANCE;
                }
                InteractiveComponent component = $interactiveScope.getComponent($interactiveId);
                TextLayoutResult textLayout = component.getTextLayoutResult();
                LayoutCoordinates componentCoordinates = component.getAttachedLayoutCoordinates();
                if (textLayout == null || componentCoordinates == null) {
                    $this$drawWithContent.drawContent();
                    return Unit.INSTANCE;
                }
                int selectionStart = selection.getStart().getComponentId() == $interactiveId ? selection.getStart().getVisualOffset() : 0;
                AnnotatedString text = textLayout.getLayoutInput().getText();
                int selectionEnd = selection.getEnd().getComponentId() == $interactiveId ? RangesKt.coerceAtMost((int)selection.getEnd().getVisualOffset(), (int)text.length()) : text.length();
                Path componentSelectionPath = PaintSelectionModifierKt.access$getFilledPathForRange(textLayout, selectionStart, selectionEnd, 0.0f);
                $this$drawWithContent.drawContent();
                DrawScope.drawPath-LG529CI$default((DrawScope)((DrawScope)$this$drawWithContent), (Path)componentSelectionPath, (long)$selectionStyle.getFillColor-0d7_KjU(), (float)0.0f, null, null, (int)0, (int)60, null);
                return Unit.INSTANCE;
            }
        }), (int)1, null);
    }

    private static final Path getFilledPathForRange(TextLayoutResult $this$getFilledPathForRange, int start, int end, float growBy) {
        if (!((0 <= start ? start <= end : false) && end <= $this$getFilledPathForRange.getLayoutInput().getText().length())) {
            boolean $i$a$-require-PaintSelectionModifierKt$getFilledPathForRange$22 = false;
            String $i$a$-require-PaintSelectionModifierKt$getFilledPathForRange$22 = "Start(" + start + ") or End(" + end + ") is out of range [0.." + $this$getFilledPathForRange.getLayoutInput().getText().length() + "), or start > end!";
            throw new IllegalArgumentException($i$a$-require-PaintSelectionModifierKt$getFilledPathForRange$22.toString());
        }
        if (start == end) {
            return SkiaBackedPath_skikoKt.Path();
        }
        Path closedPath = SkiaBackedPath_skikoKt.Path();
        for (int characterPos = start; characterPos < end; ++characterPos) {
            Path characterBox = SkiaBackedPath_skikoKt.Path();
            int lineNo = $this$getFilledPathForRange.getLineForOffset(characterPos);
            float lineTop = $this$getFilledPathForRange.getLineTop(lineNo);
            float lineBottom = $this$getFilledPathForRange.getLineBottom(lineNo);
            Rect charBounds = $this$getFilledPathForRange.getBoundingBox(characterPos);
            characterBox.addRect(new Rect(charBounds.getLeft() - growBy, lineTop - growBy, charBounds.getRight() + growBy, lineBottom + growBy));
            closedPath = Path.Companion.combine-xh6zSI8(PathOperation.Companion.getUnion-b3I0S0c(), closedPath, characterBox);
        }
        return closedPath;
    }

    static /* synthetic */ Path getFilledPathForRange$default(TextLayoutResult textLayoutResult, int n, int n2, float f, int n3, Object object) {
        if ((n3 & 4) != 0) {
            f = 1.0f;
        }
        return PaintSelectionModifierKt.getFilledPathForRange(textLayoutResult, n, n2, f);
    }

    private static final SelectionStyle LocalSelectionStyle$lambda$0() {
        return new SelectionStyle(0L, null, 3, null);
    }

    public static final /* synthetic */ Path access$getFilledPathForRange(TextLayoutResult $receiver, int start, int end, float growBy) {
        return PaintSelectionModifierKt.getFilledPathForRange($receiver, start, end, growBy);
    }
}

