/*
 * Decompiled with CFR 0.152.
 */
package me.okonecny.markdowneditor.toolbar;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.util.ast.Block;
import java.util.Arrays;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import me.okonecny.markdowneditor.toolbar.ParagraphStyle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u001f\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J#\u0010\n\u001a\u00020\u00062\u0016\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\f\"\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lme/okonecny/markdowneditor/toolbar/ParagraphStyle;", "", "nodeType", "Lkotlin/reflect/KClass;", "Lcom/vladsch/flexmark/util/ast/Block;", "descriptionFormat", "", "(Ljava/lang/String;ILkotlin/reflect/KClass;Ljava/lang/String;)V", "getNodeType", "()Lkotlin/reflect/KClass;", "description", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "HEADING", "FENCED_CODE_BLOCK", "BLOCK_QUOTE", "PARAGRAPH", "Companion", "markdown-editor"})
final class ParagraphStyle
extends Enum<ParagraphStyle> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final KClass<? extends Block> nodeType;
    @NotNull
    private final String descriptionFormat;
    @NotNull
    private static final Lazy<Set<ParagraphStyle>> allowedParagraphStyles$delegate;
    @NotNull
    private static final Lazy<Set<KClass<? extends Block>>> allowedNodeTypes$delegate;
    public static final /* enum */ ParagraphStyle HEADING;
    public static final /* enum */ ParagraphStyle FENCED_CODE_BLOCK;
    public static final /* enum */ ParagraphStyle BLOCK_QUOTE;
    public static final /* enum */ ParagraphStyle PARAGRAPH;
    private static final /* synthetic */ ParagraphStyle[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private ParagraphStyle(KClass<? extends Block> nodeType, String descriptionFormat) {
        this.nodeType = nodeType;
        this.descriptionFormat = descriptionFormat;
    }

    @NotNull
    public final KClass<? extends Block> getNodeType() {
        return this.nodeType;
    }

    @NotNull
    public final String description(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(this.descriptionFormat, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static ParagraphStyle[] values() {
        return (ParagraphStyle[])$VALUES.clone();
    }

    public static ParagraphStyle valueOf(String value) {
        return Enum.valueOf(ParagraphStyle.class, value);
    }

    @NotNull
    public static EnumEntries<ParagraphStyle> getEntries() {
        return $ENTRIES;
    }

    static {
        HEADING = new ParagraphStyle((KClass<? extends Block>)Reflection.getOrCreateKotlinClass(Heading.class), "Heading %s");
        FENCED_CODE_BLOCK = new ParagraphStyle((KClass<? extends Block>)Reflection.getOrCreateKotlinClass(FencedCodeBlock.class), "Code Block");
        BLOCK_QUOTE = new ParagraphStyle((KClass<? extends Block>)Reflection.getOrCreateKotlinClass(BlockQuote.class), "Quoted Text");
        PARAGRAPH = new ParagraphStyle((KClass<? extends Block>)Reflection.getOrCreateKotlinClass(Paragraph.class), "Paragraph");
        $VALUES = paragraphStyleArray = new ParagraphStyle[]{ParagraphStyle.HEADING, ParagraphStyle.FENCED_CODE_BLOCK, ParagraphStyle.BLOCK_QUOTE, ParagraphStyle.PARAGRAPH};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        allowedParagraphStyles$delegate = LazyKt.lazy((Function0)Companion.allowedParagraphStyles.2.INSTANCE);
        allowedNodeTypes$delegate = LazyKt.lazy((Function0)Companion.allowedNodeTypes.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006R)\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0011"}, d2={"Lme/okonecny/markdowneditor/toolbar/ParagraphStyle$Companion;", "", "()V", "allowedNodeTypes", "", "Lkotlin/reflect/KClass;", "Lcom/vladsch/flexmark/util/ast/Block;", "getAllowedNodeTypes", "()Ljava/util/Set;", "allowedNodeTypes$delegate", "Lkotlin/Lazy;", "allowedParagraphStyles", "Lme/okonecny/markdowneditor/toolbar/ParagraphStyle;", "getAllowedParagraphStyles", "allowedParagraphStyles$delegate", "forNode", "node", "markdown-editor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ParagraphStyle forNode(@NotNull Block node) {
            ParagraphStyle paragraphStyle;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Block block = node;
            if (block instanceof Heading) {
                paragraphStyle = HEADING;
            } else if (block instanceof FencedCodeBlock) {
                paragraphStyle = FENCED_CODE_BLOCK;
            } else if (block instanceof BlockQuote) {
                paragraphStyle = BLOCK_QUOTE;
            } else if (block instanceof Paragraph) {
                paragraphStyle = PARAGRAPH;
            } else {
                throw new IllegalArgumentException("Unknown node type.");
            }
            return paragraphStyle;
        }

        @NotNull
        public final Set<ParagraphStyle> getAllowedParagraphStyles() {
            Lazy lazy = allowedParagraphStyles$delegate;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final Set<KClass<? extends Block>> getAllowedNodeTypes() {
            Lazy lazy = allowedNodeTypes$delegate;
            return (Set)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

