package me.okonecny.markdowneditor.`internal`

import io.ktor.client.HttpClient
import kotlin.reflect.KClass
import me.okonecny.markdowneditor.DocumentParser
import me.tatarka.inject.`internal`.LazyMap
import me.tatarka.inject.`internal`.ScopedComponent

internal fun KClass<MarkdownEditorComponent>.create(): MarkdownEditorComponent =
    InjectMarkdownEditorComponent()

internal class InjectMarkdownEditorComponent() : MarkdownEditorComponent(), ScopedComponent {
  override val _scoped: LazyMap = LazyMap()

  override val documentParser: DocumentParser
    get() = DocumentParser(
      flexmarkParser = _scoped.get("com.vladsch.flexmark.parser.Parser") {
        flexmarkParser()
      },
      headerIdGenerator = _scoped.get("com.vladsch.flexmark.html.renderer.HeaderIdGenerator") {
        headerIdGenerator()
      }
    )

  override val httpClient: HttpClient
    get() = _scoped.get("io.ktor.client.HttpClient") {
      httpClient()
    }

  override val imageLoader: ImageLoader
    get() = _scoped.get("me.okonecny.markdowneditor.`internal`.ImageLoader") {
      ImageLoader(
        lazyHttpClient = lazy {
          httpClient
        }
      )
    }
}
