/*
 * Decompiled with CFR 0.152.
 */
package me.okonecny.markdowneditor.autocomplete;

import androidx.compose.foundation.layout.RowScope;
import androidx.compose.foundation.layout.SizeKt;
import androidx.compose.foundation.layout.SpacerKt;
import androidx.compose.material.TextKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.unit.Dp;
import com.vladsch.flexmark.ext.emoji.internal.EmojiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.okonecny.interactivetext.Type;
import me.okonecny.markdowneditor.autocomplete.EmojiAutocompletePluginKt;
import me.okonecny.markdowneditor.inline.EmojiKt;
import me.okonecny.wysiwyg.AutocompletePlugin;
import me.okonecny.wysiwyg.AutocompleteSuggestion;
import me.okonecny.wysiwyg.WysiwygEditorState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lme/okonecny/markdowneditor/autocomplete/EmojiAutocompletePlugin;", "Lme/okonecny/wysiwyg/AutocompletePlugin;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "generateSuggestions", "", "Lme/okonecny/wysiwyg/AutocompleteSuggestion;", "editorState", "Lme/okonecny/wysiwyg/WysiwygEditorState;", "markdown-editor"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nEmojiAutocompletePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmojiAutocompletePlugin.kt\nme/okonecny/markdowneditor/autocomplete/EmojiAutocompletePlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n774#2:69\n865#2,2:70\n774#2:72\n865#2,2:73\n1557#2:75\n1628#2,3:76\n*S KotlinDebug\n*F\n+ 1 EmojiAutocompletePlugin.kt\nme/okonecny/markdowneditor/autocomplete/EmojiAutocompletePlugin\n*L\n28#1:69\n28#1:70,2\n29#1:72\n29#1:73,2\n32#1:75\n32#1:76,3\n*E\n"})
public final class EmojiAutocompletePlugin
implements AutocompletePlugin {
    @NotNull
    private final String name;
    public static final int $stable;

    public EmojiAutocompletePlugin() {
        this.name = "Emoji";
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AutocompleteSuggestion> generateSuggestions(@NotNull WysiwygEditorState editorState) {
        void $this$mapTo$iv$iv;
        EmojiReference.Emoji it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)editorState, (String)"editorState");
        String contextWord = EmojiAutocompletePluginKt.getAutocompleteContextWord(editorState);
        if (!EmojiKt.isMaybeEmojiStart(contextWord)) {
            return CollectionsKt.emptyList();
        }
        String string = contextWord.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String emojiNamePrefix = string;
        if (((CharSequence)emojiNamePrefix).length() == 0) {
            return CollectionsKt.emptyList();
        }
        List list = EmojiReference.getEmojiList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEmojiList(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (EmojiReference.Emoji)element$iv$iv;
            boolean bl = false;
            String string2 = it.shortcut;
            if (!(string2 != null ? StringsKt.startsWith$default((String)string2, (String)emojiNamePrefix, (boolean)false, (int)2, null) : false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (EmojiReference.Emoji)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            boolean bl2 = ((CharSequence)EmojiKt.getUnicodeString(it)).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List emojis = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)5);
        Iterable $this$map$iv = emojis;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void emoji;
            it = (EmojiReference.Emoji)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AutocompleteSuggestion((Function3)ComposableLambdaKt.composableLambdaInstance((int)1157631645, (boolean)true, (Object)new Function3<RowScope, Composer, Integer, Unit>((EmojiReference.Emoji)emoji){
                final /* synthetic */ EmojiReference.Emoji $emoji;
                {
                    this.$emoji = $emoji;
                }

                @Composable
                @ComposableTarget(applier="androidx.compose.ui.UiComposable")
                public final void invoke(RowScope $this$AutocompleteSuggestion, Composer $composer, int $changed) {
                    Intrinsics.checkNotNullParameter((Object)$this$AutocompleteSuggestion, (String)"$this$AutocompleteSuggestion");
                    if (($changed & 0x51) != 16 || !$composer.getSkipping()) {
                        EmojiReference.Emoji emoji = this.$emoji;
                        Intrinsics.checkNotNull((Object)emoji);
                        TextKt.Text-IbK3jfQ((AnnotatedString)EmojiKt.getAnnotatedString(emoji), null, (long)0L, (long)0L, null, null, null, (long)0L, null, null, (long)0L, (int)0, (boolean)false, (int)0, (int)0, null, null, null, (Composer)$composer, (int)0, (int)0, (int)262142);
                        int $this$dp$iv = 3;
                        boolean $i$f$getDp = false;
                        SpacerKt.Spacer((Modifier)SizeKt.width-3ABfNKs((Modifier)((Modifier)Modifier.Companion), (float)Dp.constructor-impl((float)$this$dp$iv)), (Composer)$composer, (int)6);
                        TextKt.Text--4IGK_g((String)(":" + this.$emoji.shortcut + ":"), null, (long)0L, (long)0L, null, null, null, (long)0L, null, null, (long)0L, (int)0, (boolean)false, (int)0, (int)0, null, null, (Composer)$composer, (int)0, (int)0, (int)131070);
                    } else {
                        $composer.skipToGroupEnd();
                    }
                }
            }), arg_0 -> EmojiAutocompletePlugin.generateSuggestions$lambda$3$lambda$2((EmojiReference.Emoji)emoji, contextWord, editorState, arg_0)));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit generateSuggestions$lambda$3$lambda$2(EmojiReference.Emoji $emoji, String $contextWord, WysiwygEditorState $editorState, Function1 handleInput) {
        Intrinsics.checkNotNullParameter((Object)$contextWord, (String)"$contextWord");
        Intrinsics.checkNotNullParameter((Object)$editorState, (String)"$editorState");
        Intrinsics.checkNotNullParameter((Object)handleInput, (String)"handleInput");
        String emojiTag = ":" + $emoji.shortcut + ":";
        handleInput.invoke((Object)new Type(EmojiAutocompletePluginKt.remainingText(emojiTag, $contextWord)));
        $editorState.getInteractiveScope().getFocusRequester().requestFocus();
        return Unit.INSTANCE;
    }
}

