/*
 * Decompiled with CFR 0.152.
 */
package me.okonecny.markdowneditor;

import androidx.compose.foundation.text.InlineTextContent;
import androidx.compose.foundation.text.InlineTextContentKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.SpanStyle;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.okonecny.interactivetext.TextMapping;
import me.okonecny.interactivetext.TextMappingKt;
import me.okonecny.interactivetext.ZeroTextMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\b\u0018\u0000 !2\u00020\u0001:\u0002!\"B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\fJ\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bJ\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J3\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c7\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d7\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d7\u0001J\t\u0010 \u001a\u00020\bH\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lme/okonecny/markdowneditor/MappedText;", "", "text", "Landroidx/compose/ui/text/AnnotatedString;", "textMapping", "Lme/okonecny/interactivetext/TextMapping;", "inlineContent", "", "", "Landroidx/compose/foundation/text/InlineTextContent;", "<init>", "(Landroidx/compose/ui/text/AnnotatedString;Lme/okonecny/interactivetext/TextMapping;Ljava/util/Map;)V", "(Ljava/lang/String;Lme/okonecny/interactivetext/TextMapping;)V", "getText", "()Landroidx/compose/ui/text/AnnotatedString;", "getTextMapping", "()Lme/okonecny/interactivetext/TextMapping;", "getInlineContent", "()Ljava/util/Map;", "annotatedWith", "tag", "annotation", "plus", "other", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "", "toString", "Companion", "Builder", "markdown-editor"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMappedText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappedText.kt\nme/okonecny/markdowneditor/MappedText\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,95:1\n1100#2:96\n*S KotlinDebug\n*F\n+ 1 MappedText.kt\nme/okonecny/markdowneditor/MappedText\n*L\n27#1:96\n*E\n"})
public final class MappedText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnotatedString text;
    @NotNull
    private final TextMapping textMapping;
    @NotNull
    private final Map<String, InlineTextContent> inlineContent;
    public static final int $stable = 8;
    @NotNull
    private static final MappedText empty = new MappedText("", (TextMapping)ZeroTextMapping.INSTANCE);

    public MappedText(@NotNull AnnotatedString text2, @NotNull TextMapping textMapping, @NotNull Map<String, InlineTextContent> inlineContent) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textMapping, (String)"textMapping");
        Intrinsics.checkNotNullParameter(inlineContent, (String)"inlineContent");
        this.text = text2;
        this.textMapping = textMapping;
        this.inlineContent = inlineContent;
    }

    public /* synthetic */ MappedText(AnnotatedString annotatedString, TextMapping textMapping, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(annotatedString, textMapping, map);
    }

    @NotNull
    public final AnnotatedString getText() {
        return this.text;
    }

    @NotNull
    public final TextMapping getTextMapping() {
        return this.textMapping;
    }

    @NotNull
    public final Map<String, InlineTextContent> getInlineContent() {
        return this.inlineContent;
    }

    public MappedText(@NotNull String text2, @NotNull TextMapping textMapping) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textMapping, (String)"textMapping");
        this(new AnnotatedString(text2, null, null, 6, null), textMapping, null, 4, null);
    }

    @NotNull
    public final MappedText annotatedWith(@NotNull String tag, @NotNull String annotation) {
        AnnotatedString.Builder builder;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        boolean $i$f$buildAnnotatedString = false;
        AnnotatedString.Builder $this$annotatedWith_u24lambda_u240 = builder = new AnnotatedString.Builder(0, 1, null);
        boolean bl = false;
        $this$annotatedWith_u24lambda_u240.pushStringAnnotation(tag, annotation);
        $this$annotatedWith_u24lambda_u240.append(this.text);
        $this$annotatedWith_u24lambda_u240.pop();
        Map<String, InlineTextContent> map = this.inlineContent;
        TextMapping textMapping = this.textMapping;
        AnnotatedString annotatedString = builder.toAnnotatedString();
        return new MappedText(annotatedString, textMapping, map);
    }

    @NotNull
    public final MappedText plus(@NotNull MappedText other) {
        MappedText mappedText;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this == empty) {
            mappedText = other;
        } else if (other == empty) {
            mappedText = this;
        } else {
            Set conflictingInlines = CollectionsKt.intersect((Iterable)this.inlineContent.keySet(), (Iterable)other.inlineContent.keySet());
            if (!((Collection)conflictingInlines).isEmpty()) {
                throw new IllegalArgumentException("Definition for " + CollectionsKt.joinToString$default((Iterable)conflictingInlines, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " is already present.");
            }
            mappedText = new MappedText(this.text.plus(other.text), TextMappingKt.plus((TextMapping)this.textMapping, (TextMapping)other.textMapping), MapsKt.plus(this.inlineContent, other.inlineContent));
        }
        return mappedText;
    }

    @NotNull
    public final AnnotatedString component1() {
        return this.text;
    }

    @NotNull
    public final TextMapping component2() {
        return this.textMapping;
    }

    @NotNull
    public final Map<String, InlineTextContent> component3() {
        return this.inlineContent;
    }

    @NotNull
    public final MappedText copy(@NotNull AnnotatedString text2, @NotNull TextMapping textMapping, @NotNull Map<String, InlineTextContent> inlineContent) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)textMapping, (String)"textMapping");
        Intrinsics.checkNotNullParameter(inlineContent, (String)"inlineContent");
        return new MappedText(text2, textMapping, inlineContent);
    }

    public static /* synthetic */ MappedText copy$default(MappedText mappedText, AnnotatedString annotatedString, TextMapping textMapping, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            annotatedString = mappedText.text;
        }
        if ((n & 2) != 0) {
            textMapping = mappedText.textMapping;
        }
        if ((n & 4) != 0) {
            map = mappedText.inlineContent;
        }
        return mappedText.copy(annotatedString, textMapping, map);
    }

    @NotNull
    public String toString() {
        return "MappedText(text=" + this.text + ", textMapping=" + this.textMapping + ", inlineContent=" + this.inlineContent + ")";
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = result * 31 + this.textMapping.hashCode();
        result = result * 31 + ((Object)this.inlineContent).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MappedText)) {
            return false;
        }
        MappedText mappedText = (MappedText)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)mappedText.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textMapping, (Object)mappedText.textMapping)) {
            return false;
        }
        return Intrinsics.areEqual(this.inlineContent, mappedText.inlineContent);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003J$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0016\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aR\u001e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lme/okonecny/markdowneditor/MappedText$Builder;", "", "text", "Lme/okonecny/markdowneditor/MappedText;", "<init>", "(Lme/okonecny/markdowneditor/MappedText;)V", "value", "mappedText", "getMappedText", "()Lme/okonecny/markdowneditor/MappedText;", "visualLength", "", "getVisualLength", "()I", "append", "", "appendInlineContent", "textMapping", "Lme/okonecny/interactivetext/TextMapping;", "inlineElementId", "", "inlineContent", "Lkotlin/Function0;", "Landroidx/compose/foundation/text/InlineTextContent;", "appendStyled", "style", "Landroidx/compose/ui/text/SpanStyle;", "markdown-editor"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nMappedText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappedText.kt\nme/okonecny/markdowneditor/MappedText$Builder\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,95:1\n1100#2:96\n1100#2:97\n*S KotlinDebug\n*F\n+ 1 MappedText.kt\nme/okonecny/markdowneditor/MappedText$Builder\n*L\n70#1:96\n82#1:97\n*E\n"})
    public static final class Builder {
        @NotNull
        private MappedText mappedText;
        public static final int $stable = 8;

        public Builder(@NotNull MappedText text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.mappedText = text2;
        }

        public /* synthetic */ Builder(MappedText mappedText, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                mappedText = Companion.getEmpty();
            }
            this(mappedText);
        }

        @NotNull
        public final MappedText getMappedText() {
            return this.mappedText;
        }

        public final int getVisualLength() {
            return this.mappedText.getText().length();
        }

        public final void append(@NotNull MappedText text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.mappedText = this.mappedText.plus(text2);
        }

        public final void appendInlineContent(@NotNull TextMapping textMapping, @NotNull String inlineElementId, @NotNull Function0<InlineTextContent> inlineContent) {
            AnnotatedString.Builder builder;
            Intrinsics.checkNotNullParameter((Object)textMapping, (String)"textMapping");
            Intrinsics.checkNotNullParameter((Object)inlineElementId, (String)"inlineElementId");
            Intrinsics.checkNotNullParameter(inlineContent, (String)"inlineContent");
            boolean $i$f$buildAnnotatedString = false;
            AnnotatedString.Builder $this$appendInlineContent_u24lambda_u240 = builder = new AnnotatedString.Builder(0, 1, null);
            boolean bl = false;
            InlineTextContentKt.appendInlineContent$default((AnnotatedString.Builder)$this$appendInlineContent_u24lambda_u240, (String)inlineElementId, null, (int)2, null);
            Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)inlineElementId, (Object)inlineContent.invoke()));
            TextMapping textMapping2 = textMapping;
            AnnotatedString annotatedString = builder.toAnnotatedString();
            MappedText inlines = new MappedText(annotatedString, textMapping2, map);
            this.mappedText = this.mappedText.plus(inlines);
        }

        /*
         * WARNING - void declaration
         */
        public final void appendStyled(@NotNull MappedText mappedText, @NotNull SpanStyle style) {
            void $this$appendStyled_u24lambda_u241;
            AnnotatedString.Builder builder;
            Intrinsics.checkNotNullParameter((Object)mappedText, (String)"mappedText");
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            boolean $i$f$buildAnnotatedString = false;
            AnnotatedString.Builder builder2 = builder = new AnnotatedString.Builder(0, 1, null);
            MappedText mappedText2 = mappedText;
            Builder builder3 = this;
            boolean bl = false;
            $this$appendStyled_u24lambda_u241.pushStyle(style);
            $this$appendStyled_u24lambda_u241.append(mappedText.getText());
            $this$appendStyled_u24lambda_u241.pop();
            Unit unit = Unit.INSTANCE;
            builder3.append(MappedText.copy$default(mappedText2, builder.toAnnotatedString(), null, null, 6, null));
        }

        public Builder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/okonecny/markdowneditor/MappedText$Companion;", "", "<init>", "()V", "empty", "Lme/okonecny/markdowneditor/MappedText;", "getEmpty", "()Lme/okonecny/markdowneditor/MappedText;", "markdown-editor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MappedText getEmpty() {
            return empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

