/*
 * Decompiled with CFR 0.152.
 */
package me.okonecny.markdowneditor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.okonecny.interactivetext.LinearInteractiveIdGenerator;
import me.okonecny.markdowneditor.DocumentKt;
import me.okonecny.markdowneditor.MarkdownReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0018\b\u0002\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u0010j\u0002`\u000f0\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001a\u001a\u00020\u0003J\u0017\u0010\u001b\u001a\u00060\u0010j\u0002`\u000f2\u0006\u0010\u001c\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u0010j\u0002`\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lme/okonecny/markdowneditor/MarkdownDocument;", "", "sourceText", "", "ast", "Lcom/vladsch/flexmark/util/ast/Document;", "basePath", "Ljava/nio/file/Path;", "references", "", "Lme/okonecny/markdowneditor/MarkdownReference;", "interactiveIdGenerator", "Lme/okonecny/interactivetext/LinearInteractiveIdGenerator;", "interactiveIds", "Lcom/vladsch/flexmark/util/ast/Node;", "Lme/okonecny/interactivetext/InteractiveId;", "", "<init>", "(Ljava/lang/String;Lcom/vladsch/flexmark/util/ast/Document;Ljava/nio/file/Path;Ljava/util/Map;Lme/okonecny/interactivetext/LinearInteractiveIdGenerator;Ljava/util/Map;)V", "getSourceText", "()Ljava/lang/String;", "getAst", "()Lcom/vladsch/flexmark/util/ast/Document;", "getBasePath", "()Ljava/nio/file/Path;", "resolveReference", "reference", "getInteractiveId", "node", "(Lcom/vladsch/flexmark/util/ast/Node;)J", "markdown-editor"})
@StabilityInferred(parameters=0)
public final class MarkdownDocument {
    @NotNull
    private final String sourceText;
    @NotNull
    private final Document ast;
    @NotNull
    private final Path basePath;
    @NotNull
    private final Map<String, MarkdownReference> references;
    @NotNull
    private final LinearInteractiveIdGenerator interactiveIdGenerator;
    @NotNull
    private final Map<Node, Long> interactiveIds;
    public static final int $stable = 8;

    public MarkdownDocument(@NotNull String sourceText, @NotNull Document ast, @NotNull Path basePath, @NotNull Map<String, MarkdownReference> references, @NotNull LinearInteractiveIdGenerator interactiveIdGenerator, @NotNull Map<Node, Long> interactiveIds) {
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter((Object)ast, (String)"ast");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter(references, (String)"references");
        Intrinsics.checkNotNullParameter((Object)interactiveIdGenerator, (String)"interactiveIdGenerator");
        Intrinsics.checkNotNullParameter(interactiveIds, (String)"interactiveIds");
        this.sourceText = sourceText;
        this.ast = ast;
        this.basePath = basePath;
        this.references = references;
        this.interactiveIdGenerator = interactiveIdGenerator;
        this.interactiveIds = interactiveIds;
    }

    public /* synthetic */ MarkdownDocument(String string, Document document, Path path, Map map, LinearInteractiveIdGenerator linearInteractiveIdGenerator, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            linearInteractiveIdGenerator = new LinearInteractiveIdGenerator();
        }
        if ((n & 0x20) != 0) {
            map2 = DocumentKt.generateInteractiveIdsPreOrder$default((Node)document, linearInteractiveIdGenerator, null, 4, null);
        }
        this(string, document, path, map, linearInteractiveIdGenerator, map2);
    }

    @NotNull
    public final String getSourceText() {
        return this.sourceText;
    }

    @NotNull
    public final Document getAst() {
        return this.ast;
    }

    @NotNull
    public final Path getBasePath() {
        return this.basePath;
    }

    @Nullable
    public final MarkdownReference resolveReference(@NotNull String reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        String string = reference.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return this.references.get(string);
    }

    public final long getInteractiveId(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Long l = this.interactiveIds.get(node);
        if (l == null) {
            throw new IllegalStateException("Node is not a part of this document.");
        }
        return l;
    }
}

