/*
 * Decompiled with CFR 0.152.
 */
package me.okonecny.markdowneditor.flexmark;

import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRangeKt;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.TextCollectingVisitor;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.okonecny.markdowneditor.MappedText;
import me.okonecny.markdowneditor.flexmark.NodeKt;
import me.okonecny.markdowneditor.view.SequenceTextMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0002H\u0000\u001a\f\u0010\u000e\u001a\u00020\r*\u00020\u0002H\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"range", "Landroidx/compose/ui/text/TextRange;", "Lcom/vladsch/flexmark/util/ast/Node;", "getRange", "(Lcom/vladsch/flexmark/util/ast/Node;)J", "contains", "", "other", "source", "", "getSource", "(Lcom/vladsch/flexmark/util/ast/Node;)Ljava/lang/String;", "rawCode", "Lme/okonecny/markdowneditor/MappedText;", "text", "markdown-editor"})
public final class NodeKt {
    public static final long getRange(@NotNull Node $this$range) {
        Intrinsics.checkNotNullParameter((Object)$this$range, (String)"<this>");
        return TextRangeKt.TextRange((int)$this$range.getStartOffset(), (int)$this$range.getEndOffset());
    }

    public static final boolean contains(@NotNull Node $this$contains, @NotNull Node other) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$contains.getStartOffset() <= other.getStartOffset() && $this$contains.getEndOffset() >= other.getEndOffset();
    }

    @NotNull
    public static final String getSource(@NotNull Node $this$source) {
        Intrinsics.checkNotNullParameter((Object)$this$source, (String)"<this>");
        return $this$source.getChars().toString();
    }

    @NotNull
    public static final MappedText rawCode(@NotNull Node $this$rawCode) {
        Intrinsics.checkNotNullParameter((Object)$this$rawCode, (String)"<this>");
        BasedSequence basedSequence = $this$rawCode.getChars();
        Intrinsics.checkNotNullExpressionValue((Object)basedSequence, (String)"getChars(...)");
        BasedSequence sequence = basedSequence;
        return new MappedText($this$rawCode.getChars().toString(), new SequenceTextMapping(TextRangeKt.TextRange((int)0, (int)sequence.length()), sequence, null));
    }

    @NotNull
    public static final MappedText text(@NotNull Node $this$text) {
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"me/okonecny/markdowneditor/flexmark/NodeKt$text$ST", "", "sequence", "Lcom/vladsch/flexmark/util/sequence/BasedSequence;", "text", "", "<init>", "(Lcom/vladsch/flexmark/util/sequence/BasedSequence;Ljava/lang/String;)V", "getSequence", "()Lcom/vladsch/flexmark/util/sequence/BasedSequence;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "(Lcom/vladsch/flexmark/util/sequence/BasedSequence;Ljava/lang/String;)Lme/okonecny/markdowneditor/flexmark/NodeKt$text$ST;", "equals", "", "other", "hashCode", "", "toString", "markdown-editor"})
        public final class ST {
            private final BasedSequence sequence;
            private final String text;

            public ST(BasedSequence sequence, String text2) {
                Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                this.sequence = sequence;
                this.text = text2;
            }

            public final BasedSequence getSequence() {
                return this.sequence;
            }

            public final String getText() {
                return this.text;
            }

            public final BasedSequence component1() {
                return this.sequence;
            }

            public final String component2() {
                return this.text;
            }

            public final ST copy(BasedSequence sequence, String text2) {
                Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return new ST(sequence, text2);
            }

            public static /* synthetic */ ST copy$default(ST sT, BasedSequence basedSequence, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    basedSequence = sT.sequence;
                }
                if ((n & 2) != 0) {
                    string = sT.text;
                }
                return sT.copy(basedSequence, string);
            }

            public String toString() {
                return "ST(sequence=" + this.sequence + ", text=" + this.text + ")";
            }

            public int hashCode() {
                int result = this.sequence.hashCode();
                result = result * 31 + this.text.hashCode();
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ST)) {
                    return false;
                }
                ST sT = (ST)other;
                if (!Intrinsics.areEqual((Object)this.sequence, (Object)sT.sequence)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.text, (Object)sT.text);
            }
        }
        ST sT;
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"<this>");
        TextCollectingVisitor builder = new TextCollectingVisitor();
        builder.collect($this$text);
        if (builder.getSequence().isNull()) {
            BasedSequence basedSequence = $this$text.getChars();
            Intrinsics.checkNotNullExpressionValue((Object)basedSequence, (String)"getChars(...)");
            sT = new ST(basedSequence, $this$text.getChars().toString());
        } else {
            BasedSequence basedSequence = builder.getSequence();
            Intrinsics.checkNotNullExpressionValue((Object)basedSequence, (String)"getSequence(...)");
            String string = builder.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            sT = new ST(basedSequence, string);
        }
        ST sT2 = sT;
        BasedSequence sequence = sT2.component1();
        String text2 = sT2.component2();
        String string = builder.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new MappedText(new AnnotatedString(string, null, null, 6, null), new SequenceTextMapping(TextRangeKt.TextRange((int)0, (int)text2.length()), sequence, null), null, 4, null);
    }
}

