/*
 * Decompiled with CFR 0.152.
 */
package me.okonecny.markdowneditor.inline;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.platform.UriHandler;
import java.net.URI;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.okonecny.markdowneditor.LinkHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/okonecny/markdowneditor/inline/WebLink;", "Lme/okonecny/markdowneditor/LinkHandler;", "uriHandler", "Landroidx/compose/ui/platform/UriHandler;", "<init>", "(Landroidx/compose/ui/platform/UriHandler;)V", "canBrowse", "", "url", "", "linkActivated", "", "annotationValue", "parseLinkAnnotation", "markdown-editor"})
@StabilityInferred(parameters=0)
public final class WebLink
implements LinkHandler {
    @NotNull
    private final UriHandler uriHandler;
    public static final int $stable = 8;

    public WebLink(@NotNull UriHandler uriHandler) {
        Intrinsics.checkNotNullParameter((Object)uriHandler, (String)"uriHandler");
        this.uriHandler = uriHandler;
    }

    private final boolean canBrowse(String url) {
        if (!StringsKt.startsWith$default((String)url, (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null)) {
            return false;
        }
        try {
            new URI(url);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public void linkActivated(@NotNull String annotationValue) {
        Intrinsics.checkNotNullParameter((Object)annotationValue, (String)"annotationValue");
        if (!this.canBrowse(annotationValue)) {
            return;
        }
        this.uriHandler.openUri(annotationValue);
    }

    @Override
    @Nullable
    public String parseLinkAnnotation(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.canBrowse(url) ? url : null;
    }

    @Override
    @NotNull
    public String getLinkAnnotationTag() {
        return LinkHandler.DefaultImpls.getLinkAnnotationTag(this);
    }
}

