/*
 * Decompiled with CFR 0.152.
 */
package me.okonecny.markdowneditor.toolbar;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.util.ast.Block;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0081\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B!\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\u000f\u001a\u00020\u00062\u0016\u0010\u0010\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00120\u0011\"\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013R\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0015"}, d2={"Lme/okonecny/markdowneditor/toolbar/ParagraphStyle;", "", "nodeType", "Lkotlin/reflect/KClass;", "Lcom/vladsch/flexmark/util/ast/Block;", "descriptionFormat", "", "<init>", "(Ljava/lang/String;ILkotlin/reflect/KClass;Ljava/lang/String;)V", "getNodeType", "()Lkotlin/reflect/KClass;", "HEADING", "FENCED_CODE_BLOCK", "BLOCK_QUOTE", "PARAGRAPH", "description", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "Companion", "markdown-editor"})
@SourceDebugExtension(value={"SMAP\nParagraphStyleCombo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParagraphStyleCombo.kt\nme/okonecny/markdowneditor/toolbar/ParagraphStyle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n1557#2:171\n1628#2,3:172\n*S KotlinDebug\n*F\n+ 1 ParagraphStyleCombo.kt\nme/okonecny/markdowneditor/toolbar/ParagraphStyle\n*L\n164#1:171\n164#1:172,3\n*E\n"})
final class ParagraphStyle
extends Enum<ParagraphStyle> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final KClass<? extends Block> nodeType;
    @NotNull
    private final String descriptionFormat;
    @NotNull
    private static final Lazy<Set<ParagraphStyle>> allowedParagraphStyles$delegate;
    @NotNull
    private static final Lazy<Set<KClass<? extends Block>>> allowedNodeTypes$delegate;
    public static final /* enum */ ParagraphStyle HEADING;
    public static final /* enum */ ParagraphStyle FENCED_CODE_BLOCK;
    public static final /* enum */ ParagraphStyle BLOCK_QUOTE;
    public static final /* enum */ ParagraphStyle PARAGRAPH;
    private static final /* synthetic */ ParagraphStyle[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private ParagraphStyle(KClass<? extends Block> nodeType, String descriptionFormat) {
        this.nodeType = nodeType;
        this.descriptionFormat = descriptionFormat;
    }

    @NotNull
    public final KClass<? extends Block> getNodeType() {
        return this.nodeType;
    }

    @NotNull
    public final String description(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(this.descriptionFormat, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public static ParagraphStyle[] values() {
        return (ParagraphStyle[])$VALUES.clone();
    }

    public static ParagraphStyle valueOf(String value) {
        return Enum.valueOf(ParagraphStyle.class, value);
    }

    @NotNull
    public static EnumEntries<ParagraphStyle> getEntries() {
        return $ENTRIES;
    }

    private static final Set allowedParagraphStyles_delegate$lambda$0() {
        return CollectionsKt.toSet((Iterable)((Iterable)ParagraphStyle.getEntries()));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set allowedNodeTypes_delegate$lambda$1() {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = Companion.getAllowedParagraphStyles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ParagraphStyle paragraphStyle = (ParagraphStyle)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.nodeType);
        }
        return CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    static {
        HEADING = new ParagraphStyle((KClass<? extends Block>)Reflection.getOrCreateKotlinClass(Heading.class), "Heading %s");
        FENCED_CODE_BLOCK = new ParagraphStyle((KClass<? extends Block>)Reflection.getOrCreateKotlinClass(FencedCodeBlock.class), "Code Block");
        BLOCK_QUOTE = new ParagraphStyle((KClass<? extends Block>)Reflection.getOrCreateKotlinClass(BlockQuote.class), "Quoted Text");
        PARAGRAPH = new ParagraphStyle((KClass<? extends Block>)Reflection.getOrCreateKotlinClass(Paragraph.class), "Paragraph");
        $VALUES = paragraphStyleArray = new ParagraphStyle[]{ParagraphStyle.HEADING, ParagraphStyle.FENCED_CODE_BLOCK, ParagraphStyle.BLOCK_QUOTE, ParagraphStyle.PARAGRAPH};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        allowedParagraphStyles$delegate = LazyKt.lazy(ParagraphStyle::allowedParagraphStyles_delegate$lambda$0);
        allowedNodeTypes$delegate = LazyKt.lazy(ParagraphStyle::allowedNodeTypes_delegate$lambda$1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR)\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000f0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\r\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lme/okonecny/markdowneditor/toolbar/ParagraphStyle$Companion;", "", "<init>", "()V", "forNode", "Lme/okonecny/markdowneditor/toolbar/ParagraphStyle;", "node", "Lcom/vladsch/flexmark/util/ast/Block;", "allowedParagraphStyles", "", "getAllowedParagraphStyles", "()Ljava/util/Set;", "allowedParagraphStyles$delegate", "Lkotlin/Lazy;", "allowedNodeTypes", "Lkotlin/reflect/KClass;", "getAllowedNodeTypes", "allowedNodeTypes$delegate", "markdown-editor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ParagraphStyle forNode(@NotNull Block node) {
            ParagraphStyle paragraphStyle;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Block block = node;
            if (block instanceof Heading) {
                paragraphStyle = HEADING;
            } else if (block instanceof FencedCodeBlock) {
                paragraphStyle = FENCED_CODE_BLOCK;
            } else if (block instanceof BlockQuote) {
                paragraphStyle = BLOCK_QUOTE;
            } else if (block instanceof Paragraph) {
                paragraphStyle = PARAGRAPH;
            } else {
                throw new IllegalArgumentException("Unknown node type.");
            }
            return paragraphStyle;
        }

        @NotNull
        public final Set<ParagraphStyle> getAllowedParagraphStyles() {
            Lazy lazy = allowedParagraphStyles$delegate;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final Set<KClass<? extends Block>> getAllowedNodeTypes() {
            Lazy lazy = allowedNodeTypes$delegate;
            return (Set)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

