/*
 * Decompiled with CFR 0.152.
 */
package me.omico.gradm.internal.codegen;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.FileSpec;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Suppress;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import me.omico.gradm.GradmConfigs;
import me.omico.gradm.GradmMode;
import me.omico.gradm.internal.codegen.DependenciesKt;
import me.omico.gradm.internal.codegen.GradleBuildScriptKt;
import me.omico.gradm.internal.codegen.GradleSettingsScriptKt;
import me.omico.gradm.internal.codegen.VersionsKt;
import me.omico.gradm.path.GradleProjectPaths;
import me.omico.gradm.path.GradleProjectPathsKt;
import me.omico.gradm.path.GradleRootProjectPaths;
import me.omico.gradm.path.GradmProjectPaths;
import me.omico.gradm.utility.PathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0000\u001a8\u0010\u0006\u001a\u00020\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bj\u0002`\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\bj\u0002`\fH\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000eH\u0000\u001a'\u0010\u000f\u001a\u00020\u000e*\u00020\u000e2\u0014\b\u0002\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001\"\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0011\u001a\f\u0010\u0012\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0002*\u00020\u0002H\u0000\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0014"}, d2={"defaultSuppressWarningTypes", "", "", "[Ljava/lang/String;", "generateGradleFiles", "", "generateSourceFiles", "document", "", "", "Lme/omico/gradm/internal/YamlDocument;", "versionsMeta", "Lme/omico/gradm/VersionsMeta;", "addGradmComment", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "addSuppressWarningTypes", "types", "(Lcom/squareup/kotlinpoet/FileSpec$Builder;[Ljava/lang/String;)Lcom/squareup/kotlinpoet/FileSpec$Builder;", "camelCase", "capitalize", "gradm-codegen"})
public final class CodeGeneratorKt {
    @NotNull
    private static final String[] defaultSuppressWarningTypes;

    public static final void generateGradleFiles() {
        Path path;
        boolean $i$f$getGradmGeneratedDependenciesProjectPaths = false;
        boolean $i$f$getGradmProjectPaths = false;
        GradmMode gradmMode = GradmConfigs.Companion.getMode();
        if (Intrinsics.areEqual((Object)gradmMode, (Object)GradmMode.Normal.INSTANCE)) {
            path = GradleRootProjectPaths.Companion.getPath().resolve(".gradm");
        } else if (Intrinsics.areEqual((Object)gradmMode, (Object)GradmMode.BuildSource.INSTANCE)) {
            GradleProjectPaths $this$buildSourceFolder$iv$iv$iv = (GradleProjectPaths)GradleRootProjectPaths.Companion;
            boolean $i$f$getBuildSourceFolder = false;
            Path path2 = $this$buildSourceFolder$iv$iv$iv.getPath().resolve("buildSrc");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(\"buildSrc\")");
            path = path2.resolve(".gradm");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"when (GradmConfigs.mode)\u2026solve(\".gradm\")\n        }");
        Path $this$generatedDependenciesFolder$iv$iv = GradmProjectPaths.constructor-impl((Path)path);
        boolean bl = false;
        Path path3 = $this$generatedDependenciesFolder$iv$iv.resolve("generated-dependencies");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path.resolve(\"generated-dependencies\")");
        Path path4 = GradleProjectPathsKt.GradleProjectPaths((Path)path3).getPath();
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path4, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        GradleBuildScriptKt.generateGradleBuildScript();
        GradleSettingsScriptKt.generateGradleSettingsScript();
    }

    public static final void generateSourceFiles(@NotNull Map<String, ? extends Object> document, @NotNull Map<String, String> versionsMeta) {
        Path path;
        Intrinsics.checkNotNullParameter(document, (String)"document");
        Intrinsics.checkNotNullParameter(versionsMeta, (String)"versionsMeta");
        if (versionsMeta.isEmpty()) {
            return;
        }
        boolean $i$f$getGradmGeneratedDependenciesProjectPaths = false;
        boolean $i$f$getGradmProjectPaths = false;
        GradmMode gradmMode = GradmConfigs.Companion.getMode();
        if (Intrinsics.areEqual((Object)gradmMode, (Object)GradmMode.Normal.INSTANCE)) {
            path = GradleRootProjectPaths.Companion.getPath().resolve(".gradm");
        } else if (Intrinsics.areEqual((Object)gradmMode, (Object)GradmMode.BuildSource.INSTANCE)) {
            GradleProjectPaths $this$buildSourceFolder$iv$iv$iv = (GradleProjectPaths)GradleRootProjectPaths.Companion;
            boolean $i$f$getBuildSourceFolder = false;
            Path path2 = $this$buildSourceFolder$iv$iv$iv.getPath().resolve("buildSrc");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(\"buildSrc\")");
            path = path2.resolve(".gradm");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"when (GradmConfigs.mode)\u2026solve(\".gradm\")\n        }");
        Path $this$generatedDependenciesFolder$iv$iv = GradmProjectPaths.constructor-impl((Path)path);
        boolean bl = false;
        Path path3 = $this$generatedDependenciesFolder$iv$iv.resolve("generated-dependencies");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path.resolve(\"generated-dependencies\")");
        GradleProjectPaths $this$sourceFolder$iv = GradleProjectPathsKt.GradleProjectPaths((Path)path3);
        boolean $i$f$getSourceFolder = false;
        Path path4 = $this$sourceFolder$iv.getPath().resolve("src/main/kotlin");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path.resolve(\"src/main/kotlin\")");
        PathKt.clearDirectory((Path)path4);
        DependenciesKt.generateDependenciesSourceFiles(document, versionsMeta);
        VersionsKt.generateVersionsSourceFile(document);
    }

    @NotNull
    public static final FileSpec.Builder addSuppressWarningTypes(@NotNull FileSpec.Builder $this$addSuppressWarningTypes, String ... types) {
        Intrinsics.checkNotNullParameter((Object)$this$addSuppressWarningTypes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        char[] cArray = new char[]{','};
        AnnotationSpec p0 = AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Suppress.class)).addMember(StringsKt.trimEnd((String)StringsKt.repeat((CharSequence)"%S,", (int)types.length), (char[])cArray), (Object[])Arrays.copyOf(types, types.length)).build();
        boolean bl = false;
        return $this$addSuppressWarningTypes.addAnnotation(p0);
    }

    public static /* synthetic */ FileSpec.Builder addSuppressWarningTypes$default(FileSpec.Builder builder, String[] stringArray, int n, Object object) {
        if ((n & 1) != 0) {
            stringArray = defaultSuppressWarningTypes;
        }
        return CodeGeneratorKt.addSuppressWarningTypes(builder, stringArray);
    }

    @NotNull
    public static final FileSpec.Builder addGradmComment(@NotNull FileSpec.Builder $this$addGradmComment) {
        Intrinsics.checkNotNullParameter((Object)$this$addGradmComment, (String)"<this>");
        return $this$addGradmComment.addFileComment("\nGenerated by Gradm, will be overwritten by every dependencies update, do not edit!!!\n", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String capitalize(@NotNull String $this$capitalize) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$capitalize, (String)"<this>");
        String string2 = $this$capitalize;
        if (((CharSequence)string2).length() > 0) {
            String string3;
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Character.isLowerCase((char)it)) {
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                string3 = CharsKt.titlecase((char)it, (Locale)locale);
            } else {
                string3 = String.valueOf((char)it);
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
            String string4 = string2;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String camelCase(@NotNull String $this$camelCase) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$camelCase, (String)"<this>");
        String[] stringArray = new String[]{"-", "_"};
        Iterable $this$mapIndexed$iv = StringsKt.split$default((CharSequence)$this$camelCase, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void s;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(index == false ? s : CodeGeneratorKt.capitalize((String)s));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    static {
        String[] stringArray = new String[]{"MemberVisibilityCanBePrivate", "RedundantVisibilityModifier", "unused"};
        defaultSuppressWarningTypes = stringArray;
    }
}

