/*
 * Decompiled with CFR 0.152.
 */
package me.omico.gradm;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.omico.gradm.GradmConfiguration;
import me.omico.gradm.GradmKt;
import me.omico.gradm.internal.codegen.CodeGeneratorKt;
import me.omico.gradm.internal.config.RepositoriesKt;
import me.omico.gradm.internal.config.Repository;
import me.omico.gradm.internal.maven.MavenMetadataResovlerKt;
import me.omico.gradm.path.GradmProjectPaths;
import me.omico.gradm.service.GradmBuildService;
import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\tH\u0016J8\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0011j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u0007J(\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0011j\u0002`\u0014J0\u0010\u0019\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0011j\u0002`\u0014J&\u0010\u001a\u001a\u00020\t*\u00020\u00182\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0011j\u0002`\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/omico/gradm/GradmWorkerService;", "Lme/omico/gradm/service/GradmBuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "()V", "updated", "", "updatesAvailableFile", "Ljava/nio/file/Path;", "checkUpdatesAvailable", "", "gradmProjectPaths", "Lme/omico/gradm/path/GradmProjectPaths;", "close", "generate", "dependencies", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "gradmConfigDocument", "", "", "", "Lme/omico/gradm/internal/YamlDocument;", "outputDirectory", "initialize", "repositories", "Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "refresh", "setupRepositories", "document", "gradm-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGradmWorkerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradmWorkerService.kt\nme/omico/gradm/GradmWorkerService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 GradmProjectPaths.kt\nme/omico/gradm/path/GradmProjectPathsKt\n*L\n1#1,109:1\n819#2:110\n847#2,2:111\n1855#2,2:113\n52#3:115\n49#3:116\n40#3:117\n37#3:118\n49#3:119\n40#3:120\n37#3:121\n*S KotlinDebug\n*F\n+ 1 GradmWorkerService.kt\nme/omico/gradm/GradmWorkerService\n*L\n89#1:110\n89#1:111,2\n90#1:113,2\n104#1:115\n104#1:116\n104#1:117\n104#1:118\n104#1:119\n104#1:120\n104#1:121\n*E\n"})
public abstract class GradmWorkerService
implements GradmBuildService<BuildServiceParameters.None> {
    private boolean updated;
    @Nullable
    private Path updatesAvailableFile;

    public final void initialize(@NotNull RepositoryHandler repositories, @NotNull Map<String, ? extends Object> gradmConfigDocument) {
        Intrinsics.checkNotNullParameter((Object)repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter(gradmConfigDocument, (String)"gradmConfigDocument");
        this.setupRepositories(repositories, gradmConfigDocument);
    }

    public final void generate(@NotNull DependencyHandler dependencies, @NotNull GradmProjectPaths gradmProjectPaths, @NotNull Map<String, ? extends Object> gradmConfigDocument, @NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)gradmProjectPaths, (String)"gradmProjectPaths");
        Intrinsics.checkNotNullParameter(gradmConfigDocument, (String)"gradmConfigDocument");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        GradmConfiguration.INSTANCE.setRequireRefresh(false);
        Map versionsMeta = MavenMetadataResovlerKt.resolveVersionsMeta((DependencyHandler)dependencies, (GradmProjectPaths)gradmProjectPaths, gradmConfigDocument);
        CodeGeneratorKt.generateGradmGeneratedSources((GradmProjectPaths)gradmProjectPaths, gradmConfigDocument, (Map)versionsMeta, (Path)outputDirectory);
        this.checkUpdatesAvailable(gradmProjectPaths);
    }

    public final void refresh(@NotNull DependencyHandler dependencies, @NotNull GradmProjectPaths gradmProjectPaths, @NotNull Map<String, ? extends Object> gradmConfigDocument) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)gradmProjectPaths, (String)"gradmProjectPaths");
        Intrinsics.checkNotNullParameter(gradmConfigDocument, (String)"gradmConfigDocument");
        if (this.updated) {
            return;
        }
        GradmConfiguration.INSTANCE.setRequireRefresh(true);
        MavenMetadataResovlerKt.resolveVersionsMeta((DependencyHandler)dependencies, (GradmProjectPaths)gradmProjectPaths, gradmConfigDocument);
        this.checkUpdatesAvailable(gradmProjectPaths);
    }

    public void close() {
        block0: {
            Path path = this.updatesAvailableFile;
            if (path == null) break block0;
            Path file = path;
            boolean bl = false;
            GradmKt.info((Function0)((Function0)new Function0<String>(file){
                final /* synthetic */ Path $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Available updates found, see " + this.$file.toAbsolutePath();
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupRepositories(RepositoryHandler $this$setupRepositories, Map<String, ? extends Object> document) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = RepositoriesKt.getRepositories(document);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Repository p0 = (Repository)element$iv$iv;
            boolean bl = false;
            if (p0.getNoUpdates()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Repository repository = (Repository)element$iv;
            boolean bl = false;
            switch (repository.getId()) {
                case "google": {
                    $this$setupRepositories.google();
                    break;
                }
                case "mavenCentral": {
                    $this$setupRepositories.mavenCentral();
                    break;
                }
                case "gradlePluginPortal": {
                    $this$setupRepositories.gradlePluginPortal();
                    break;
                }
                case "mavenLocal": {
                    $this$setupRepositories.mavenLocal();
                    break;
                }
                default: {
                    $this$setupRepositories.maven(new Action(repository){
                        final /* synthetic */ Repository $repository;
                        {
                            this.$repository = $repository;
                        }

                        public final void execute(@NotNull MavenArtifactRepository $this$maven) {
                            Intrinsics.checkNotNullParameter((Object)$this$maven, (String)"$this$maven");
                            $this$maven.setUrl(URI.create(this.$repository.getUrl()));
                        }
                    });
                }
            }
        }
    }

    private final void checkUpdatesAvailable(GradmProjectPaths gradmProjectPaths) {
        Path path;
        this.updated = true;
        GradmProjectPaths $this$updatesAvailableFile$iv = gradmProjectPaths;
        boolean $i$f$getUpdatesAvailableFile = false;
        GradmProjectPaths $this$updatesDirectory$iv$iv = $this$updatesAvailableFile$iv;
        boolean $i$f$getUpdatesDirectory = false;
        GradmProjectPaths $this$gradmBuildDirectory$iv$iv$iv = $this$updatesDirectory$iv$iv;
        boolean $i$f$getGradmBuildDirectory = false;
        GradmProjectPaths $this$buildDirectory$iv$iv$iv$iv = $this$gradmBuildDirectory$iv$iv$iv;
        boolean $i$f$getBuildDirectory = false;
        Path path2 = $this$buildDirectory$iv$iv$iv$iv.getPath().resolve("build");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.resolve(other)");
        Path path3 = path2.resolve("gradm");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.resolve(other)");
        Path path4 = path3.resolve("updates");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"this.resolve(other)");
        Path path5 = path4.resolve("available.yml");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"this.resolve(other)");
        if (Files.exists(path5, new LinkOption[0])) {
            $this$updatesAvailableFile$iv = gradmProjectPaths;
            $i$f$getUpdatesAvailableFile = false;
            $this$updatesDirectory$iv$iv = $this$updatesAvailableFile$iv;
            $i$f$getUpdatesDirectory = false;
            $this$gradmBuildDirectory$iv$iv$iv = $this$updatesDirectory$iv$iv;
            $i$f$getGradmBuildDirectory = false;
            $this$buildDirectory$iv$iv$iv$iv = $this$gradmBuildDirectory$iv$iv$iv;
            $i$f$getBuildDirectory = false;
            Path path6 = $this$buildDirectory$iv$iv$iv$iv.getPath().resolve("build");
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"this.resolve(other)");
            Path path7 = path6.resolve("gradm");
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"this.resolve(other)");
            Path path8 = path7.resolve("updates");
            Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"this.resolve(other)");
            Path path9 = path8.resolve("available.yml");
            path = path9;
            Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"this.resolve(other)");
        } else {
            path = null;
        }
        this.updatesAvailableFile = path;
    }
}

