/*
 * Decompiled with CFR 0.152.
 */
package me.omico.gradm.task;

import java.nio.file.Path;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.omico.gradm.GradmWorkerService;
import me.omico.gradm.internal.YamlKt;
import me.omico.gradm.internal.config.format.FormatterKt;
import me.omico.gradm.path.GradmProjectPaths;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010(\u001a\u00020)H\u0015J\u0006\u0010*\u001a\u00020\rJ\b\u0010+\u001a\u00020)H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\fj\u0002`\u000f8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8EX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020#0\u001b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001d\u00a8\u0006,"}, d2={"Lme/omico/gradm/task/GradmTask;", "Lorg/gradle/api/DefaultTask;", "()V", "configFileProperty", "Lorg/gradle/api/file/RegularFileProperty;", "getConfigFileProperty", "()Lorg/gradle/api/file/RegularFileProperty;", "dependencies", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "getDependencies", "()Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "gradmConfigDocument", "", "", "", "Lme/omico/gradm/internal/YamlDocument;", "getGradmConfigDocument", "()Ljava/util/Map;", "gradmProjectPaths", "Lme/omico/gradm/path/GradmProjectPaths;", "getGradmProjectPaths", "()Lme/omico/gradm/path/GradmProjectPaths;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "getProjectLayout", "()Lorg/gradle/api/file/ProjectLayout;", "projectNameProperty", "Lorg/gradle/api/provider/Property;", "getProjectNameProperty", "()Lorg/gradle/api/provider/Property;", "repositories", "Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "getRepositories", "()Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "workerService", "Lme/omico/gradm/GradmWorkerService;", "getWorkerService", "()Lme/omico/gradm/GradmWorkerService;", "workerServiceProperty", "getWorkerServiceProperty", "execute", "", "getGroup", "notCompatibleWithConfigurationCache", "gradm-gradle-plugin"})
public abstract class GradmTask
extends DefaultTask {
    public GradmTask() {
        this.notCompatibleWithConfigurationCache();
    }

    @Internal
    @NotNull
    public abstract Property<String> getProjectNameProperty();

    @Internal
    @NotNull
    public abstract Property<GradmWorkerService> getWorkerServiceProperty();

    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getConfigFileProperty();

    @Inject
    @NotNull
    public abstract ProjectLayout getProjectLayout();

    @Inject
    @NotNull
    public abstract RepositoryHandler getRepositories();

    @Inject
    @NotNull
    public abstract DependencyHandler getDependencies();

    @NotNull
    public final String getGroup() {
        return "gradm";
    }

    @Internal
    @NotNull
    protected final GradmWorkerService getWorkerService() {
        Object object = this.getWorkerServiceProperty().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"workerServiceProperty.get()");
        return (GradmWorkerService)object;
    }

    @Internal
    @NotNull
    protected final GradmProjectPaths getGradmProjectPaths() {
        Path path = this.getProjectLayout().getProjectDirectory().getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectLayout.projectDirectory.asFile.toPath()");
        Object object = this.getProjectNameProperty().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectNameProperty.get()");
        return new GradmProjectPaths(path, (String)object);
    }

    @Internal
    @NotNull
    protected final Map<String, Object> getGradmConfigDocument() {
        GradmTask $this$_get_gradmConfigDocument__u24lambda_u240 = this;
        boolean bl = false;
        Path gradmConfigFile = ((RegularFile)$this$_get_gradmConfigDocument__u24lambda_u240.getConfigFileProperty().get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)gradmConfigFile, (String)"gradmConfigFile");
        FormatterKt.formatGradmConfig((Path)gradmConfigFile);
        return YamlKt.asYamlDocument$default((Path)gradmConfigFile, null, (int)1, null);
    }

    @TaskAction
    protected void execute() {
        this.getWorkerService().initialize(this.getRepositories(), this.getGradmConfigDocument());
    }

    private final void notCompatibleWithConfigurationCache() {
        this.notCompatibleWithConfigurationCache("Gradm is not compatible with the Gradle configuration cache.\nWaiting for https://github.com/gradle/gradle/issues/13506 to be fixed.");
    }
}

