/*
 * Decompiled with CFR 0.152.
 */
package me.omico.gradm.integration.github;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.omico.gradm.GradmConfigs;
import me.omico.gradm.GradmKt;
import me.omico.gradm.integration.GradmIntegration;
import me.omico.gradm.integration.github.GradmGithubIntegrationConfigs;
import me.omico.gradm.integration.github.internal.GradmGithubIntegrationKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bH\u0002J \u0010\r\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/omico/gradm/integration/github/GradmGithubIntegration;", "Lme/omico/gradm/integration/GradmIntegration;", "()V", "githubIntegrationConfig", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "applyVersions", "", "versions", "", "", "Lme/omico/gradm/internal/config/MutableFlatVersions;", "applyVersionsByCache", "applyVersionsIfNeeded", "github"})
public final class GradmGithubIntegration
extends GradmIntegration {
    @NotNull
    public static final GradmGithubIntegration INSTANCE = new GradmGithubIntegration();
    private static final Path githubIntegrationConfig = GradmKt.getProjectRootDir().resolve("gradm.integration.github.yml");

    private GradmGithubIntegration() {
    }

    public void applyVersions(@NotNull Map<String, String> versions) {
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Object object = githubIntegrationConfig;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"githubIntegrationConfig");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = false;
        if (!Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        if (GradmConfigs.Companion.getOffline()) {
            object = "[Gradm]: Github integration config found, but the offline mode is enabled.";
            boolean bl2 = false;
            System.out.println(object);
            this.applyVersionsByCache(versions);
        } else {
            this.applyVersionsIfNeeded(versions);
        }
    }

    private final void applyVersionsByCache(Map<String, String> versions) {
        Map<String, String> versionsMeta = GradmGithubIntegrationConfigs.INSTANCE.getLocalVersionsMeta();
        if (versionsMeta == null) {
            String string = "[Gradm]: versions-meta.txt for Github integration is not found, skipping.";
            boolean bl = false;
            System.out.println((Object)string);
        } else {
            Map<String, String> $this$forEach$iv = versionsMeta;
            boolean $i$f$forEach = false;
            Map<String, String> map = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<String, String> entry = $dstr$key$value;
                boolean bl3 = false;
                String key = entry.getKey();
                Object object = $dstr$key$value;
                boolean bl4 = false;
                String value = object.getValue();
                if (versions.containsKey(key)) {
                    object = "[Gradm]: " + key + " is already in the versions, skipping.";
                    bl4 = false;
                    System.out.println(object);
                    continue;
                }
                object = versions;
                bl4 = false;
                object.put(key, value);
            }
        }
    }

    private final void applyVersionsIfNeeded(Map<String, String> versions) {
        if (GradmConfigs.Companion.getUpdateDependencies() || GradmGithubIntegrationConfigs.INSTANCE.getLocalVersionsMeta() == null) {
            Path path = githubIntegrationConfig;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"githubIntegrationConfig");
            GradmGithubIntegrationKt.parseGithubIntegration(path, versions);
        } else {
            this.applyVersionsByCache(versions);
        }
    }
}

