/*
 * Decompiled with CFR 0.152.
 */
package me.omico.gradm.integration.github;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.omico.gradm.VersionsMetaKt;
import me.omico.gradm.internal.path.GradmPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006j\u0002`\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006j\u0004\u0018\u0001`\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/omico/gradm/integration/github/GradmGithubIntegrationConfigs;", "", "()V", "githubIntegrationDirPath", "Ljava/nio/file/Path;", "localVersionsMeta", "", "", "Lme/omico/gradm/VersionsMeta;", "getLocalVersionsMeta", "()Ljava/util/Map;", "versionsMetaHashPath", "versionsMetaPath", "updateLocalVersionsMeta", "", "versionsMeta", "github"})
public final class GradmGithubIntegrationConfigs {
    @NotNull
    public static final GradmGithubIntegrationConfigs INSTANCE = new GradmGithubIntegrationConfigs();
    @NotNull
    private static final Path githubIntegrationDirPath;
    @NotNull
    private static final Path versionsMetaPath;
    @NotNull
    private static final Path versionsMetaHashPath;

    private GradmGithubIntegrationConfigs() {
    }

    @Nullable
    public final Map<String, String> getLocalVersionsMeta() {
        return VersionsMetaKt.asVersionsMeta((Path)versionsMetaPath);
    }

    public final void updateLocalVersionsMeta(@NotNull Map<String, String> versionsMeta) {
        Intrinsics.checkNotNullParameter(versionsMeta, (String)"versionsMeta");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(githubIntegrationDirPath, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        VersionsMetaKt.store(versionsMeta, (Path)versionsMetaPath, (Path)versionsMetaHashPath);
    }

    static {
        Path path = GradmPaths.INSTANCE.getIntegrationDir().resolve("github");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"GradmPaths.integrationDir.resolve(\"github\")");
        githubIntegrationDirPath = path;
        Path path2 = githubIntegrationDirPath.resolve("versions-meta.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"githubIntegrationDirPath\u2026olve(\"versions-meta.txt\")");
        versionsMetaPath = path2;
        Path path3 = githubIntegrationDirPath.resolve("versions-meta.hash");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"githubIntegrationDirPath\u2026lve(\"versions-meta.hash\")");
        versionsMetaHashPath = path3;
    }
}

