/*
 * Decompiled with CFR 0.152.
 */
package me.omico.gradm.integration.github;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import me.omico.gradm.GradmConfigs;
import me.omico.gradm.GradmKt;
import me.omico.gradm.integration.GradmIntegration;
import me.omico.gradm.integration.github.GradmGithubIntegration;
import me.omico.gradm.integration.github.GradmGithubIntegrationConfigs;
import me.omico.gradm.integration.github.internal.GradmGithubIntegrationKt;
import me.omico.gradm.path.GradleRootProjectPaths;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bH\u0002J \u0010\r\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/omico/gradm/integration/github/GradmGithubIntegration;", "Lme/omico/gradm/integration/GradmIntegration;", "()V", "githubIntegrationConfigFile", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "applyVersions", "", "versions", "", "", "Lme/omico/gradm/internal/config/MutableFlatVersions;", "applyVersionsByCache", "applyVersionsIfNeeded", "github"})
public final class GradmGithubIntegration
extends GradmIntegration {
    @NotNull
    public static final GradmGithubIntegration INSTANCE = new GradmGithubIntegration();
    private static final Path githubIntegrationConfigFile = GradleRootProjectPaths.Companion.getPath().resolve("gradm.integration.github.yml");

    private GradmGithubIntegration() {
    }

    public void applyVersions(@NotNull Map<String, String> versions) {
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Path path = githubIntegrationConfigFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"githubIntegrationConfigFile");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        if (GradmConfigs.Companion.getOffline()) {
            GradmKt.info((Function0)applyVersions.1.INSTANCE);
            this.applyVersionsByCache(versions);
        } else {
            this.applyVersionsIfNeeded(versions);
        }
    }

    private final void applyVersionsByCache(Map<String, String> versions) {
        Map<String, String> versionsMeta = GradmGithubIntegrationConfigs.INSTANCE.getLocalVersionsMeta();
        if (versionsMeta == null) {
            GradmKt.info((Function0)applyVersionsByCache.1.INSTANCE);
        } else {
            Map<String, String> $this$forEach$iv = versionsMeta;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                String value = entry.getValue();
                if (versions.containsKey(key)) {
                    GradmKt.info((Function0)((Function0)new Function0<String>(key){
                        final /* synthetic */ String $key;
                        {
                            this.$key = $key;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return this.$key + " is already in the versions, skipping.";
                        }
                    }));
                    continue;
                }
                versions.put(key, value);
            }
        }
    }

    private final void applyVersionsIfNeeded(Map<String, String> versions) {
        if (GradmConfigs.Companion.getRequireRefresh() || GradmGithubIntegrationConfigs.INSTANCE.getLocalVersionsMeta() == null) {
            Path path = githubIntegrationConfigFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"githubIntegrationConfigFile");
            GradmGithubIntegrationKt.parseGithubIntegration(path, versions);
        } else {
            this.applyVersionsByCache(versions);
        }
    }
}

